/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RelationshipToRole;
import com.datadog.api.client.v2.model.RelationshipToSAMLAssertionAttribute;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"role", "saml_assertion_attribute"})
public class AuthNMappingRelationships {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ROLE = "role";
    private RelationshipToRole role;
    public static final String JSON_PROPERTY_SAML_ASSERTION_ATTRIBUTE = "saml_assertion_attribute";
    private RelationshipToSAMLAssertionAttribute samlAssertionAttribute;

    public AuthNMappingRelationships role(RelationshipToRole role) {
        this.role = role;
        this.unparsed |= role.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToRole getRole() {
        return this.role;
    }

    public void setRole(RelationshipToRole role) {
        this.role = role;
    }

    public AuthNMappingRelationships samlAssertionAttribute(RelationshipToSAMLAssertionAttribute samlAssertionAttribute) {
        this.samlAssertionAttribute = samlAssertionAttribute;
        this.unparsed |= samlAssertionAttribute.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="saml_assertion_attribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelationshipToSAMLAssertionAttribute getSamlAssertionAttribute() {
        return this.samlAssertionAttribute;
    }

    public void setSamlAssertionAttribute(RelationshipToSAMLAssertionAttribute samlAssertionAttribute) {
        this.samlAssertionAttribute = samlAssertionAttribute;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthNMappingRelationships authNMappingRelationships = (AuthNMappingRelationships)o;
        return Objects.equals(this.role, authNMappingRelationships.role) && Objects.equals(this.samlAssertionAttribute, authNMappingRelationships.samlAssertionAttribute);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.samlAssertionAttribute);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthNMappingRelationships {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    samlAssertionAttribute: ").append(this.toIndentedString(this.samlAssertionAttribute)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

