/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ContentEncoding;
import com.datadog.api.client.v2.model.HTTPLogItem;
import com.datadog.api.client.v2.model.Log;
import com.datadog.api.client.v2.model.LogsAggregateRequest;
import com.datadog.api.client.v2.model.LogsAggregateResponse;
import com.datadog.api.client.v2.model.LogsListRequest;
import com.datadog.api.client.v2.model.LogsListRequestPage;
import com.datadog.api.client.v2.model.LogsListResponse;
import com.datadog.api.client.v2.model.LogsSort;
import com.datadog.api.client.v2.model.LogsStorageTier;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class LogsApi {
    private ApiClient apiClient;

    public LogsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsAggregateResponse aggregateLogs(LogsAggregateRequest body) throws ApiException {
        return this.aggregateLogsWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsAggregateResponse> aggregateLogsAsync(LogsAggregateRequest body) {
        return this.aggregateLogsWithHttpInfoAsync(body).thenApply(response -> (LogsAggregateResponse)response.getData());
    }

    public ApiResponse<LogsAggregateResponse> aggregateLogsWithHttpInfo(LogsAggregateRequest body) throws ApiException {
        LogsAggregateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling aggregateLogs");
        }
        String localVarPath = "/api/v2/logs/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsApi.aggregateLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsAggregateResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsAggregateResponse>> aggregateLogsWithHttpInfoAsync(LogsAggregateRequest body) {
        Invocation.Builder builder;
        LogsAggregateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsAggregateResponse>> result = new CompletableFuture<ApiResponse<LogsAggregateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling aggregateLogs"));
            return result;
        }
        String localVarPath = "/api/v2/logs/analytics/aggregate";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsApi.aggregateLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsAggregateResponse>> result = new CompletableFuture<ApiResponse<LogsAggregateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsAggregateResponse>(){});
    }

    public LogsListResponse listLogs() throws ApiException {
        return this.listLogsWithHttpInfo(new ListLogsOptionalParameters()).getData();
    }

    public CompletableFuture<LogsListResponse> listLogsAsync() {
        return this.listLogsWithHttpInfoAsync(new ListLogsOptionalParameters()).thenApply(response -> (LogsListResponse)response.getData());
    }

    public LogsListResponse listLogs(ListLogsOptionalParameters parameters) throws ApiException {
        return this.listLogsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<LogsListResponse> listLogsAsync(ListLogsOptionalParameters parameters) {
        return this.listLogsWithHttpInfoAsync(parameters).thenApply(response -> (LogsListResponse)response.getData());
    }

    public PaginationIterable<Log> listLogsWithPagination() {
        ListLogsOptionalParameters parameters = new ListLogsOptionalParameters();
        return this.listLogsWithPagination(parameters);
    }

    public PaginationIterable<Log> listLogsWithPagination(ListLogsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new LogsListRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new LogsListRequestPage());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Log> iterator = new PaginationIterable<Log>(this, "listLogs", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<LogsListResponse> listLogsWithHttpInfo(ListLogsOptionalParameters parameters) throws ApiException {
        LogsListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/logs/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsApi.listLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsListResponse>> listLogsWithHttpInfoAsync(ListLogsOptionalParameters parameters) {
        Invocation.Builder builder;
        LogsListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/logs/events/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.LogsApi.listLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsListResponse>> result = new CompletableFuture<ApiResponse<LogsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    public LogsListResponse listLogsGet() throws ApiException {
        return this.listLogsGetWithHttpInfo(new ListLogsGetOptionalParameters()).getData();
    }

    public CompletableFuture<LogsListResponse> listLogsGetAsync() {
        return this.listLogsGetWithHttpInfoAsync(new ListLogsGetOptionalParameters()).thenApply(response -> (LogsListResponse)response.getData());
    }

    public LogsListResponse listLogsGet(ListLogsGetOptionalParameters parameters) throws ApiException {
        return this.listLogsGetWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<LogsListResponse> listLogsGetAsync(ListLogsGetOptionalParameters parameters) {
        return this.listLogsGetWithHttpInfoAsync(parameters).thenApply(response -> (LogsListResponse)response.getData());
    }

    public PaginationIterable<Log> listLogsGetWithPagination() {
        ListLogsGetOptionalParameters parameters = new ListLogsGetOptionalParameters();
        return this.listLogsGetWithPagination(parameters);
    }

    public PaginationIterable<Log> listLogsGetWithPagination(ListLogsGetOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Log> iterator = new PaginationIterable<Log>(this, "listLogsGet", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, limit, args);
        return iterator;
    }

    public ApiResponse<LogsListResponse> listLogsGetWithHttpInfo(ListLogsGetOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterIndex = parameters.filterIndex;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        LogsStorageTier filterStorageTier = parameters.filterStorageTier;
        LogsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/logs/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[index]", filterIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[storage_tier]", filterStorageTier));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsApi.listLogsGet", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsListResponse>> listLogsGetWithHttpInfoAsync(ListLogsGetOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        String filterIndex = parameters.filterIndex;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        LogsStorageTier filterStorageTier = parameters.filterStorageTier;
        LogsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/logs/events";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[index]", filterIndex));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[storage_tier]", filterStorageTier));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.LogsApi.listLogsGet", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsListResponse>> result = new CompletableFuture<ApiResponse<LogsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    public Object submitLog(List<HTTPLogItem> body) throws ApiException {
        return this.submitLogWithHttpInfo(body, new SubmitLogOptionalParameters()).getData();
    }

    public CompletableFuture<Object> submitLogAsync(List<HTTPLogItem> body) {
        return this.submitLogWithHttpInfoAsync(body, new SubmitLogOptionalParameters()).thenApply(response -> response.getData());
    }

    public Object submitLog(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        return this.submitLogWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<Object> submitLogAsync(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) {
        return this.submitLogWithHttpInfoAsync(body, parameters).thenApply(response -> response.getData());
    }

    public ApiResponse<Object> submitLogWithHttpInfo(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        List<HTTPLogItem> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitLog");
        }
        ContentEncoding contentEncoding = parameters.contentEncoding;
        String ddtags = parameters.ddtags;
        String localVarPath = "/api/v2/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddtags", ddtags));
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v2.LogsApi.submitLog", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json", "application/logplex-1", "text/plain"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> submitLogWithHttpInfoAsync(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) {
        Invocation.Builder builder;
        List<HTTPLogItem> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitLog"));
            return result;
        }
        ContentEncoding contentEncoding = parameters.contentEncoding;
        String ddtags = parameters.ddtags;
        String localVarPath = "/api/v2/logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddtags", ddtags));
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        try {
            builder = this.apiClient.createBuilder("v2.LogsApi.submitLog", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json", "application/logplex-1", "text/plain"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public static class SubmitLogOptionalParameters {
        private ContentEncoding contentEncoding;
        private String ddtags;

        public SubmitLogOptionalParameters contentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SubmitLogOptionalParameters ddtags(String ddtags) {
            this.ddtags = ddtags;
            return this;
        }
    }

    public static class ListLogsGetOptionalParameters {
        private String filterQuery;
        private String filterIndex;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private LogsStorageTier filterStorageTier;
        private LogsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListLogsGetOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListLogsGetOptionalParameters filterIndex(String filterIndex) {
            this.filterIndex = filterIndex;
            return this;
        }

        public ListLogsGetOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListLogsGetOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListLogsGetOptionalParameters filterStorageTier(LogsStorageTier filterStorageTier) {
            this.filterStorageTier = filterStorageTier;
            return this;
        }

        public ListLogsGetOptionalParameters sort(LogsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListLogsGetOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListLogsGetOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListLogsOptionalParameters {
        private LogsListRequest body;

        public ListLogsOptionalParameters body(LogsListRequest body) {
            this.body = body;
            return this;
        }
    }
}

