/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=WidgetComparatorSerializer.class)
public class WidgetComparator {
    public static final WidgetComparator GREATER_THAN = new WidgetComparator(">");
    public static final WidgetComparator GREATER_THAN_OR_EQUAL_TO = new WidgetComparator(">=");
    public static final WidgetComparator LESS_THAN = new WidgetComparator("<");
    public static final WidgetComparator LESS_THAN_OR_EQUAL_TO = new WidgetComparator("<=");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList(">", ">=", "<", "<="));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    WidgetComparator(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((WidgetComparator)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static WidgetComparator fromValue(String value) {
        return new WidgetComparator(value);
    }

    public static class WidgetComparatorSerializer
    extends StdSerializer<WidgetComparator> {
        public WidgetComparatorSerializer(Class<WidgetComparator> t) {
            super(t);
        }

        public WidgetComparatorSerializer() {
            this(null);
        }

        public void serialize(WidgetComparator value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

