/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsExclusion;
import com.datadog.api.client.v1.model.LogsFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"daily_limit", "exclusion_filters", "filter", "is_rate_limited", "name", "num_retention_days"})
public class LogsIndex {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DAILY_LIMIT = "daily_limit";
    private Long dailyLimit;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<LogsExclusion> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_IS_RATE_LIMITED = "is_rate_limited";
    private Boolean isRateLimited;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NUM_RETENTION_DAYS = "num_retention_days";
    private Long numRetentionDays;

    public LogsIndex() {
    }

    @JsonCreator
    public LogsIndex(@JsonProperty(required=true, value="filter") LogsFilter filter, @JsonProperty(required=true, value="name") String name) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        this.name = name;
    }

    public LogsIndex dailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDailyLimit() {
        return this.dailyLimit;
    }

    public void setDailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    public LogsIndex exclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (LogsExclusion item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsIndex addExclusionFiltersItem(LogsExclusion exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<LogsExclusion>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsExclusion> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public LogsIndex filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    @Nullable
    @JsonProperty(value="is_rate_limited")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsRateLimited() {
        return this.isRateLimited;
    }

    public LogsIndex name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsIndex numRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_retention_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumRetentionDays() {
        return this.numRetentionDays;
    }

    public void setNumRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsIndex logsIndex = (LogsIndex)o;
        return Objects.equals(this.dailyLimit, logsIndex.dailyLimit) && Objects.equals(this.exclusionFilters, logsIndex.exclusionFilters) && Objects.equals(this.filter, logsIndex.filter) && Objects.equals(this.isRateLimited, logsIndex.isRateLimited) && Objects.equals(this.name, logsIndex.name) && Objects.equals(this.numRetentionDays, logsIndex.numRetentionDays);
    }

    public int hashCode() {
        return Objects.hash(this.dailyLimit, this.exclusionFilters, this.filter, this.isRateLimited, this.name, this.numRetentionDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsIndex {\n");
        sb.append("    dailyLimit: ").append(this.toIndentedString(this.dailyLimit)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    isRateLimited: ").append(this.toIndentedString(this.isRateLimited)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    numRetentionDays: ").append(this.toIndentedString(this.numRetentionDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

