/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.ApiKey;
import com.datadog.api.client.v1.model.ApiKeyListResponse;
import com.datadog.api.client.v1.model.ApiKeyResponse;
import com.datadog.api.client.v1.model.ApplicationKey;
import com.datadog.api.client.v1.model.ApplicationKeyListResponse;
import com.datadog.api.client.v1.model.ApplicationKeyResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class KeyManagementApi {
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiKeyResponse createAPIKey(ApiKey body) throws ApiException {
        return this.createAPIKeyWithHttpInfo(body).getData();
    }

    public CompletableFuture<ApiKeyResponse> createAPIKeyAsync(ApiKey body) {
        return this.createAPIKeyWithHttpInfoAsync(body).thenApply(response -> (ApiKeyResponse)response.getData());
    }

    public ApiResponse<ApiKeyResponse> createAPIKeyWithHttpInfo(ApiKey body) throws ApiException {
        ApiKey localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey");
        }
        String localVarPath = "/api/v1/api_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.createAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApiKeyResponse>> createAPIKeyWithHttpInfoAsync(ApiKey body) {
        Invocation.Builder builder;
        ApiKey localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAPIKey"));
            return result;
        }
        String localVarPath = "/api/v1/api_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.createAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public ApplicationKeyResponse createApplicationKey(ApplicationKey body) throws ApiException {
        return this.createApplicationKeyWithHttpInfo(body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> createApplicationKeyAsync(ApplicationKey body) {
        return this.createApplicationKeyWithHttpInfoAsync(body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> createApplicationKeyWithHttpInfo(ApplicationKey body) throws ApiException {
        ApplicationKey localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createApplicationKey");
        }
        String localVarPath = "/api/v1/application_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.createApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> createApplicationKeyWithHttpInfoAsync(ApplicationKey body) {
        Invocation.Builder builder;
        ApplicationKey localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v1/application_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.createApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public ApiKeyResponse deleteAPIKey(String key) throws ApiException {
        return this.deleteAPIKeyWithHttpInfo(key).getData();
    }

    public CompletableFuture<ApiKeyResponse> deleteAPIKeyAsync(String key) {
        return this.deleteAPIKeyWithHttpInfoAsync(key).thenApply(response -> (ApiKeyResponse)response.getData());
    }

    public ApiResponse<ApiKeyResponse> deleteAPIKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.deleteAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApiKeyResponse>> deleteAPIKeyWithHttpInfoAsync(String key) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (key == null) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling deleteAPIKey"));
            return result;
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.deleteAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public ApplicationKeyResponse deleteApplicationKey(String key) throws ApiException {
        return this.deleteApplicationKeyWithHttpInfo(key).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> deleteApplicationKeyAsync(String key) {
        return this.deleteApplicationKeyWithHttpInfoAsync(key).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> deleteApplicationKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling deleteApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.deleteApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> deleteApplicationKeyWithHttpInfoAsync(String key) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (key == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling deleteApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.deleteApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public ApiKeyResponse getAPIKey(String key) throws ApiException {
        return this.getAPIKeyWithHttpInfo(key).getData();
    }

    public CompletableFuture<ApiKeyResponse> getAPIKeyAsync(String key) {
        return this.getAPIKeyWithHttpInfoAsync(key).thenApply(response -> (ApiKeyResponse)response.getData());
    }

    public ApiResponse<ApiKeyResponse> getAPIKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.getAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApiKeyResponse>> getAPIKeyWithHttpInfoAsync(String key) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (key == null) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling getAPIKey"));
            return result;
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.getAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public ApplicationKeyResponse getApplicationKey(String key) throws ApiException {
        return this.getApplicationKeyWithHttpInfo(key).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> getApplicationKeyAsync(String key) {
        return this.getApplicationKeyWithHttpInfoAsync(key).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> getApplicationKeyWithHttpInfo(String key) throws ApiException {
        Object localVarPostBody = null;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling getApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.getApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> getApplicationKeyWithHttpInfoAsync(String key) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (key == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling getApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.getApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public ApiKeyListResponse listAPIKeys() throws ApiException {
        return this.listAPIKeysWithHttpInfo().getData();
    }

    public CompletableFuture<ApiKeyListResponse> listAPIKeysAsync() {
        return this.listAPIKeysWithHttpInfoAsync().thenApply(response -> (ApiKeyListResponse)response.getData());
    }

    public ApiResponse<ApiKeyListResponse> listAPIKeysWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/api_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.listAPIKeys", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyListResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApiKeyListResponse>> listAPIKeysWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/api_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.listAPIKeys", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApiKeyListResponse>> result = new CompletableFuture<ApiResponse<ApiKeyListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyListResponse>(){});
    }

    public ApplicationKeyListResponse listApplicationKeys() throws ApiException {
        return this.listApplicationKeysWithHttpInfo().getData();
    }

    public CompletableFuture<ApplicationKeyListResponse> listApplicationKeysAsync() {
        return this.listApplicationKeysWithHttpInfoAsync().thenApply(response -> (ApplicationKeyListResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyListResponse> listApplicationKeysWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/application_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.listApplicationKeys", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyListResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyListResponse>> listApplicationKeysWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/application_key";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.listApplicationKeys", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyListResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyListResponse>(){});
    }

    public ApiKeyResponse updateAPIKey(String key, ApiKey body) throws ApiException {
        return this.updateAPIKeyWithHttpInfo(key, body).getData();
    }

    public CompletableFuture<ApiKeyResponse> updateAPIKeyAsync(String key, ApiKey body) {
        return this.updateAPIKeyWithHttpInfoAsync(key, body).thenApply(response -> (ApiKeyResponse)response.getData());
    }

    public ApiResponse<ApiKeyResponse> updateAPIKeyWithHttpInfo(String key, ApiKey body) throws ApiException {
        ApiKey localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateAPIKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey");
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.updateAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApiKeyResponse>> updateAPIKeyWithHttpInfoAsync(String key, ApiKey body) {
        Invocation.Builder builder;
        ApiKey localVarPostBody = body;
        if (key == null) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling updateAPIKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAPIKey"));
            return result;
        }
        String localVarPath = "/api/v1/api_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.updateAPIKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApiKeyResponse>> result = new CompletableFuture<ApiResponse<ApiKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApiKeyResponse>(){});
    }

    public ApplicationKeyResponse updateApplicationKey(String key, ApplicationKey body) throws ApiException {
        return this.updateApplicationKeyWithHttpInfo(key, body).getData();
    }

    public CompletableFuture<ApplicationKeyResponse> updateApplicationKeyAsync(String key, ApplicationKey body) {
        return this.updateApplicationKeyWithHttpInfoAsync(key, body).thenApply(response -> (ApplicationKeyResponse)response.getData());
    }

    public ApiResponse<ApplicationKeyResponse> updateApplicationKeyWithHttpInfo(String key, ApplicationKey body) throws ApiException {
        ApplicationKey localVarPostBody = body;
        if (key == null) {
            throw new ApiException(400, "Missing the required parameter 'key' when calling updateApplicationKey");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey");
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.KeyManagementApi.updateApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }

    public CompletableFuture<ApiResponse<ApplicationKeyResponse>> updateApplicationKeyWithHttpInfoAsync(String key, ApplicationKey body) {
        Invocation.Builder builder;
        ApplicationKey localVarPostBody = body;
        if (key == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'key' when calling updateApplicationKey"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateApplicationKey"));
            return result;
        }
        String localVarPath = "/api/v1/application_key/{key}".replaceAll("\\{key\\}", this.apiClient.escapeString(key.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("KeyManagementApi.updateApplicationKey", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ApplicationKeyResponse>> result = new CompletableFuture<ApiResponse<ApplicationKeyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ApplicationKeyResponse>(){});
    }
}

