/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetDeploymentOperation;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config_operations", "filter_query"})
public class FleetDeploymentConfigureAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG_OPERATIONS = "config_operations";
    private List<FleetDeploymentOperation> configOperations = new ArrayList<FleetDeploymentOperation>();
    public static final String JSON_PROPERTY_FILTER_QUERY = "filter_query";
    private String filterQuery;
    private Map<String, Object> additionalProperties;

    public FleetDeploymentConfigureAttributes() {
    }

    @JsonCreator
    public FleetDeploymentConfigureAttributes(@JsonProperty(required=true, value="config_operations") List<FleetDeploymentOperation> configOperations) {
        this.configOperations = configOperations;
    }

    public FleetDeploymentConfigureAttributes configOperations(List<FleetDeploymentOperation> configOperations) {
        this.configOperations = configOperations;
        for (FleetDeploymentOperation item : configOperations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetDeploymentConfigureAttributes addConfigOperationsItem(FleetDeploymentOperation configOperationsItem) {
        this.configOperations.add(configOperationsItem);
        this.unparsed |= configOperationsItem.unparsed;
        return this;
    }

    @JsonProperty(value="config_operations")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<FleetDeploymentOperation> getConfigOperations() {
        return this.configOperations;
    }

    public void setConfigOperations(List<FleetDeploymentOperation> configOperations) {
        this.configOperations = configOperations;
    }

    public FleetDeploymentConfigureAttributes filterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilterQuery() {
        return this.filterQuery;
    }

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    @JsonAnySetter
    public FleetDeploymentConfigureAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetDeploymentConfigureAttributes fleetDeploymentConfigureAttributes = (FleetDeploymentConfigureAttributes)o;
        return Objects.equals(this.configOperations, fleetDeploymentConfigureAttributes.configOperations) && Objects.equals(this.filterQuery, fleetDeploymentConfigureAttributes.filterQuery) && Objects.equals(this.additionalProperties, fleetDeploymentConfigureAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.configOperations, this.filterQuery, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetDeploymentConfigureAttributes {\n");
        sb.append("    configOperations: ").append(this.toIndentedString(this.configOperations)).append("\n");
        sb.append("    filterQuery: ").append(this.toIndentedString(this.filterQuery)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

