/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetDeploymentHost;
import com.datadog.api.client.v2.model.FleetDeploymentOperation;
import com.datadog.api.client.v2.model.FleetDeploymentPackage;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config_operations", "estimated_end_time_unix", "filter_query", "high_level_status", "hosts", "packages", "total_hosts"})
public class FleetDeploymentAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG_OPERATIONS = "config_operations";
    private List<FleetDeploymentOperation> configOperations = null;
    public static final String JSON_PROPERTY_ESTIMATED_END_TIME_UNIX = "estimated_end_time_unix";
    private Long estimatedEndTimeUnix;
    public static final String JSON_PROPERTY_FILTER_QUERY = "filter_query";
    private String filterQuery;
    public static final String JSON_PROPERTY_HIGH_LEVEL_STATUS = "high_level_status";
    private String highLevelStatus;
    public static final String JSON_PROPERTY_HOSTS = "hosts";
    private List<FleetDeploymentHost> hosts = null;
    public static final String JSON_PROPERTY_PACKAGES = "packages";
    private List<FleetDeploymentPackage> packages = null;
    public static final String JSON_PROPERTY_TOTAL_HOSTS = "total_hosts";
    private Long totalHosts;
    private Map<String, Object> additionalProperties;

    public FleetDeploymentAttributes configOperations(List<FleetDeploymentOperation> configOperations) {
        this.configOperations = configOperations;
        for (FleetDeploymentOperation item : configOperations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetDeploymentAttributes addConfigOperationsItem(FleetDeploymentOperation configOperationsItem) {
        if (this.configOperations == null) {
            this.configOperations = new ArrayList<FleetDeploymentOperation>();
        }
        this.configOperations.add(configOperationsItem);
        this.unparsed |= configOperationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="config_operations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetDeploymentOperation> getConfigOperations() {
        return this.configOperations;
    }

    public void setConfigOperations(List<FleetDeploymentOperation> configOperations) {
        this.configOperations = configOperations;
    }

    public FleetDeploymentAttributes estimatedEndTimeUnix(Long estimatedEndTimeUnix) {
        this.estimatedEndTimeUnix = estimatedEndTimeUnix;
        return this;
    }

    @Nullable
    @JsonProperty(value="estimated_end_time_unix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getEstimatedEndTimeUnix() {
        return this.estimatedEndTimeUnix;
    }

    public void setEstimatedEndTimeUnix(Long estimatedEndTimeUnix) {
        this.estimatedEndTimeUnix = estimatedEndTimeUnix;
    }

    public FleetDeploymentAttributes filterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilterQuery() {
        return this.filterQuery;
    }

    public void setFilterQuery(String filterQuery) {
        this.filterQuery = filterQuery;
    }

    public FleetDeploymentAttributes highLevelStatus(String highLevelStatus) {
        this.highLevelStatus = highLevelStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="high_level_status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHighLevelStatus() {
        return this.highLevelStatus;
    }

    public void setHighLevelStatus(String highLevelStatus) {
        this.highLevelStatus = highLevelStatus;
    }

    public FleetDeploymentAttributes hosts(List<FleetDeploymentHost> hosts) {
        this.hosts = hosts;
        for (FleetDeploymentHost item : hosts) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetDeploymentAttributes addHostsItem(FleetDeploymentHost hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<FleetDeploymentHost>();
        }
        this.hosts.add(hostsItem);
        this.unparsed |= hostsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="hosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetDeploymentHost> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<FleetDeploymentHost> hosts) {
        this.hosts = hosts;
    }

    public FleetDeploymentAttributes packages(List<FleetDeploymentPackage> packages) {
        this.packages = packages;
        for (FleetDeploymentPackage item : packages) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetDeploymentAttributes addPackagesItem(FleetDeploymentPackage packagesItem) {
        if (this.packages == null) {
            this.packages = new ArrayList<FleetDeploymentPackage>();
        }
        this.packages.add(packagesItem);
        this.unparsed |= packagesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="packages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetDeploymentPackage> getPackages() {
        return this.packages;
    }

    public void setPackages(List<FleetDeploymentPackage> packages) {
        this.packages = packages;
    }

    public FleetDeploymentAttributes totalHosts(Long totalHosts) {
        this.totalHosts = totalHosts;
        return this;
    }

    @Nullable
    @JsonProperty(value="total_hosts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTotalHosts() {
        return this.totalHosts;
    }

    public void setTotalHosts(Long totalHosts) {
        this.totalHosts = totalHosts;
    }

    @JsonAnySetter
    public FleetDeploymentAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetDeploymentAttributes fleetDeploymentAttributes = (FleetDeploymentAttributes)o;
        return Objects.equals(this.configOperations, fleetDeploymentAttributes.configOperations) && Objects.equals(this.estimatedEndTimeUnix, fleetDeploymentAttributes.estimatedEndTimeUnix) && Objects.equals(this.filterQuery, fleetDeploymentAttributes.filterQuery) && Objects.equals(this.highLevelStatus, fleetDeploymentAttributes.highLevelStatus) && Objects.equals(this.hosts, fleetDeploymentAttributes.hosts) && Objects.equals(this.packages, fleetDeploymentAttributes.packages) && Objects.equals(this.totalHosts, fleetDeploymentAttributes.totalHosts) && Objects.equals(this.additionalProperties, fleetDeploymentAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.configOperations, this.estimatedEndTimeUnix, this.filterQuery, this.highLevelStatus, this.hosts, this.packages, this.totalHosts, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetDeploymentAttributes {\n");
        sb.append("    configOperations: ").append(this.toIndentedString(this.configOperations)).append("\n");
        sb.append("    estimatedEndTimeUnix: ").append(this.toIndentedString(this.estimatedEndTimeUnix)).append("\n");
        sb.append("    filterQuery: ").append(this.toIndentedString(this.filterQuery)).append("\n");
        sb.append("    highLevelStatus: ").append(this.toIndentedString(this.highLevelStatus)).append("\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    packages: ").append(this.toIndentedString(this.packages)).append("\n");
        sb.append("    totalHosts: ").append(this.toIndentedString(this.totalHosts)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

