/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CaseAttributes;
import com.datadog.api.client.v2.model.CaseRelationships;
import com.datadog.api.client.v2.model.CaseResourceType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class Case {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private CaseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private CaseRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CaseResourceType type = CaseResourceType.CASE;
    private Map<String, Object> additionalProperties;

    public Case() {
    }

    @JsonCreator
    public Case(@JsonProperty(required=true, value="attributes") CaseAttributes attributes, @JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") CaseResourceType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public Case attributes(CaseAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CaseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(CaseAttributes attributes) {
        this.attributes = attributes;
    }

    public Case id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Case relationships(CaseRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CaseRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(CaseRelationships relationships) {
        this.relationships = relationships;
    }

    public Case type(CaseResourceType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CaseResourceType getType() {
        return this.type;
    }

    public void setType(CaseResourceType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public Case putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Case _case = (Case)o;
        return Objects.equals(this.attributes, _case.attributes) && Objects.equals(this.id, _case.id) && Objects.equals(this.relationships, _case.relationships) && Objects.equals(this.type, _case.type) && Objects.equals(this.additionalProperties, _case.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Case {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

