/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSEventBridgeCreateStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"event_source_name", "has_bus", "region", "status"})
public class AWSEventBridgeCreateResponseAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_EVENT_SOURCE_NAME = "event_source_name";
    private String eventSourceName;
    public static final String JSON_PROPERTY_HAS_BUS = "has_bus";
    private Boolean hasBus;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    public static final String JSON_PROPERTY_STATUS = "status";
    private AWSEventBridgeCreateStatus status;
    private Map<String, Object> additionalProperties;

    public AWSEventBridgeCreateResponseAttributes eventSourceName(String eventSourceName) {
        this.eventSourceName = eventSourceName;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_source_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventSourceName() {
        return this.eventSourceName;
    }

    public void setEventSourceName(String eventSourceName) {
        this.eventSourceName = eventSourceName;
    }

    public AWSEventBridgeCreateResponseAttributes hasBus(Boolean hasBus) {
        this.hasBus = hasBus;
        return this;
    }

    @Nullable
    @JsonProperty(value="has_bus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasBus() {
        return this.hasBus;
    }

    public void setHasBus(Boolean hasBus) {
        this.hasBus = hasBus;
    }

    public AWSEventBridgeCreateResponseAttributes region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public AWSEventBridgeCreateResponseAttributes status(AWSEventBridgeCreateStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSEventBridgeCreateStatus getStatus() {
        return this.status;
    }

    public void setStatus(AWSEventBridgeCreateStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    @JsonAnySetter
    public AWSEventBridgeCreateResponseAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSEventBridgeCreateResponseAttributes awsEventBridgeCreateResponseAttributes = (AWSEventBridgeCreateResponseAttributes)o;
        return Objects.equals(this.eventSourceName, awsEventBridgeCreateResponseAttributes.eventSourceName) && Objects.equals(this.hasBus, awsEventBridgeCreateResponseAttributes.hasBus) && Objects.equals(this.region, awsEventBridgeCreateResponseAttributes.region) && Objects.equals(this.status, awsEventBridgeCreateResponseAttributes.status) && Objects.equals(this.additionalProperties, awsEventBridgeCreateResponseAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.eventSourceName, this.hasBus, this.region, this.status, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSEventBridgeCreateResponseAttributes {\n");
        sb.append("    eventSourceName: ").append(this.toIndentedString(this.eventSourceName)).append("\n");
        sb.append("    hasBus: ").append(this.toIndentedString(this.hasBus)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

