/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ContainerImageItem;
import com.datadog.api.client.v2.model.ContainerImagesResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class ContainerImagesApi {
    private ApiClient apiClient;

    public ContainerImagesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ContainerImagesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ContainerImagesResponse listContainerImages() throws ApiException {
        return this.listContainerImagesWithHttpInfo(new ListContainerImagesOptionalParameters()).getData();
    }

    public CompletableFuture<ContainerImagesResponse> listContainerImagesAsync() {
        return this.listContainerImagesWithHttpInfoAsync(new ListContainerImagesOptionalParameters()).thenApply(response -> (ContainerImagesResponse)response.getData());
    }

    public ContainerImagesResponse listContainerImages(ListContainerImagesOptionalParameters parameters) throws ApiException {
        return this.listContainerImagesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ContainerImagesResponse> listContainerImagesAsync(ListContainerImagesOptionalParameters parameters) {
        return this.listContainerImagesWithHttpInfoAsync(parameters).thenApply(response -> (ContainerImagesResponse)response.getData());
    }

    public PaginationIterable<ContainerImageItem> listContainerImagesWithPagination() {
        ListContainerImagesOptionalParameters parameters = new ListContainerImagesOptionalParameters();
        return this.listContainerImagesWithPagination(parameters);
    }

    public PaginationIterable<ContainerImageItem> listContainerImagesWithPagination(ListContainerImagesOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPagination.getNextCursor";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageSize == null) {
            limit = 1000;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<ContainerImageItem> iterator = new PaginationIterable<ContainerImageItem>(this, "listContainerImages", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ContainerImagesResponse> listContainerImagesWithHttpInfo(ListContainerImagesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterTags = parameters.filterTags;
        String groupBy = parameters.groupBy;
        String sort = parameters.sort;
        Integer pageSize = parameters.pageSize;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/container_images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ContainerImagesApi.listContainerImages", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ContainerImagesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ContainerImagesResponse>> listContainerImagesWithHttpInfoAsync(ListContainerImagesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterTags = parameters.filterTags;
        String groupBy = parameters.groupBy;
        String sort = parameters.sort;
        Integer pageSize = parameters.pageSize;
        String pageCursor = parameters.pageCursor;
        String localVarPath = "/api/v2/container_images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "group_by", groupBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        try {
            builder = this.apiClient.createBuilder("v2.ContainerImagesApi.listContainerImages", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ContainerImagesResponse>> result = new CompletableFuture<ApiResponse<ContainerImagesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ContainerImagesResponse>(){});
    }

    public static class ListContainerImagesOptionalParameters {
        private String filterTags;
        private String groupBy;
        private String sort;
        private Integer pageSize;
        private String pageCursor;

        public ListContainerImagesOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListContainerImagesOptionalParameters groupBy(String groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public ListContainerImagesOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListContainerImagesOptionalParameters pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListContainerImagesOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }
    }
}

