/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsSchemaRemapperType;
import com.datadog.api.client.v1.model.TargetFormatType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "override_on_conflict", "preserve_source", "sources", "target", "target_format", "type"})
public class LogsSchemaRemapper {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OVERRIDE_ON_CONFLICT = "override_on_conflict";
    private Boolean overrideOnConflict = false;
    public static final String JSON_PROPERTY_PRESERVE_SOURCE = "preserve_source";
    private Boolean preserveSource = false;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources = new ArrayList<String>();
    public static final String JSON_PROPERTY_TARGET = "target";
    private String target;
    public static final String JSON_PROPERTY_TARGET_FORMAT = "target_format";
    private TargetFormatType targetFormat;
    public static final String JSON_PROPERTY_TYPE = "type";
    private LogsSchemaRemapperType type;
    private Map<String, Object> additionalProperties;

    public LogsSchemaRemapper() {
    }

    @JsonCreator
    public LogsSchemaRemapper(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="sources") List<String> sources, @JsonProperty(required=true, value="target") String target, @JsonProperty(required=true, value="type") LogsSchemaRemapperType type) {
        this.name = name;
        this.sources = sources;
        this.target = target;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public LogsSchemaRemapper name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LogsSchemaRemapper overrideOnConflict(Boolean overrideOnConflict) {
        this.overrideOnConflict = overrideOnConflict;
        return this;
    }

    @Nullable
    @JsonProperty(value="override_on_conflict")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getOverrideOnConflict() {
        return this.overrideOnConflict;
    }

    public void setOverrideOnConflict(Boolean overrideOnConflict) {
        this.overrideOnConflict = overrideOnConflict;
    }

    public LogsSchemaRemapper preserveSource(Boolean preserveSource) {
        this.preserveSource = preserveSource;
        return this;
    }

    @Nullable
    @JsonProperty(value="preserve_source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPreserveSource() {
        return this.preserveSource;
    }

    public void setPreserveSource(Boolean preserveSource) {
        this.preserveSource = preserveSource;
    }

    public LogsSchemaRemapper sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public LogsSchemaRemapper addSourcesItem(String sourcesItem) {
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getSources() {
        return this.sources;
    }

    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public LogsSchemaRemapper target(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public LogsSchemaRemapper targetFormat(TargetFormatType targetFormat) {
        this.targetFormat = targetFormat;
        this.unparsed |= !targetFormat.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="target_format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TargetFormatType getTargetFormat() {
        return this.targetFormat;
    }

    public void setTargetFormat(TargetFormatType targetFormat) {
        if (!targetFormat.isValid()) {
            this.unparsed = true;
        }
        this.targetFormat = targetFormat;
    }

    public LogsSchemaRemapper type(LogsSchemaRemapperType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsSchemaRemapperType getType() {
        return this.type;
    }

    public void setType(LogsSchemaRemapperType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public LogsSchemaRemapper putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsSchemaRemapper logsSchemaRemapper = (LogsSchemaRemapper)o;
        return Objects.equals(this.name, logsSchemaRemapper.name) && Objects.equals(this.overrideOnConflict, logsSchemaRemapper.overrideOnConflict) && Objects.equals(this.preserveSource, logsSchemaRemapper.preserveSource) && Objects.equals(this.sources, logsSchemaRemapper.sources) && Objects.equals(this.target, logsSchemaRemapper.target) && Objects.equals(this.targetFormat, logsSchemaRemapper.targetFormat) && Objects.equals(this.type, logsSchemaRemapper.type) && Objects.equals(this.additionalProperties, logsSchemaRemapper.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.overrideOnConflict, this.preserveSource, this.sources, this.target, this.targetFormat, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsSchemaRemapper {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    overrideOnConflict: ").append(this.toIndentedString(this.overrideOnConflict)).append("\n");
        sb.append("    preserveSource: ").append(this.toIndentedString(this.preserveSource)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    targetFormat: ").append(this.toIndentedString(this.targetFormat)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

