/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"class_name", "class_uid", "profiles", "schema_type", "version"})
public class LogsSchemaData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CLASS_NAME = "class_name";
    private String className;
    public static final String JSON_PROPERTY_CLASS_UID = "class_uid";
    private Long classUid;
    public static final String JSON_PROPERTY_PROFILES = "profiles";
    private List<String> profiles = null;
    public static final String JSON_PROPERTY_SCHEMA_TYPE = "schema_type";
    private String schemaType;
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    private Map<String, Object> additionalProperties;

    public LogsSchemaData() {
    }

    @JsonCreator
    public LogsSchemaData(@JsonProperty(required=true, value="class_name") String className, @JsonProperty(required=true, value="class_uid") Long classUid, @JsonProperty(required=true, value="schema_type") String schemaType, @JsonProperty(required=true, value="version") String version) {
        this.className = className;
        this.classUid = classUid;
        this.schemaType = schemaType;
        this.version = version;
    }

    public LogsSchemaData className(String className) {
        this.className = className;
        return this;
    }

    @JsonProperty(value="class_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public LogsSchemaData classUid(Long classUid) {
        this.classUid = classUid;
        return this;
    }

    @JsonProperty(value="class_uid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getClassUid() {
        return this.classUid;
    }

    public void setClassUid(Long classUid) {
        this.classUid = classUid;
    }

    public LogsSchemaData profiles(List<String> profiles) {
        this.profiles = profiles;
        return this;
    }

    public LogsSchemaData addProfilesItem(String profilesItem) {
        if (this.profiles == null) {
            this.profiles = new ArrayList<String>();
        }
        this.profiles.add(profilesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="profiles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    public LogsSchemaData schemaType(String schemaType) {
        this.schemaType = schemaType;
        return this;
    }

    @JsonProperty(value="schema_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(String schemaType) {
        this.schemaType = schemaType;
    }

    public LogsSchemaData version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonAnySetter
    public LogsSchemaData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsSchemaData logsSchemaData = (LogsSchemaData)o;
        return Objects.equals(this.className, logsSchemaData.className) && Objects.equals(this.classUid, logsSchemaData.classUid) && Objects.equals(this.profiles, logsSchemaData.profiles) && Objects.equals(this.schemaType, logsSchemaData.schemaType) && Objects.equals(this.version, logsSchemaData.version) && Objects.equals(this.additionalProperties, logsSchemaData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.classUid, this.profiles, this.schemaType, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsSchemaData {\n");
        sb.append("    className: ").append(this.toIndentedString(this.className)).append("\n");
        sb.append("    classUid: ").append(this.toIndentedString(this.classUid)).append("\n");
        sb.append("    profiles: ").append(this.toIndentedString(this.profiles)).append("\n");
        sb.append("    schemaType: ").append(this.toIndentedString(this.schemaType)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

