/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AssetType;
import com.datadog.api.client.v2.model.AttachCaseRequest;
import com.datadog.api.client.v2.model.AttachJiraIssueRequest;
import com.datadog.api.client.v2.model.BulkMuteFindingsRequest;
import com.datadog.api.client.v2.model.BulkMuteFindingsResponse;
import com.datadog.api.client.v2.model.CloudAssetType;
import com.datadog.api.client.v2.model.ConvertJobResultsToSignalsRequest;
import com.datadog.api.client.v2.model.CreateCaseRequestArray;
import com.datadog.api.client.v2.model.CreateCustomFrameworkRequest;
import com.datadog.api.client.v2.model.CreateCustomFrameworkResponse;
import com.datadog.api.client.v2.model.CreateJiraIssueRequestArray;
import com.datadog.api.client.v2.model.CreateNotificationRuleParameters;
import com.datadog.api.client.v2.model.DeleteCustomFrameworkResponse;
import com.datadog.api.client.v2.model.DetachCaseRequest;
import com.datadog.api.client.v2.model.Finding;
import com.datadog.api.client.v2.model.FindingCaseResponse;
import com.datadog.api.client.v2.model.FindingCaseResponseArray;
import com.datadog.api.client.v2.model.FindingEvaluation;
import com.datadog.api.client.v2.model.FindingStatus;
import com.datadog.api.client.v2.model.FindingVulnerabilityType;
import com.datadog.api.client.v2.model.GetCustomFrameworkResponse;
import com.datadog.api.client.v2.model.GetFindingResponse;
import com.datadog.api.client.v2.model.GetMultipleRulesetsRequest;
import com.datadog.api.client.v2.model.GetMultipleRulesetsResponse;
import com.datadog.api.client.v2.model.GetResourceEvaluationFiltersResponse;
import com.datadog.api.client.v2.model.GetRuleVersionHistoryResponse;
import com.datadog.api.client.v2.model.GetSBOMResponse;
import com.datadog.api.client.v2.model.JobCreateResponse;
import com.datadog.api.client.v2.model.ListAssetsSBOMsResponse;
import com.datadog.api.client.v2.model.ListFindingsResponse;
import com.datadog.api.client.v2.model.ListThreatHuntingJobsResponse;
import com.datadog.api.client.v2.model.ListVulnerabilitiesResponse;
import com.datadog.api.client.v2.model.ListVulnerableAssetsResponse;
import com.datadog.api.client.v2.model.NotificationRuleResponse;
import com.datadog.api.client.v2.model.PatchNotificationRuleParameters;
import com.datadog.api.client.v2.model.RunThreatHuntingJobRequest;
import com.datadog.api.client.v2.model.SBOMComponentLicenseType;
import com.datadog.api.client.v2.model.SBOMFormat;
import com.datadog.api.client.v2.model.ScannedAssetsMetadata;
import com.datadog.api.client.v2.model.SecretRuleArray;
import com.datadog.api.client.v2.model.SecurityFilterCreateRequest;
import com.datadog.api.client.v2.model.SecurityFilterResponse;
import com.datadog.api.client.v2.model.SecurityFilterUpdateRequest;
import com.datadog.api.client.v2.model.SecurityFiltersResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringListRulesResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleConvertPayload;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleConvertResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleCreatePayload;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleTestRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleTestResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleUpdatePayload;
import com.datadog.api.client.v2.model.SecurityMonitoringRuleValidatePayload;
import com.datadog.api.client.v2.model.SecurityMonitoringSignal;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalAssigneeUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalIncidentsUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalListRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalListRequestPage;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalStateUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalTriageUpdateResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalsListResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSignalsSort;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionCreateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionResponse;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionUpdateRequest;
import com.datadog.api.client.v2.model.SecurityMonitoringSuppressionsResponse;
import com.datadog.api.client.v2.model.ThreatHuntingJobResponse;
import com.datadog.api.client.v2.model.UpdateCustomFrameworkRequest;
import com.datadog.api.client.v2.model.UpdateCustomFrameworkResponse;
import com.datadog.api.client.v2.model.UpdateResourceEvaluationFiltersRequest;
import com.datadog.api.client.v2.model.UpdateResourceEvaluationFiltersResponse;
import com.datadog.api.client.v2.model.VulnerabilityEcosystem;
import com.datadog.api.client.v2.model.VulnerabilitySeverity;
import com.datadog.api.client.v2.model.VulnerabilityStatus;
import com.datadog.api.client.v2.model.VulnerabilityTool;
import com.datadog.api.client.v2.model.VulnerabilityType;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class SecurityMonitoringApi {
    private ApiClient apiClient;

    public SecurityMonitoringApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SecurityMonitoringApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public FindingCaseResponse attachCase(String caseId, AttachCaseRequest body) throws ApiException {
        return this.attachCaseWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<FindingCaseResponse> attachCaseAsync(String caseId, AttachCaseRequest body) {
        return this.attachCaseWithHttpInfoAsync(caseId, body).thenApply(response -> (FindingCaseResponse)response.getData());
    }

    public ApiResponse<FindingCaseResponse> attachCaseWithHttpInfo(String caseId, AttachCaseRequest body) throws ApiException {
        AttachCaseRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling attachCase");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling attachCase");
        }
        String localVarPath = "/api/v2/security/findings/cases/{case_id}".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.attachCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<FindingCaseResponse>> attachCaseWithHttpInfoAsync(String caseId, AttachCaseRequest body) {
        Invocation.Builder builder;
        AttachCaseRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<FindingCaseResponse>> result = new CompletableFuture<ApiResponse<FindingCaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling attachCase"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<FindingCaseResponse>> result = new CompletableFuture<ApiResponse<FindingCaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling attachCase"));
            return result;
        }
        String localVarPath = "/api/v2/security/findings/cases/{case_id}".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.attachCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FindingCaseResponse>> result = new CompletableFuture<ApiResponse<FindingCaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponse>(){});
    }

    public FindingCaseResponse attachJiraIssue(AttachJiraIssueRequest body) throws ApiException {
        return this.attachJiraIssueWithHttpInfo(body).getData();
    }

    public CompletableFuture<FindingCaseResponse> attachJiraIssueAsync(AttachJiraIssueRequest body) {
        return this.attachJiraIssueWithHttpInfoAsync(body).thenApply(response -> (FindingCaseResponse)response.getData());
    }

    public ApiResponse<FindingCaseResponse> attachJiraIssueWithHttpInfo(AttachJiraIssueRequest body) throws ApiException {
        AttachJiraIssueRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling attachJiraIssue");
        }
        String localVarPath = "/api/v2/security/findings/jira_issues";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.attachJiraIssue", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<FindingCaseResponse>> attachJiraIssueWithHttpInfoAsync(AttachJiraIssueRequest body) {
        Invocation.Builder builder;
        AttachJiraIssueRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FindingCaseResponse>> result = new CompletableFuture<ApiResponse<FindingCaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling attachJiraIssue"));
            return result;
        }
        String localVarPath = "/api/v2/security/findings/jira_issues";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.attachJiraIssue", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FindingCaseResponse>> result = new CompletableFuture<ApiResponse<FindingCaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponse>(){});
    }

    public void cancelThreatHuntingJob(String jobId) throws ApiException {
        this.cancelThreatHuntingJobWithHttpInfo(jobId);
    }

    public CompletableFuture<Void> cancelThreatHuntingJobAsync(String jobId) {
        return this.cancelThreatHuntingJobWithHttpInfoAsync(jobId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> cancelThreatHuntingJobWithHttpInfo(String jobId) throws ApiException {
        String operationId = "cancelThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            throw new ApiException(400, "Missing the required parameter 'jobId' when calling cancelThreatHuntingJob");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}/cancel".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.cancelThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> cancelThreatHuntingJobWithHttpInfoAsync(String jobId) {
        Invocation.Builder builder;
        String operationId = "cancelThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'jobId' when calling cancelThreatHuntingJob"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}/cancel".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.cancelThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SecurityMonitoringRuleConvertResponse convertExistingSecurityMonitoringRule(String ruleId) throws ApiException {
        return this.convertExistingSecurityMonitoringRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleConvertResponse> convertExistingSecurityMonitoringRuleAsync(String ruleId) {
        return this.convertExistingSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (SecurityMonitoringRuleConvertResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleConvertResponse> convertExistingSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling convertExistingSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/convert".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertExistingSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleConvertResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> convertExistingSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling convertExistingSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/convert".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertExistingSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleConvertResponse>(){});
    }

    public void convertJobResultToSignal(ConvertJobResultsToSignalsRequest body) throws ApiException {
        this.convertJobResultToSignalWithHttpInfo(body);
    }

    public CompletableFuture<Void> convertJobResultToSignalAsync(ConvertJobResultsToSignalsRequest body) {
        return this.convertJobResultToSignalWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> convertJobResultToSignalWithHttpInfo(ConvertJobResultsToSignalsRequest body) throws ApiException {
        String operationId = "convertJobResultToSignal";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ConvertJobResultsToSignalsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling convertJobResultToSignal");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/signal_convert";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertJobResultToSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> convertJobResultToSignalWithHttpInfoAsync(ConvertJobResultsToSignalsRequest body) {
        Invocation.Builder builder;
        String operationId = "convertJobResultToSignal";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        ConvertJobResultsToSignalsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling convertJobResultToSignal"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/signal_convert";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertJobResultToSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SecurityMonitoringRuleConvertResponse convertSecurityMonitoringRuleFromJSONToTerraform(SecurityMonitoringRuleConvertPayload body) throws ApiException {
        return this.convertSecurityMonitoringRuleFromJSONToTerraformWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleConvertResponse> convertSecurityMonitoringRuleFromJSONToTerraformAsync(SecurityMonitoringRuleConvertPayload body) {
        return this.convertSecurityMonitoringRuleFromJSONToTerraformWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringRuleConvertResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleConvertResponse> convertSecurityMonitoringRuleFromJSONToTerraformWithHttpInfo(SecurityMonitoringRuleConvertPayload body) throws ApiException {
        SecurityMonitoringRuleConvertPayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling convertSecurityMonitoringRuleFromJSONToTerraform");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/convert";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertSecurityMonitoringRuleFromJSONToTerraform", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleConvertResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> convertSecurityMonitoringRuleFromJSONToTerraformWithHttpInfoAsync(SecurityMonitoringRuleConvertPayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleConvertPayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling convertSecurityMonitoringRuleFromJSONToTerraform"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/convert";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.convertSecurityMonitoringRuleFromJSONToTerraform", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleConvertResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleConvertResponse>(){});
    }

    public FindingCaseResponseArray createCases(CreateCaseRequestArray body) throws ApiException {
        return this.createCasesWithHttpInfo(body).getData();
    }

    public CompletableFuture<FindingCaseResponseArray> createCasesAsync(CreateCaseRequestArray body) {
        return this.createCasesWithHttpInfoAsync(body).thenApply(response -> (FindingCaseResponseArray)response.getData());
    }

    public ApiResponse<FindingCaseResponseArray> createCasesWithHttpInfo(CreateCaseRequestArray body) throws ApiException {
        CreateCaseRequestArray localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCases");
        }
        String localVarPath = "/api/v2/security/findings/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createCases", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<FindingCaseResponseArray>> createCasesWithHttpInfoAsync(CreateCaseRequestArray body) {
        Invocation.Builder builder;
        CreateCaseRequestArray localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FindingCaseResponseArray>> result = new CompletableFuture<ApiResponse<FindingCaseResponseArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCases"));
            return result;
        }
        String localVarPath = "/api/v2/security/findings/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createCases", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FindingCaseResponseArray>> result = new CompletableFuture<ApiResponse<FindingCaseResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponseArray>(){});
    }

    public CreateCustomFrameworkResponse createCustomFramework(CreateCustomFrameworkRequest body) throws ApiException {
        return this.createCustomFrameworkWithHttpInfo(body).getData();
    }

    public CompletableFuture<CreateCustomFrameworkResponse> createCustomFrameworkAsync(CreateCustomFrameworkRequest body) {
        return this.createCustomFrameworkWithHttpInfoAsync(body).thenApply(response -> (CreateCustomFrameworkResponse)response.getData());
    }

    public ApiResponse<CreateCustomFrameworkResponse> createCustomFrameworkWithHttpInfo(CreateCustomFrameworkRequest body) throws ApiException {
        CreateCustomFrameworkRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCustomFramework");
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateCustomFrameworkResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateCustomFrameworkResponse>> createCustomFrameworkWithHttpInfoAsync(CreateCustomFrameworkRequest body) {
        Invocation.Builder builder;
        CreateCustomFrameworkRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CreateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<CreateCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCustomFramework"));
            return result;
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<CreateCustomFrameworkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CreateCustomFrameworkResponse>(){});
    }

    public FindingCaseResponseArray createJiraIssues(CreateJiraIssueRequestArray body) throws ApiException {
        return this.createJiraIssuesWithHttpInfo(body).getData();
    }

    public CompletableFuture<FindingCaseResponseArray> createJiraIssuesAsync(CreateJiraIssueRequestArray body) {
        return this.createJiraIssuesWithHttpInfoAsync(body).thenApply(response -> (FindingCaseResponseArray)response.getData());
    }

    public ApiResponse<FindingCaseResponseArray> createJiraIssuesWithHttpInfo(CreateJiraIssueRequestArray body) throws ApiException {
        CreateJiraIssueRequestArray localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createJiraIssues");
        }
        String localVarPath = "/api/v2/security/findings/jira_issues";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createJiraIssues", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponseArray>(){});
    }

    public CompletableFuture<ApiResponse<FindingCaseResponseArray>> createJiraIssuesWithHttpInfoAsync(CreateJiraIssueRequestArray body) {
        Invocation.Builder builder;
        CreateJiraIssueRequestArray localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<FindingCaseResponseArray>> result = new CompletableFuture<ApiResponse<FindingCaseResponseArray>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createJiraIssues"));
            return result;
        }
        String localVarPath = "/api/v2/security/findings/jira_issues";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createJiraIssues", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<FindingCaseResponseArray>> result = new CompletableFuture<ApiResponse<FindingCaseResponseArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<FindingCaseResponseArray>(){});
    }

    public SecurityFilterResponse createSecurityFilter(SecurityFilterCreateRequest body) throws ApiException {
        return this.createSecurityFilterWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> createSecurityFilterAsync(SecurityFilterCreateRequest body) {
        return this.createSecurityFilterWithHttpInfoAsync(body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> createSecurityFilterWithHttpInfo(SecurityFilterCreateRequest body) throws ApiException {
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> createSecurityFilterWithHttpInfoAsync(SecurityFilterCreateRequest body) {
        Invocation.Builder builder;
        SecurityFilterCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse createSecurityMonitoringRule(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        return this.createSecurityMonitoringRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleAsync(SecurityMonitoringRuleCreatePayload body) {
        return this.createSecurityMonitoringRuleWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> createSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> createSecurityMonitoringRuleWithHttpInfoAsync(SecurityMonitoringRuleCreatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse createSecurityMonitoringSuppression(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        return this.createSecurityMonitoringSuppressionWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> createSecurityMonitoringSuppressionAsync(SecurityMonitoringSuppressionCreateRequest body) {
        return this.createSecurityMonitoringSuppressionWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> createSecurityMonitoringSuppressionWithHttpInfo(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> createSecurityMonitoringSuppressionWithHttpInfoAsync(SecurityMonitoringSuppressionCreateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public NotificationRuleResponse createSignalNotificationRule(CreateNotificationRuleParameters body) throws ApiException {
        return this.createSignalNotificationRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<NotificationRuleResponse> createSignalNotificationRuleAsync(CreateNotificationRuleParameters body) {
        return this.createSignalNotificationRuleWithHttpInfoAsync(body).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> createSignalNotificationRuleWithHttpInfo(CreateNotificationRuleParameters body) throws ApiException {
        CreateNotificationRuleParameters localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createSignalNotificationRule");
        }
        String localVarPath = "/api/v2/security/signals/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> createSignalNotificationRuleWithHttpInfoAsync(CreateNotificationRuleParameters body) {
        Invocation.Builder builder;
        CreateNotificationRuleParameters localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createSignalNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/signals/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public NotificationRuleResponse createVulnerabilityNotificationRule(CreateNotificationRuleParameters body) throws ApiException {
        return this.createVulnerabilityNotificationRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<NotificationRuleResponse> createVulnerabilityNotificationRuleAsync(CreateNotificationRuleParameters body) {
        return this.createVulnerabilityNotificationRuleWithHttpInfoAsync(body).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> createVulnerabilityNotificationRuleWithHttpInfo(CreateNotificationRuleParameters body) throws ApiException {
        CreateNotificationRuleParameters localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createVulnerabilityNotificationRule");
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> createVulnerabilityNotificationRuleWithHttpInfoAsync(CreateNotificationRuleParameters body) {
        Invocation.Builder builder;
        CreateNotificationRuleParameters localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createVulnerabilityNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.createVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public DeleteCustomFrameworkResponse deleteCustomFramework(String handle, String version) throws ApiException {
        return this.deleteCustomFrameworkWithHttpInfo(handle, version).getData();
    }

    public CompletableFuture<DeleteCustomFrameworkResponse> deleteCustomFrameworkAsync(String handle, String version) {
        return this.deleteCustomFrameworkWithHttpInfoAsync(handle, version).thenApply(response -> (DeleteCustomFrameworkResponse)response.getData());
    }

    public ApiResponse<DeleteCustomFrameworkResponse> deleteCustomFrameworkWithHttpInfo(String handle, String version) throws ApiException {
        Object localVarPostBody = null;
        if (handle == null) {
            throw new ApiException(400, "Missing the required parameter 'handle' when calling deleteCustomFramework");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling deleteCustomFramework");
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteCustomFrameworkResponse>(){});
    }

    public CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>> deleteCustomFrameworkWithHttpInfoAsync(String handle, String version) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handle == null) {
            CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handle' when calling deleteCustomFramework"));
            return result;
        }
        if (version == null) {
            CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'version' when calling deleteCustomFramework"));
            return result;
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<DeleteCustomFrameworkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<DeleteCustomFrameworkResponse>(){});
    }

    public void deleteSecurityFilter(String securityFilterId) throws ApiException {
        this.deleteSecurityFilterWithHttpInfo(securityFilterId);
    }

    public CompletableFuture<Void> deleteSecurityFilterAsync(String securityFilterId) {
        return this.deleteSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling deleteSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSecurityMonitoringRule(String ruleId) throws ApiException {
        this.deleteSecurityMonitoringRuleWithHttpInfo(ruleId);
    }

    public CompletableFuture<Void> deleteSecurityMonitoringRuleAsync(String ruleId) {
        return this.deleteSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSecurityMonitoringSuppression(String suppressionId) throws ApiException {
        this.deleteSecurityMonitoringSuppressionWithHttpInfo(suppressionId);
    }

    public CompletableFuture<Void> deleteSecurityMonitoringSuppressionAsync(String suppressionId) {
        return this.deleteSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSecurityMonitoringSuppressionWithHttpInfo(String suppressionId) throws ApiException {
        Object localVarPostBody = null;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling deleteSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling deleteSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteSignalNotificationRule(String id) throws ApiException {
        this.deleteSignalNotificationRuleWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteSignalNotificationRuleAsync(String id) {
        return this.deleteSignalNotificationRuleWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteSignalNotificationRuleWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteSignalNotificationRule");
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteSignalNotificationRuleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteSignalNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteThreatHuntingJob(String jobId) throws ApiException {
        this.deleteThreatHuntingJobWithHttpInfo(jobId);
    }

    public CompletableFuture<Void> deleteThreatHuntingJobAsync(String jobId) {
        return this.deleteThreatHuntingJobWithHttpInfoAsync(jobId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteThreatHuntingJobWithHttpInfo(String jobId) throws ApiException {
        String operationId = "deleteThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            throw new ApiException(400, "Missing the required parameter 'jobId' when calling deleteThreatHuntingJob");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteThreatHuntingJobWithHttpInfoAsync(String jobId) {
        Invocation.Builder builder;
        String operationId = "deleteThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'jobId' when calling deleteThreatHuntingJob"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteVulnerabilityNotificationRule(String id) throws ApiException {
        this.deleteVulnerabilityNotificationRuleWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteVulnerabilityNotificationRuleAsync(String id) {
        return this.deleteVulnerabilityNotificationRuleWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteVulnerabilityNotificationRuleWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteVulnerabilityNotificationRule");
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteVulnerabilityNotificationRuleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteVulnerabilityNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.deleteVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void detachCase(DetachCaseRequest body) throws ApiException {
        this.detachCaseWithHttpInfo(body);
    }

    public CompletableFuture<Void> detachCaseAsync(DetachCaseRequest body) {
        return this.detachCaseWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> detachCaseWithHttpInfo(DetachCaseRequest body) throws ApiException {
        DetachCaseRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling detachCase");
        }
        String localVarPath = "/api/v2/security/findings/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.detachCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> detachCaseWithHttpInfoAsync(DetachCaseRequest body) {
        Invocation.Builder builder;
        DetachCaseRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling detachCase"));
            return result;
        }
        String localVarPath = "/api/v2/security/findings/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.detachCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalAssignee(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalAssigneeAsync(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) {
        return this.editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalAssigneeWithHttpInfo(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalAssigneeWithHttpInfoAsync(String signalId, SecurityMonitoringSignalAssigneeUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalAssigneeUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalAssignee"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/assignee".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalAssignee", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalIncidents(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalIncidentsWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalIncidentsAsync(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) {
        return this.editSecurityMonitoringSignalIncidentsWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalIncidentsWithHttpInfo(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalIncidentsUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalIncidents");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalIncidents");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/incidents".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalIncidents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalIncidentsWithHttpInfoAsync(String signalId, SecurityMonitoringSignalIncidentsUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalIncidentsUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalIncidents"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalIncidents"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/incidents".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalIncidents", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public SecurityMonitoringSignalTriageUpdateResponse editSecurityMonitoringSignalState(String signalId, SecurityMonitoringSignalStateUpdateRequest body) throws ApiException {
        return this.editSecurityMonitoringSignalStateWithHttpInfo(signalId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalStateAsync(String signalId, SecurityMonitoringSignalStateUpdateRequest body) {
        return this.editSecurityMonitoringSignalStateWithHttpInfoAsync(signalId, body).thenApply(response -> (SecurityMonitoringSignalTriageUpdateResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalTriageUpdateResponse> editSecurityMonitoringSignalStateWithHttpInfo(String signalId, SecurityMonitoringSignalStateUpdateRequest body) throws ApiException {
        SecurityMonitoringSignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> editSecurityMonitoringSignalStateWithHttpInfoAsync(String signalId, SecurityMonitoringSignalStateUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSignalStateUpdateRequest localVarPostBody = body;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling editSecurityMonitoringSignalState"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}/state".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.editSecurityMonitoringSignalState", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalTriageUpdateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalTriageUpdateResponse>(){});
    }

    public GetCustomFrameworkResponse getCustomFramework(String handle, String version) throws ApiException {
        return this.getCustomFrameworkWithHttpInfo(handle, version).getData();
    }

    public CompletableFuture<GetCustomFrameworkResponse> getCustomFrameworkAsync(String handle, String version) {
        return this.getCustomFrameworkWithHttpInfoAsync(handle, version).thenApply(response -> (GetCustomFrameworkResponse)response.getData());
    }

    public ApiResponse<GetCustomFrameworkResponse> getCustomFrameworkWithHttpInfo(String handle, String version) throws ApiException {
        Object localVarPostBody = null;
        if (handle == null) {
            throw new ApiException(400, "Missing the required parameter 'handle' when calling getCustomFramework");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling getCustomFramework");
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetCustomFrameworkResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetCustomFrameworkResponse>> getCustomFrameworkWithHttpInfoAsync(String handle, String version) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (handle == null) {
            CompletableFuture<ApiResponse<GetCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<GetCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handle' when calling getCustomFramework"));
            return result;
        }
        if (version == null) {
            CompletableFuture<ApiResponse<GetCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<GetCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'version' when calling getCustomFramework"));
            return result;
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<GetCustomFrameworkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetCustomFrameworkResponse>(){});
    }

    public GetFindingResponse getFinding(String findingId) throws ApiException {
        return this.getFindingWithHttpInfo(findingId, new GetFindingOptionalParameters()).getData();
    }

    public CompletableFuture<GetFindingResponse> getFindingAsync(String findingId) {
        return this.getFindingWithHttpInfoAsync(findingId, new GetFindingOptionalParameters()).thenApply(response -> (GetFindingResponse)response.getData());
    }

    public GetFindingResponse getFinding(String findingId, GetFindingOptionalParameters parameters) throws ApiException {
        return this.getFindingWithHttpInfo(findingId, parameters).getData();
    }

    public CompletableFuture<GetFindingResponse> getFindingAsync(String findingId, GetFindingOptionalParameters parameters) {
        return this.getFindingWithHttpInfoAsync(findingId, parameters).thenApply(response -> (GetFindingResponse)response.getData());
    }

    public ApiResponse<GetFindingResponse> getFindingWithHttpInfo(String findingId, GetFindingOptionalParameters parameters) throws ApiException {
        String operationId = "getFinding";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (findingId == null) {
            throw new ApiException(400, "Missing the required parameter 'findingId' when calling getFinding");
        }
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String localVarPath = "/api/v2/posture_management/findings/{finding_id}".replaceAll("\\{finding_id\\}", this.apiClient.escapeString(findingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getFinding", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetFindingResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetFindingResponse>> getFindingWithHttpInfoAsync(String findingId, GetFindingOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getFinding";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (findingId == null) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'findingId' when calling getFinding"));
            return result;
        }
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String localVarPath = "/api/v2/posture_management/findings/{finding_id}".replaceAll("\\{finding_id\\}", this.apiClient.escapeString(findingId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getFinding", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetFindingResponse>> result = new CompletableFuture<ApiResponse<GetFindingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetFindingResponse>(){});
    }

    public GetResourceEvaluationFiltersResponse getResourceEvaluationFilters() throws ApiException {
        return this.getResourceEvaluationFiltersWithHttpInfo(new GetResourceEvaluationFiltersOptionalParameters()).getData();
    }

    public CompletableFuture<GetResourceEvaluationFiltersResponse> getResourceEvaluationFiltersAsync() {
        return this.getResourceEvaluationFiltersWithHttpInfoAsync(new GetResourceEvaluationFiltersOptionalParameters()).thenApply(response -> (GetResourceEvaluationFiltersResponse)response.getData());
    }

    public GetResourceEvaluationFiltersResponse getResourceEvaluationFilters(GetResourceEvaluationFiltersOptionalParameters parameters) throws ApiException {
        return this.getResourceEvaluationFiltersWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<GetResourceEvaluationFiltersResponse> getResourceEvaluationFiltersAsync(GetResourceEvaluationFiltersOptionalParameters parameters) {
        return this.getResourceEvaluationFiltersWithHttpInfoAsync(parameters).thenApply(response -> (GetResourceEvaluationFiltersResponse)response.getData());
    }

    public ApiResponse<GetResourceEvaluationFiltersResponse> getResourceEvaluationFiltersWithHttpInfo(GetResourceEvaluationFiltersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String cloudProvider = parameters.cloudProvider;
        String accountId = parameters.accountId;
        Boolean skipCache = parameters.skipCache;
        String localVarPath = "/api/v2/cloud_security_management/resource_filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cloud_provider", cloudProvider));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "skip_cache", skipCache));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getResourceEvaluationFilters", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetResourceEvaluationFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetResourceEvaluationFiltersResponse>> getResourceEvaluationFiltersWithHttpInfoAsync(GetResourceEvaluationFiltersOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String cloudProvider = parameters.cloudProvider;
        String accountId = parameters.accountId;
        Boolean skipCache = parameters.skipCache;
        String localVarPath = "/api/v2/cloud_security_management/resource_filters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "cloud_provider", cloudProvider));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "account_id", accountId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "skip_cache", skipCache));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getResourceEvaluationFilters", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetResourceEvaluationFiltersResponse>> result = new CompletableFuture<ApiResponse<GetResourceEvaluationFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetResourceEvaluationFiltersResponse>(){});
    }

    public GetRuleVersionHistoryResponse getRuleVersionHistory(String ruleId) throws ApiException {
        return this.getRuleVersionHistoryWithHttpInfo(ruleId, new GetRuleVersionHistoryOptionalParameters()).getData();
    }

    public CompletableFuture<GetRuleVersionHistoryResponse> getRuleVersionHistoryAsync(String ruleId) {
        return this.getRuleVersionHistoryWithHttpInfoAsync(ruleId, new GetRuleVersionHistoryOptionalParameters()).thenApply(response -> (GetRuleVersionHistoryResponse)response.getData());
    }

    public GetRuleVersionHistoryResponse getRuleVersionHistory(String ruleId, GetRuleVersionHistoryOptionalParameters parameters) throws ApiException {
        return this.getRuleVersionHistoryWithHttpInfo(ruleId, parameters).getData();
    }

    public CompletableFuture<GetRuleVersionHistoryResponse> getRuleVersionHistoryAsync(String ruleId, GetRuleVersionHistoryOptionalParameters parameters) {
        return this.getRuleVersionHistoryWithHttpInfoAsync(ruleId, parameters).thenApply(response -> (GetRuleVersionHistoryResponse)response.getData());
    }

    public ApiResponse<GetRuleVersionHistoryResponse> getRuleVersionHistoryWithHttpInfo(String ruleId, GetRuleVersionHistoryOptionalParameters parameters) throws ApiException {
        String operationId = "getRuleVersionHistory";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getRuleVersionHistory");
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/version_history".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getRuleVersionHistory", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetRuleVersionHistoryResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>> getRuleVersionHistoryWithHttpInfoAsync(String ruleId, GetRuleVersionHistoryOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getRuleVersionHistory";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>> result = new CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>> result = new CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getRuleVersionHistory"));
            return result;
        }
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/version_history".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getRuleVersionHistory", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>> result = new CompletableFuture<ApiResponse<GetRuleVersionHistoryResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetRuleVersionHistoryResponse>(){});
    }

    public GetSBOMResponse getSBOM(AssetType assetType, String filterAssetName) throws ApiException {
        return this.getSBOMWithHttpInfo(assetType, filterAssetName, new GetSBOMOptionalParameters()).getData();
    }

    public CompletableFuture<GetSBOMResponse> getSBOMAsync(AssetType assetType, String filterAssetName) {
        return this.getSBOMWithHttpInfoAsync(assetType, filterAssetName, new GetSBOMOptionalParameters()).thenApply(response -> (GetSBOMResponse)response.getData());
    }

    public GetSBOMResponse getSBOM(AssetType assetType, String filterAssetName, GetSBOMOptionalParameters parameters) throws ApiException {
        return this.getSBOMWithHttpInfo(assetType, filterAssetName, parameters).getData();
    }

    public CompletableFuture<GetSBOMResponse> getSBOMAsync(AssetType assetType, String filterAssetName, GetSBOMOptionalParameters parameters) {
        return this.getSBOMWithHttpInfoAsync(assetType, filterAssetName, parameters).thenApply(response -> (GetSBOMResponse)response.getData());
    }

    public ApiResponse<GetSBOMResponse> getSBOMWithHttpInfo(AssetType assetType, String filterAssetName, GetSBOMOptionalParameters parameters) throws ApiException {
        String operationId = "getSBOM";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (assetType == null) {
            throw new ApiException(400, "Missing the required parameter 'assetType' when calling getSBOM");
        }
        if (filterAssetName == null) {
            throw new ApiException(400, "Missing the required parameter 'filterAssetName' when calling getSBOM");
        }
        String filterRepoDigest = parameters.filterRepoDigest;
        SBOMFormat extFormat = parameters.extFormat;
        String localVarPath = "/api/v2/security/sboms/{asset_type}".replaceAll("\\{asset_type\\}", this.apiClient.escapeString(assetType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repo_digest]", filterRepoDigest));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ext:format", extFormat));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSBOM", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetSBOMResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetSBOMResponse>> getSBOMWithHttpInfoAsync(AssetType assetType, String filterAssetName, GetSBOMOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getSBOM";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetSBOMResponse>> result = new CompletableFuture<ApiResponse<GetSBOMResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (assetType == null) {
            CompletableFuture<ApiResponse<GetSBOMResponse>> result = new CompletableFuture<ApiResponse<GetSBOMResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'assetType' when calling getSBOM"));
            return result;
        }
        if (filterAssetName == null) {
            CompletableFuture<ApiResponse<GetSBOMResponse>> result = new CompletableFuture<ApiResponse<GetSBOMResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'filterAssetName' when calling getSBOM"));
            return result;
        }
        String filterRepoDigest = parameters.filterRepoDigest;
        SBOMFormat extFormat = parameters.extFormat;
        String localVarPath = "/api/v2/security/sboms/{asset_type}".replaceAll("\\{asset_type\\}", this.apiClient.escapeString(assetType.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repo_digest]", filterRepoDigest));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ext:format", extFormat));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSBOM", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetSBOMResponse>> result = new CompletableFuture<ApiResponse<GetSBOMResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetSBOMResponse>(){});
    }

    public SecretRuleArray getSecretsRules() throws ApiException {
        return this.getSecretsRulesWithHttpInfo().getData();
    }

    public CompletableFuture<SecretRuleArray> getSecretsRulesAsync() {
        return this.getSecretsRulesWithHttpInfoAsync().thenApply(response -> (SecretRuleArray)response.getData());
    }

    public ApiResponse<SecretRuleArray> getSecretsRulesWithHttpInfo() throws ApiException {
        String operationId = "getSecretsRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/static-analysis/secrets/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecretsRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecretRuleArray>(){});
    }

    public CompletableFuture<ApiResponse<SecretRuleArray>> getSecretsRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "getSecretsRules";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SecretRuleArray>> result = new CompletableFuture<ApiResponse<SecretRuleArray>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/static-analysis/secrets/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecretsRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecretRuleArray>> result = new CompletableFuture<ApiResponse<SecretRuleArray>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecretRuleArray>(){});
    }

    public SecurityFilterResponse getSecurityFilter(String securityFilterId) throws ApiException {
        return this.getSecurityFilterWithHttpInfo(securityFilterId).getData();
    }

    public CompletableFuture<SecurityFilterResponse> getSecurityFilterAsync(String securityFilterId) {
        return this.getSecurityFilterWithHttpInfoAsync(securityFilterId).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> getSecurityFilterWithHttpInfo(String securityFilterId) throws ApiException {
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> getSecurityFilterWithHttpInfoAsync(String securityFilterId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling getSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringSignalResponse getSecurityMonitoringHistsignal(String histsignalId) throws ApiException {
        return this.getSecurityMonitoringHistsignalWithHttpInfo(histsignalId).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalResponse> getSecurityMonitoringHistsignalAsync(String histsignalId) {
        return this.getSecurityMonitoringHistsignalWithHttpInfoAsync(histsignalId).thenApply(response -> (SecurityMonitoringSignalResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalResponse> getSecurityMonitoringHistsignalWithHttpInfo(String histsignalId) throws ApiException {
        String operationId = "getSecurityMonitoringHistsignal";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (histsignalId == null) {
            throw new ApiException(400, "Missing the required parameter 'histsignalId' when calling getSecurityMonitoringHistsignal");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals/{histsignal_id}".replaceAll("\\{histsignal_id\\}", this.apiClient.escapeString(histsignalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringHistsignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> getSecurityMonitoringHistsignalWithHttpInfoAsync(String histsignalId) {
        Invocation.Builder builder;
        String operationId = "getSecurityMonitoringHistsignal";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (histsignalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'histsignalId' when calling getSecurityMonitoringHistsignal"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals/{histsignal_id}".replaceAll("\\{histsignal_id\\}", this.apiClient.escapeString(histsignalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringHistsignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse getSecurityMonitoringHistsignalsByJobId(String jobId) throws ApiException {
        return this.getSecurityMonitoringHistsignalsByJobIdWithHttpInfo(jobId, new GetSecurityMonitoringHistsignalsByJobIdOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> getSecurityMonitoringHistsignalsByJobIdAsync(String jobId) {
        return this.getSecurityMonitoringHistsignalsByJobIdWithHttpInfoAsync(jobId, new GetSecurityMonitoringHistsignalsByJobIdOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse getSecurityMonitoringHistsignalsByJobId(String jobId, GetSecurityMonitoringHistsignalsByJobIdOptionalParameters parameters) throws ApiException {
        return this.getSecurityMonitoringHistsignalsByJobIdWithHttpInfo(jobId, parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> getSecurityMonitoringHistsignalsByJobIdAsync(String jobId, GetSecurityMonitoringHistsignalsByJobIdOptionalParameters parameters) {
        return this.getSecurityMonitoringHistsignalsByJobIdWithHttpInfoAsync(jobId, parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> getSecurityMonitoringHistsignalsByJobIdWithHttpInfo(String jobId, GetSecurityMonitoringHistsignalsByJobIdOptionalParameters parameters) throws ApiException {
        String operationId = "getSecurityMonitoringHistsignalsByJobId";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            throw new ApiException(400, "Missing the required parameter 'jobId' when calling getSecurityMonitoringHistsignalsByJobId");
        }
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}/histsignals".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringHistsignalsByJobId", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> getSecurityMonitoringHistsignalsByJobIdWithHttpInfoAsync(String jobId, GetSecurityMonitoringHistsignalsByJobIdOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "getSecurityMonitoringHistsignalsByJobId";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'jobId' when calling getSecurityMonitoringHistsignalsByJobId"));
            return result;
        }
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}/histsignals".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringHistsignalsByJobId", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringRuleResponse getSecurityMonitoringRule(String ruleId) throws ApiException {
        return this.getSecurityMonitoringRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleAsync(String ruleId) {
        return this.getSecurityMonitoringRuleWithHttpInfoAsync(ruleId).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> getSecurityMonitoringRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> getSecurityMonitoringRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSignalResponse getSecurityMonitoringSignal(String signalId) throws ApiException {
        return this.getSecurityMonitoringSignalWithHttpInfo(signalId).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalResponse> getSecurityMonitoringSignalAsync(String signalId) {
        return this.getSecurityMonitoringSignalWithHttpInfoAsync(signalId).thenApply(response -> (SecurityMonitoringSignalResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalResponse> getSecurityMonitoringSignalWithHttpInfo(String signalId) throws ApiException {
        Object localVarPostBody = null;
        if (signalId == null) {
            throw new ApiException(400, "Missing the required parameter 'signalId' when calling getSecurityMonitoringSignal");
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> getSecurityMonitoringSignalWithHttpInfoAsync(String signalId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (signalId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'signalId' when calling getSecurityMonitoringSignal"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/signals/{signal_id}".replaceAll("\\{signal_id\\}", this.apiClient.escapeString(signalId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSignal", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse getSecurityMonitoringSuppression(String suppressionId) throws ApiException {
        return this.getSecurityMonitoringSuppressionWithHttpInfo(suppressionId).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> getSecurityMonitoringSuppressionAsync(String suppressionId) {
        return this.getSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> getSecurityMonitoringSuppressionWithHttpInfo(String suppressionId) throws ApiException {
        Object localVarPostBody = null;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling getSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> getSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling getSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public NotificationRuleResponse getSignalNotificationRule(String id) throws ApiException {
        return this.getSignalNotificationRuleWithHttpInfo(id).getData();
    }

    public CompletableFuture<NotificationRuleResponse> getSignalNotificationRuleAsync(String id) {
        return this.getSignalNotificationRuleWithHttpInfoAsync(id).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> getSignalNotificationRuleWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getSignalNotificationRule");
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> getSignalNotificationRuleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getSignalNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public Object getSignalNotificationRules() throws ApiException {
        return this.getSignalNotificationRulesWithHttpInfo().getData();
    }

    public CompletableFuture<Object> getSignalNotificationRulesAsync() {
        return this.getSignalNotificationRulesWithHttpInfoAsync().thenApply(response -> response.getData());
    }

    public ApiResponse<Object> getSignalNotificationRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/signals/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSignalNotificationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> getSignalNotificationRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/signals/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSignalNotificationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public SecurityMonitoringSuppressionsResponse getSuppressionsAffectingFutureRule(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        return this.getSuppressionsAffectingFutureRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionsResponse> getSuppressionsAffectingFutureRuleAsync(SecurityMonitoringRuleCreatePayload body) {
        return this.getSuppressionsAffectingFutureRuleWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringSuppressionsResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionsResponse> getSuppressionsAffectingFutureRuleWithHttpInfo(SecurityMonitoringRuleCreatePayload body) throws ApiException {
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling getSuppressionsAffectingFutureRule");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSuppressionsAffectingFutureRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> getSuppressionsAffectingFutureRuleWithHttpInfoAsync(SecurityMonitoringRuleCreatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleCreatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling getSuppressionsAffectingFutureRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSuppressionsAffectingFutureRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public SecurityMonitoringSuppressionsResponse getSuppressionsAffectingRule(String ruleId) throws ApiException {
        return this.getSuppressionsAffectingRuleWithHttpInfo(ruleId).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionsResponse> getSuppressionsAffectingRuleAsync(String ruleId) {
        return this.getSuppressionsAffectingRuleWithHttpInfoAsync(ruleId).thenApply(response -> (SecurityMonitoringSuppressionsResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionsResponse> getSuppressionsAffectingRuleWithHttpInfo(String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getSuppressionsAffectingRule");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSuppressionsAffectingRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> getSuppressionsAffectingRuleWithHttpInfoAsync(String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getSuppressionsAffectingRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getSuppressionsAffectingRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public ThreatHuntingJobResponse getThreatHuntingJob(String jobId) throws ApiException {
        return this.getThreatHuntingJobWithHttpInfo(jobId).getData();
    }

    public CompletableFuture<ThreatHuntingJobResponse> getThreatHuntingJobAsync(String jobId) {
        return this.getThreatHuntingJobWithHttpInfoAsync(jobId).thenApply(response -> (ThreatHuntingJobResponse)response.getData());
    }

    public ApiResponse<ThreatHuntingJobResponse> getThreatHuntingJobWithHttpInfo(String jobId) throws ApiException {
        String operationId = "getThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            throw new ApiException(400, "Missing the required parameter 'jobId' when calling getThreatHuntingJob");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ThreatHuntingJobResponse>(){});
    }

    public CompletableFuture<ApiResponse<ThreatHuntingJobResponse>> getThreatHuntingJobWithHttpInfoAsync(String jobId) {
        Invocation.Builder builder;
        String operationId = "getThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ThreatHuntingJobResponse>> result = new CompletableFuture<ApiResponse<ThreatHuntingJobResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (jobId == null) {
            CompletableFuture<ApiResponse<ThreatHuntingJobResponse>> result = new CompletableFuture<ApiResponse<ThreatHuntingJobResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'jobId' when calling getThreatHuntingJob"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs/{job_id}".replaceAll("\\{job_id\\}", this.apiClient.escapeString(jobId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ThreatHuntingJobResponse>> result = new CompletableFuture<ApiResponse<ThreatHuntingJobResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ThreatHuntingJobResponse>(){});
    }

    public NotificationRuleResponse getVulnerabilityNotificationRule(String id) throws ApiException {
        return this.getVulnerabilityNotificationRuleWithHttpInfo(id).getData();
    }

    public CompletableFuture<NotificationRuleResponse> getVulnerabilityNotificationRuleAsync(String id) {
        return this.getVulnerabilityNotificationRuleWithHttpInfoAsync(id).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> getVulnerabilityNotificationRuleWithHttpInfo(String id) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getVulnerabilityNotificationRule");
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> getVulnerabilityNotificationRuleWithHttpInfoAsync(String id) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getVulnerabilityNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public Object getVulnerabilityNotificationRules() throws ApiException {
        return this.getVulnerabilityNotificationRulesWithHttpInfo().getData();
    }

    public CompletableFuture<Object> getVulnerabilityNotificationRulesAsync() {
        return this.getVulnerabilityNotificationRulesWithHttpInfoAsync().thenApply(response -> response.getData());
    }

    public ApiResponse<Object> getVulnerabilityNotificationRulesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getVulnerabilityNotificationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public CompletableFuture<ApiResponse<Object>> getVulnerabilityNotificationRulesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.getVulnerabilityNotificationRules", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public ListAssetsSBOMsResponse listAssetsSBOMs() throws ApiException {
        return this.listAssetsSBOMsWithHttpInfo(new ListAssetsSBOMsOptionalParameters()).getData();
    }

    public CompletableFuture<ListAssetsSBOMsResponse> listAssetsSBOMsAsync() {
        return this.listAssetsSBOMsWithHttpInfoAsync(new ListAssetsSBOMsOptionalParameters()).thenApply(response -> (ListAssetsSBOMsResponse)response.getData());
    }

    public ListAssetsSBOMsResponse listAssetsSBOMs(ListAssetsSBOMsOptionalParameters parameters) throws ApiException {
        return this.listAssetsSBOMsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListAssetsSBOMsResponse> listAssetsSBOMsAsync(ListAssetsSBOMsOptionalParameters parameters) {
        return this.listAssetsSBOMsWithHttpInfoAsync(parameters).thenApply(response -> (ListAssetsSBOMsResponse)response.getData());
    }

    public ApiResponse<ListAssetsSBOMsResponse> listAssetsSBOMsWithHttpInfo(ListAssetsSBOMsOptionalParameters parameters) throws ApiException {
        String operationId = "listAssetsSBOMs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        AssetType filterAssetType = parameters.filterAssetType;
        String filterAssetName = parameters.filterAssetName;
        String filterPackageName = parameters.filterPackageName;
        String filterPackageVersion = parameters.filterPackageVersion;
        String filterLicenseName = parameters.filterLicenseName;
        SBOMComponentLicenseType filterLicenseType = parameters.filterLicenseType;
        String localVarPath = "/api/v2/security/sboms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[package_name]", filterPackageName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[package_version]", filterPackageVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[license_name]", filterLicenseName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[license_type]", filterLicenseType));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listAssetsSBOMs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAssetsSBOMsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListAssetsSBOMsResponse>> listAssetsSBOMsWithHttpInfoAsync(ListAssetsSBOMsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listAssetsSBOMs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListAssetsSBOMsResponse>> result = new CompletableFuture<ApiResponse<ListAssetsSBOMsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        AssetType filterAssetType = parameters.filterAssetType;
        String filterAssetName = parameters.filterAssetName;
        String filterPackageName = parameters.filterPackageName;
        String filterPackageVersion = parameters.filterPackageVersion;
        String filterLicenseName = parameters.filterLicenseName;
        SBOMComponentLicenseType filterLicenseType = parameters.filterLicenseType;
        String localVarPath = "/api/v2/security/sboms";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset_name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[package_name]", filterPackageName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[package_version]", filterPackageVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[license_name]", filterLicenseName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[license_type]", filterLicenseType));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listAssetsSBOMs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListAssetsSBOMsResponse>> result = new CompletableFuture<ApiResponse<ListAssetsSBOMsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAssetsSBOMsResponse>(){});
    }

    public ListFindingsResponse listFindings() throws ApiException {
        return this.listFindingsWithHttpInfo(new ListFindingsOptionalParameters()).getData();
    }

    public CompletableFuture<ListFindingsResponse> listFindingsAsync() {
        return this.listFindingsWithHttpInfoAsync(new ListFindingsOptionalParameters()).thenApply(response -> (ListFindingsResponse)response.getData());
    }

    public ListFindingsResponse listFindings(ListFindingsOptionalParameters parameters) throws ApiException {
        return this.listFindingsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListFindingsResponse> listFindingsAsync(ListFindingsOptionalParameters parameters) {
        return this.listFindingsWithHttpInfoAsync(parameters).thenApply(response -> (ListFindingsResponse)response.getData());
    }

    public PaginationIterable<Finding> listFindingsWithPagination() {
        ListFindingsOptionalParameters parameters = new ListFindingsOptionalParameters();
        return this.listFindingsWithPagination(parameters);
    }

    public PaginationIterable<Finding> listFindingsWithPagination(ListFindingsOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getCursor";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 100L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Finding> iterator = new PaginationIterable<Finding>(this, "listFindings", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListFindingsResponse> listFindingsWithHttpInfo(ListFindingsOptionalParameters parameters) throws ApiException {
        String operationId = "listFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String pageCursor = parameters.pageCursor;
        String filterTags = parameters.filterTags;
        String filterEvaluationChangedAt = parameters.filterEvaluationChangedAt;
        Boolean filterMuted = parameters.filterMuted;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String filterResourceType = parameters.filterResourceType;
        String filterResourceId = parameters.filterResourceId;
        String filterDiscoveryTimestamp = parameters.filterDiscoveryTimestamp;
        FindingEvaluation filterEvaluation = parameters.filterEvaluation;
        FindingStatus filterStatus = parameters.filterStatus;
        List filterVulnerabilityType = parameters.filterVulnerabilityType;
        Boolean detailedFindings = parameters.detailedFindings;
        String localVarPath = "/api/v2/posture_management/findings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation_changed_at]", filterEvaluationChangedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[muted]", filterMuted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[resource_type]", filterResourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[@resource_id]", filterResourceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[discovery_timestamp]", filterDiscoveryTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation]", filterEvaluation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filter[vulnerability_type]", filterVulnerabilityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "detailed_findings", detailedFindings));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listFindings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListFindingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListFindingsResponse>> listFindingsWithHttpInfoAsync(ListFindingsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListFindingsResponse>> result = new CompletableFuture<ApiResponse<ListFindingsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long snapshotTimestamp = parameters.snapshotTimestamp;
        String pageCursor = parameters.pageCursor;
        String filterTags = parameters.filterTags;
        String filterEvaluationChangedAt = parameters.filterEvaluationChangedAt;
        Boolean filterMuted = parameters.filterMuted;
        String filterRuleId = parameters.filterRuleId;
        String filterRuleName = parameters.filterRuleName;
        String filterResourceType = parameters.filterResourceType;
        String filterResourceId = parameters.filterResourceId;
        String filterDiscoveryTimestamp = parameters.filterDiscoveryTimestamp;
        FindingEvaluation filterEvaluation = parameters.filterEvaluation;
        FindingStatus filterStatus = parameters.filterStatus;
        List filterVulnerabilityType = parameters.filterVulnerabilityType;
        Boolean detailedFindings = parameters.detailedFindings;
        String localVarPath = "/api/v2/posture_management/findings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "snapshot_timestamp", snapshotTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tags]", filterTags));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation_changed_at]", filterEvaluationChangedAt));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[muted]", filterMuted));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_id]", filterRuleId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[rule_name]", filterRuleName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[resource_type]", filterResourceType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[@resource_id]", filterResourceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[discovery_timestamp]", filterDiscoveryTimestamp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[evaluation]", filterEvaluation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("multi", "filter[vulnerability_type]", filterVulnerabilityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "detailed_findings", detailedFindings));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listFindings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListFindingsResponse>> result = new CompletableFuture<ApiResponse<ListFindingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListFindingsResponse>(){});
    }

    public GetMultipleRulesetsResponse listMultipleRulesets(GetMultipleRulesetsRequest body) throws ApiException {
        return this.listMultipleRulesetsWithHttpInfo(body).getData();
    }

    public CompletableFuture<GetMultipleRulesetsResponse> listMultipleRulesetsAsync(GetMultipleRulesetsRequest body) {
        return this.listMultipleRulesetsWithHttpInfoAsync(body).thenApply(response -> (GetMultipleRulesetsResponse)response.getData());
    }

    public ApiResponse<GetMultipleRulesetsResponse> listMultipleRulesetsWithHttpInfo(GetMultipleRulesetsRequest body) throws ApiException {
        String operationId = "listMultipleRulesets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        GetMultipleRulesetsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listMultipleRulesets");
        }
        String localVarPath = "/api/v2/static-analysis/rulesets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listMultipleRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetMultipleRulesetsResponse>(){});
    }

    public CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>> listMultipleRulesetsWithHttpInfoAsync(GetMultipleRulesetsRequest body) {
        Invocation.Builder builder;
        String operationId = "listMultipleRulesets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>> result = new CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        GetMultipleRulesetsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>> result = new CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listMultipleRulesets"));
            return result;
        }
        String localVarPath = "/api/v2/static-analysis/rulesets";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listMultipleRulesets", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>> result = new CompletableFuture<ApiResponse<GetMultipleRulesetsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<GetMultipleRulesetsResponse>(){});
    }

    public ScannedAssetsMetadata listScannedAssetsMetadata() throws ApiException {
        return this.listScannedAssetsMetadataWithHttpInfo(new ListScannedAssetsMetadataOptionalParameters()).getData();
    }

    public CompletableFuture<ScannedAssetsMetadata> listScannedAssetsMetadataAsync() {
        return this.listScannedAssetsMetadataWithHttpInfoAsync(new ListScannedAssetsMetadataOptionalParameters()).thenApply(response -> (ScannedAssetsMetadata)response.getData());
    }

    public ScannedAssetsMetadata listScannedAssetsMetadata(ListScannedAssetsMetadataOptionalParameters parameters) throws ApiException {
        return this.listScannedAssetsMetadataWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ScannedAssetsMetadata> listScannedAssetsMetadataAsync(ListScannedAssetsMetadataOptionalParameters parameters) {
        return this.listScannedAssetsMetadataWithHttpInfoAsync(parameters).thenApply(response -> (ScannedAssetsMetadata)response.getData());
    }

    public ApiResponse<ScannedAssetsMetadata> listScannedAssetsMetadataWithHttpInfo(ListScannedAssetsMetadataOptionalParameters parameters) throws ApiException {
        String operationId = "listScannedAssetsMetadata";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        CloudAssetType filterAssetType = parameters.filterAssetType;
        String filterAssetName = parameters.filterAssetName;
        String filterLastSuccessOrigin = parameters.filterLastSuccessOrigin;
        String filterLastSuccessEnv = parameters.filterLastSuccessEnv;
        String localVarPath = "/api/v2/security/scanned-assets-metadata";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[last_success.origin]", filterLastSuccessOrigin));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[last_success.env]", filterLastSuccessEnv));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listScannedAssetsMetadata", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ScannedAssetsMetadata>(){});
    }

    public CompletableFuture<ApiResponse<ScannedAssetsMetadata>> listScannedAssetsMetadataWithHttpInfoAsync(ListScannedAssetsMetadataOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listScannedAssetsMetadata";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ScannedAssetsMetadata>> result = new CompletableFuture<ApiResponse<ScannedAssetsMetadata>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        CloudAssetType filterAssetType = parameters.filterAssetType;
        String filterAssetName = parameters.filterAssetName;
        String filterLastSuccessOrigin = parameters.filterLastSuccessOrigin;
        String filterLastSuccessEnv = parameters.filterLastSuccessEnv;
        String localVarPath = "/api/v2/security/scanned-assets-metadata";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[last_success.origin]", filterLastSuccessOrigin));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[last_success.env]", filterLastSuccessEnv));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listScannedAssetsMetadata", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ScannedAssetsMetadata>> result = new CompletableFuture<ApiResponse<ScannedAssetsMetadata>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ScannedAssetsMetadata>(){});
    }

    public SecurityFiltersResponse listSecurityFilters() throws ApiException {
        return this.listSecurityFiltersWithHttpInfo().getData();
    }

    public CompletableFuture<SecurityFiltersResponse> listSecurityFiltersAsync() {
        return this.listSecurityFiltersWithHttpInfoAsync().thenApply(response -> (SecurityFiltersResponse)response.getData());
    }

    public ApiResponse<SecurityFiltersResponse> listSecurityFiltersWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFiltersResponse>> listSecurityFiltersWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFiltersResponse>> result = new CompletableFuture<ApiResponse<SecurityFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFiltersResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringHistsignals() throws ApiException {
        return this.listSecurityMonitoringHistsignalsWithHttpInfo(new ListSecurityMonitoringHistsignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringHistsignalsAsync() {
        return this.listSecurityMonitoringHistsignalsWithHttpInfoAsync(new ListSecurityMonitoringHistsignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringHistsignals(ListSecurityMonitoringHistsignalsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringHistsignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringHistsignalsAsync(ListSecurityMonitoringHistsignalsOptionalParameters parameters) {
        return this.listSecurityMonitoringHistsignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> listSecurityMonitoringHistsignalsWithHttpInfo(ListSecurityMonitoringHistsignalsOptionalParameters parameters) throws ApiException {
        String operationId = "listSecurityMonitoringHistsignals";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringHistsignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> listSecurityMonitoringHistsignalsWithHttpInfoAsync(ListSecurityMonitoringHistsignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listSecurityMonitoringHistsignals";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringHistsignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules() throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(new ListSecurityMonitoringRulesOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync() {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(new ListSecurityMonitoringRulesOptionalParameters()).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public SecurityMonitoringListRulesResponse listSecurityMonitoringRules(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringRulesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        return this.listSecurityMonitoringRulesWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringListRulesResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringListRulesResponse> listSecurityMonitoringRulesWithHttpInfo(ListSecurityMonitoringRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> listSecurityMonitoringRulesWithHttpInfoAsync(ListSecurityMonitoringRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String localVarPath = "/api/v2/security_monitoring/rules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringListRulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringListRulesResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals() throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(new ListSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync() {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(new ListSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse listSecurityMonitoringSignals(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.listSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public PaginationIterable<SecurityMonitoringSignal> listSecurityMonitoringSignalsWithPagination() {
        ListSecurityMonitoringSignalsOptionalParameters parameters = new ListSecurityMonitoringSignalsOptionalParameters();
        return this.listSecurityMonitoringSignalsWithPagination(parameters);
    }

    public PaginationIterable<SecurityMonitoringSignal> listSecurityMonitoringSignalsWithPagination(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "pageCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 10;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<SecurityMonitoringSignal> iterator = new PaginationIterable<SecurityMonitoringSignal>(this, "listSecurityMonitoringSignals", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> listSecurityMonitoringSignalsWithHttpInfo(ListSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> listSecurityMonitoringSignalsWithHttpInfoAsync(ListSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String filterQuery = parameters.filterQuery;
        OffsetDateTime filterFrom = parameters.filterFrom;
        OffsetDateTime filterTo = parameters.filterTo;
        SecurityMonitoringSignalsSort sort = parameters.sort;
        String pageCursor = parameters.pageCursor;
        Integer pageLimit = parameters.pageLimit;
        String localVarPath = "/api/v2/security_monitoring/signals";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[from]", filterFrom));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[to]", filterTo));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[cursor]", pageCursor));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSignals", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringSuppressionsResponse listSecurityMonitoringSuppressions() throws ApiException {
        return this.listSecurityMonitoringSuppressionsWithHttpInfo(new ListSecurityMonitoringSuppressionsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionsResponse> listSecurityMonitoringSuppressionsAsync() {
        return this.listSecurityMonitoringSuppressionsWithHttpInfoAsync(new ListSecurityMonitoringSuppressionsOptionalParameters()).thenApply(response -> (SecurityMonitoringSuppressionsResponse)response.getData());
    }

    public SecurityMonitoringSuppressionsResponse listSecurityMonitoringSuppressions(ListSecurityMonitoringSuppressionsOptionalParameters parameters) throws ApiException {
        return this.listSecurityMonitoringSuppressionsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionsResponse> listSecurityMonitoringSuppressionsAsync(ListSecurityMonitoringSuppressionsOptionalParameters parameters) {
        return this.listSecurityMonitoringSuppressionsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSuppressionsResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionsResponse> listSecurityMonitoringSuppressionsWithHttpInfo(ListSecurityMonitoringSuppressionsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        String query = parameters.query;
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSuppressions", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> listSecurityMonitoringSuppressionsWithHttpInfoAsync(ListSecurityMonitoringSuppressionsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String query = parameters.query;
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listSecurityMonitoringSuppressions", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionsResponse>(){});
    }

    public ListThreatHuntingJobsResponse listThreatHuntingJobs() throws ApiException {
        return this.listThreatHuntingJobsWithHttpInfo(new ListThreatHuntingJobsOptionalParameters()).getData();
    }

    public CompletableFuture<ListThreatHuntingJobsResponse> listThreatHuntingJobsAsync() {
        return this.listThreatHuntingJobsWithHttpInfoAsync(new ListThreatHuntingJobsOptionalParameters()).thenApply(response -> (ListThreatHuntingJobsResponse)response.getData());
    }

    public ListThreatHuntingJobsResponse listThreatHuntingJobs(ListThreatHuntingJobsOptionalParameters parameters) throws ApiException {
        return this.listThreatHuntingJobsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListThreatHuntingJobsResponse> listThreatHuntingJobsAsync(ListThreatHuntingJobsOptionalParameters parameters) {
        return this.listThreatHuntingJobsWithHttpInfoAsync(parameters).thenApply(response -> (ListThreatHuntingJobsResponse)response.getData());
    }

    public ApiResponse<ListThreatHuntingJobsResponse> listThreatHuntingJobsWithHttpInfo(ListThreatHuntingJobsOptionalParameters parameters) throws ApiException {
        String operationId = "listThreatHuntingJobs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        String filterQuery = parameters.filterQuery;
        String localVarPath = "/api/v2/siem-threat-hunting/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listThreatHuntingJobs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListThreatHuntingJobsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListThreatHuntingJobsResponse>> listThreatHuntingJobsWithHttpInfoAsync(ListThreatHuntingJobsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listThreatHuntingJobs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListThreatHuntingJobsResponse>> result = new CompletableFuture<ApiResponse<ListThreatHuntingJobsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        String sort = parameters.sort;
        String filterQuery = parameters.filterQuery;
        String localVarPath = "/api/v2/siem-threat-hunting/jobs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[query]", filterQuery));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listThreatHuntingJobs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListThreatHuntingJobsResponse>> result = new CompletableFuture<ApiResponse<ListThreatHuntingJobsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListThreatHuntingJobsResponse>(){});
    }

    public ListVulnerabilitiesResponse listVulnerabilities() throws ApiException {
        return this.listVulnerabilitiesWithHttpInfo(new ListVulnerabilitiesOptionalParameters()).getData();
    }

    public CompletableFuture<ListVulnerabilitiesResponse> listVulnerabilitiesAsync() {
        return this.listVulnerabilitiesWithHttpInfoAsync(new ListVulnerabilitiesOptionalParameters()).thenApply(response -> (ListVulnerabilitiesResponse)response.getData());
    }

    public ListVulnerabilitiesResponse listVulnerabilities(ListVulnerabilitiesOptionalParameters parameters) throws ApiException {
        return this.listVulnerabilitiesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListVulnerabilitiesResponse> listVulnerabilitiesAsync(ListVulnerabilitiesOptionalParameters parameters) {
        return this.listVulnerabilitiesWithHttpInfoAsync(parameters).thenApply(response -> (ListVulnerabilitiesResponse)response.getData());
    }

    public ApiResponse<ListVulnerabilitiesResponse> listVulnerabilitiesWithHttpInfo(ListVulnerabilitiesOptionalParameters parameters) throws ApiException {
        String operationId = "listVulnerabilities";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        VulnerabilityType filterType = parameters.filterType;
        Double filterCvssBaseScoreOp = parameters.filterCvssBaseScoreOp;
        VulnerabilitySeverity filterCvssBaseSeverity = parameters.filterCvssBaseSeverity;
        String filterCvssBaseVector = parameters.filterCvssBaseVector;
        Double filterCvssDatadogScoreOp = parameters.filterCvssDatadogScoreOp;
        VulnerabilitySeverity filterCvssDatadogSeverity = parameters.filterCvssDatadogSeverity;
        String filterCvssDatadogVector = parameters.filterCvssDatadogVector;
        VulnerabilityStatus filterStatus = parameters.filterStatus;
        VulnerabilityTool filterTool = parameters.filterTool;
        String filterLibraryName = parameters.filterLibraryName;
        String filterLibraryVersion = parameters.filterLibraryVersion;
        String filterAdvisoryId = parameters.filterAdvisoryId;
        Boolean filterRisksExploitationProbability = parameters.filterRisksExploitationProbability;
        Boolean filterRisksPocExploitAvailable = parameters.filterRisksPocExploitAvailable;
        Boolean filterRisksExploitAvailable = parameters.filterRisksExploitAvailable;
        Double filterRisksEpssScoreOp = parameters.filterRisksEpssScoreOp;
        VulnerabilitySeverity filterRisksEpssSeverity = parameters.filterRisksEpssSeverity;
        String filterLanguage = parameters.filterLanguage;
        VulnerabilityEcosystem filterEcosystem = parameters.filterEcosystem;
        String filterCodeLocationLocation = parameters.filterCodeLocationLocation;
        String filterCodeLocationFilePath = parameters.filterCodeLocationFilePath;
        String filterCodeLocationMethod = parameters.filterCodeLocationMethod;
        Boolean filterFixAvailable = parameters.filterFixAvailable;
        String filterRepoDigests = parameters.filterRepoDigests;
        String filterOrigin = parameters.filterOrigin;
        String filterAssetName = parameters.filterAssetName;
        AssetType filterAssetType = parameters.filterAssetType;
        String filterAssetVersionFirst = parameters.filterAssetVersionFirst;
        String filterAssetVersionLast = parameters.filterAssetVersionLast;
        String filterAssetRepositoryUrl = parameters.filterAssetRepositoryUrl;
        Boolean filterAssetRisksInProduction = parameters.filterAssetRisksInProduction;
        Boolean filterAssetRisksUnderAttack = parameters.filterAssetRisksUnderAttack;
        Boolean filterAssetRisksIsPubliclyAccessible = parameters.filterAssetRisksIsPubliclyAccessible;
        Boolean filterAssetRisksHasPrivilegedAccess = parameters.filterAssetRisksHasPrivilegedAccess;
        Boolean filterAssetRisksHasAccessToSensitiveData = parameters.filterAssetRisksHasAccessToSensitiveData;
        String filterAssetEnvironments = parameters.filterAssetEnvironments;
        String filterAssetTeams = parameters.filterAssetTeams;
        String filterAssetArch = parameters.filterAssetArch;
        String filterAssetOperatingSystemName = parameters.filterAssetOperatingSystemName;
        String filterAssetOperatingSystemVersion = parameters.filterAssetOperatingSystemVersion;
        String localVarPath = "/api/v2/security/vulnerabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.score][`$op`]", filterCvssBaseScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.severity]", filterCvssBaseSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.vector]", filterCvssBaseVector));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.score][`$op`]", filterCvssDatadogScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.severity]", filterCvssDatadogSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.vector]", filterCvssDatadogVector));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tool]", filterTool));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[library.name]", filterLibraryName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[library.version]", filterLibraryVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[advisory.id]", filterAdvisoryId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.exploitation_probability]", filterRisksExploitationProbability));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.poc_exploit_available]", filterRisksPocExploitAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.exploit_available]", filterRisksExploitAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.epss.score][`$op`]", filterRisksEpssScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.epss.severity]", filterRisksEpssSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[language]", filterLanguage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[ecosystem]", filterEcosystem));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.location]", filterCodeLocationLocation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.file_path]", filterCodeLocationFilePath));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.method]", filterCodeLocationMethod));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[fix_available]", filterFixAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repo_digests]", filterRepoDigests));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[origin]", filterOrigin));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.version.first]", filterAssetVersionFirst));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.version.last]", filterAssetVersionLast));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.repository_url]", filterAssetRepositoryUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.in_production]", filterAssetRisksInProduction));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.under_attack]", filterAssetRisksUnderAttack));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.is_publicly_accessible]", filterAssetRisksIsPubliclyAccessible));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.has_privileged_access]", filterAssetRisksHasPrivilegedAccess));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.has_access_to_sensitive_data]", filterAssetRisksHasAccessToSensitiveData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.environments]", filterAssetEnvironments));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.teams]", filterAssetTeams));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.arch]", filterAssetArch));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.operating_system.name]", filterAssetOperatingSystemName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.operating_system.version]", filterAssetOperatingSystemVersion));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listVulnerabilities", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListVulnerabilitiesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListVulnerabilitiesResponse>> listVulnerabilitiesWithHttpInfoAsync(ListVulnerabilitiesOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listVulnerabilities";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListVulnerabilitiesResponse>> result = new CompletableFuture<ApiResponse<ListVulnerabilitiesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        VulnerabilityType filterType = parameters.filterType;
        Double filterCvssBaseScoreOp = parameters.filterCvssBaseScoreOp;
        VulnerabilitySeverity filterCvssBaseSeverity = parameters.filterCvssBaseSeverity;
        String filterCvssBaseVector = parameters.filterCvssBaseVector;
        Double filterCvssDatadogScoreOp = parameters.filterCvssDatadogScoreOp;
        VulnerabilitySeverity filterCvssDatadogSeverity = parameters.filterCvssDatadogSeverity;
        String filterCvssDatadogVector = parameters.filterCvssDatadogVector;
        VulnerabilityStatus filterStatus = parameters.filterStatus;
        VulnerabilityTool filterTool = parameters.filterTool;
        String filterLibraryName = parameters.filterLibraryName;
        String filterLibraryVersion = parameters.filterLibraryVersion;
        String filterAdvisoryId = parameters.filterAdvisoryId;
        Boolean filterRisksExploitationProbability = parameters.filterRisksExploitationProbability;
        Boolean filterRisksPocExploitAvailable = parameters.filterRisksPocExploitAvailable;
        Boolean filterRisksExploitAvailable = parameters.filterRisksExploitAvailable;
        Double filterRisksEpssScoreOp = parameters.filterRisksEpssScoreOp;
        VulnerabilitySeverity filterRisksEpssSeverity = parameters.filterRisksEpssSeverity;
        String filterLanguage = parameters.filterLanguage;
        VulnerabilityEcosystem filterEcosystem = parameters.filterEcosystem;
        String filterCodeLocationLocation = parameters.filterCodeLocationLocation;
        String filterCodeLocationFilePath = parameters.filterCodeLocationFilePath;
        String filterCodeLocationMethod = parameters.filterCodeLocationMethod;
        Boolean filterFixAvailable = parameters.filterFixAvailable;
        String filterRepoDigests = parameters.filterRepoDigests;
        String filterOrigin = parameters.filterOrigin;
        String filterAssetName = parameters.filterAssetName;
        AssetType filterAssetType = parameters.filterAssetType;
        String filterAssetVersionFirst = parameters.filterAssetVersionFirst;
        String filterAssetVersionLast = parameters.filterAssetVersionLast;
        String filterAssetRepositoryUrl = parameters.filterAssetRepositoryUrl;
        Boolean filterAssetRisksInProduction = parameters.filterAssetRisksInProduction;
        Boolean filterAssetRisksUnderAttack = parameters.filterAssetRisksUnderAttack;
        Boolean filterAssetRisksIsPubliclyAccessible = parameters.filterAssetRisksIsPubliclyAccessible;
        Boolean filterAssetRisksHasPrivilegedAccess = parameters.filterAssetRisksHasPrivilegedAccess;
        Boolean filterAssetRisksHasAccessToSensitiveData = parameters.filterAssetRisksHasAccessToSensitiveData;
        String filterAssetEnvironments = parameters.filterAssetEnvironments;
        String filterAssetTeams = parameters.filterAssetTeams;
        String filterAssetArch = parameters.filterAssetArch;
        String filterAssetOperatingSystemName = parameters.filterAssetOperatingSystemName;
        String filterAssetOperatingSystemVersion = parameters.filterAssetOperatingSystemVersion;
        String localVarPath = "/api/v2/security/vulnerabilities";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.score][`$op`]", filterCvssBaseScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.severity]", filterCvssBaseSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.base.vector]", filterCvssBaseVector));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.score][`$op`]", filterCvssDatadogScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.severity]", filterCvssDatadogSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[cvss.datadog.vector]", filterCvssDatadogVector));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[status]", filterStatus));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[tool]", filterTool));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[library.name]", filterLibraryName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[library.version]", filterLibraryVersion));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[advisory.id]", filterAdvisoryId));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.exploitation_probability]", filterRisksExploitationProbability));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.poc_exploit_available]", filterRisksPocExploitAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.exploit_available]", filterRisksExploitAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.epss.score][`$op`]", filterRisksEpssScoreOp));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.epss.severity]", filterRisksEpssSeverity));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[language]", filterLanguage));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[ecosystem]", filterEcosystem));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.location]", filterCodeLocationLocation));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.file_path]", filterCodeLocationFilePath));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[code_location.method]", filterCodeLocationMethod));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[fix_available]", filterFixAvailable));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repo_digests]", filterRepoDigests));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[origin]", filterOrigin));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.name]", filterAssetName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.type]", filterAssetType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.version.first]", filterAssetVersionFirst));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.version.last]", filterAssetVersionLast));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.repository_url]", filterAssetRepositoryUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.in_production]", filterAssetRisksInProduction));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.under_attack]", filterAssetRisksUnderAttack));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.is_publicly_accessible]", filterAssetRisksIsPubliclyAccessible));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.has_privileged_access]", filterAssetRisksHasPrivilegedAccess));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.risks.has_access_to_sensitive_data]", filterAssetRisksHasAccessToSensitiveData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.environments]", filterAssetEnvironments));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.teams]", filterAssetTeams));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.arch]", filterAssetArch));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.operating_system.name]", filterAssetOperatingSystemName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[asset.operating_system.version]", filterAssetOperatingSystemVersion));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listVulnerabilities", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListVulnerabilitiesResponse>> result = new CompletableFuture<ApiResponse<ListVulnerabilitiesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListVulnerabilitiesResponse>(){});
    }

    public ListVulnerableAssetsResponse listVulnerableAssets() throws ApiException {
        return this.listVulnerableAssetsWithHttpInfo(new ListVulnerableAssetsOptionalParameters()).getData();
    }

    public CompletableFuture<ListVulnerableAssetsResponse> listVulnerableAssetsAsync() {
        return this.listVulnerableAssetsWithHttpInfoAsync(new ListVulnerableAssetsOptionalParameters()).thenApply(response -> (ListVulnerableAssetsResponse)response.getData());
    }

    public ListVulnerableAssetsResponse listVulnerableAssets(ListVulnerableAssetsOptionalParameters parameters) throws ApiException {
        return this.listVulnerableAssetsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListVulnerableAssetsResponse> listVulnerableAssetsAsync(ListVulnerableAssetsOptionalParameters parameters) {
        return this.listVulnerableAssetsWithHttpInfoAsync(parameters).thenApply(response -> (ListVulnerableAssetsResponse)response.getData());
    }

    public ApiResponse<ListVulnerableAssetsResponse> listVulnerableAssetsWithHttpInfo(ListVulnerableAssetsOptionalParameters parameters) throws ApiException {
        String operationId = "listVulnerableAssets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        String filterName = parameters.filterName;
        AssetType filterType = parameters.filterType;
        String filterVersionFirst = parameters.filterVersionFirst;
        String filterVersionLast = parameters.filterVersionLast;
        String filterRepositoryUrl = parameters.filterRepositoryUrl;
        Boolean filterRisksInProduction = parameters.filterRisksInProduction;
        Boolean filterRisksUnderAttack = parameters.filterRisksUnderAttack;
        Boolean filterRisksIsPubliclyAccessible = parameters.filterRisksIsPubliclyAccessible;
        Boolean filterRisksHasPrivilegedAccess = parameters.filterRisksHasPrivilegedAccess;
        Boolean filterRisksHasAccessToSensitiveData = parameters.filterRisksHasAccessToSensitiveData;
        String filterEnvironments = parameters.filterEnvironments;
        String filterTeams = parameters.filterTeams;
        String filterArch = parameters.filterArch;
        String filterOperatingSystemName = parameters.filterOperatingSystemName;
        String filterOperatingSystemVersion = parameters.filterOperatingSystemVersion;
        String localVarPath = "/api/v2/security/vulnerable-assets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[version.first]", filterVersionFirst));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[version.last]", filterVersionLast));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repository_url]", filterRepositoryUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.in_production]", filterRisksInProduction));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.under_attack]", filterRisksUnderAttack));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.is_publicly_accessible]", filterRisksIsPubliclyAccessible));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.has_privileged_access]", filterRisksHasPrivilegedAccess));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.has_access_to_sensitive_data]", filterRisksHasAccessToSensitiveData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[environments]", filterEnvironments));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[teams]", filterTeams));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[arch]", filterArch));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[operating_system.name]", filterOperatingSystemName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[operating_system.version]", filterOperatingSystemVersion));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listVulnerableAssets", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListVulnerableAssetsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListVulnerableAssetsResponse>> listVulnerableAssetsWithHttpInfoAsync(ListVulnerableAssetsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listVulnerableAssets";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListVulnerableAssetsResponse>> result = new CompletableFuture<ApiResponse<ListVulnerableAssetsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String pageToken = parameters.pageToken;
        Long pageNumber = parameters.pageNumber;
        String filterName = parameters.filterName;
        AssetType filterType = parameters.filterType;
        String filterVersionFirst = parameters.filterVersionFirst;
        String filterVersionLast = parameters.filterVersionLast;
        String filterRepositoryUrl = parameters.filterRepositoryUrl;
        Boolean filterRisksInProduction = parameters.filterRisksInProduction;
        Boolean filterRisksUnderAttack = parameters.filterRisksUnderAttack;
        Boolean filterRisksIsPubliclyAccessible = parameters.filterRisksIsPubliclyAccessible;
        Boolean filterRisksHasPrivilegedAccess = parameters.filterRisksHasPrivilegedAccess;
        Boolean filterRisksHasAccessToSensitiveData = parameters.filterRisksHasAccessToSensitiveData;
        String filterEnvironments = parameters.filterEnvironments;
        String filterTeams = parameters.filterTeams;
        String filterArch = parameters.filterArch;
        String filterOperatingSystemName = parameters.filterOperatingSystemName;
        String filterOperatingSystemVersion = parameters.filterOperatingSystemVersion;
        String localVarPath = "/api/v2/security/vulnerable-assets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[token]", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[name]", filterName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[type]", filterType));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[version.first]", filterVersionFirst));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[version.last]", filterVersionLast));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[repository_url]", filterRepositoryUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.in_production]", filterRisksInProduction));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.under_attack]", filterRisksUnderAttack));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.is_publicly_accessible]", filterRisksIsPubliclyAccessible));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.has_privileged_access]", filterRisksHasPrivilegedAccess));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[risks.has_access_to_sensitive_data]", filterRisksHasAccessToSensitiveData));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[environments]", filterEnvironments));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[teams]", filterTeams));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[arch]", filterArch));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[operating_system.name]", filterOperatingSystemName));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[operating_system.version]", filterOperatingSystemVersion));
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.listVulnerableAssets", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListVulnerableAssetsResponse>> result = new CompletableFuture<ApiResponse<ListVulnerableAssetsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListVulnerableAssetsResponse>(){});
    }

    public BulkMuteFindingsResponse muteFindings(BulkMuteFindingsRequest body) throws ApiException {
        return this.muteFindingsWithHttpInfo(body).getData();
    }

    public CompletableFuture<BulkMuteFindingsResponse> muteFindingsAsync(BulkMuteFindingsRequest body) {
        return this.muteFindingsWithHttpInfoAsync(body).thenApply(response -> (BulkMuteFindingsResponse)response.getData());
    }

    public ApiResponse<BulkMuteFindingsResponse> muteFindingsWithHttpInfo(BulkMuteFindingsRequest body) throws ApiException {
        String operationId = "muteFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        BulkMuteFindingsRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling muteFindings");
        }
        String localVarPath = "/api/v2/posture_management/findings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.muteFindings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BulkMuteFindingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> muteFindingsWithHttpInfoAsync(BulkMuteFindingsRequest body) {
        Invocation.Builder builder;
        String operationId = "muteFindings";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        BulkMuteFindingsRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling muteFindings"));
            return result;
        }
        String localVarPath = "/api/v2/posture_management/findings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.muteFindings", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<BulkMuteFindingsResponse>> result = new CompletableFuture<ApiResponse<BulkMuteFindingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<BulkMuteFindingsResponse>(){});
    }

    public NotificationRuleResponse patchSignalNotificationRule(String id, PatchNotificationRuleParameters body) throws ApiException {
        return this.patchSignalNotificationRuleWithHttpInfo(id, body).getData();
    }

    public CompletableFuture<NotificationRuleResponse> patchSignalNotificationRuleAsync(String id, PatchNotificationRuleParameters body) {
        return this.patchSignalNotificationRuleWithHttpInfoAsync(id, body).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> patchSignalNotificationRuleWithHttpInfo(String id, PatchNotificationRuleParameters body) throws ApiException {
        PatchNotificationRuleParameters localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling patchSignalNotificationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchSignalNotificationRule");
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.patchSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> patchSignalNotificationRuleWithHttpInfoAsync(String id, PatchNotificationRuleParameters body) {
        Invocation.Builder builder;
        PatchNotificationRuleParameters localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling patchSignalNotificationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling patchSignalNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/signals/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.patchSignalNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public NotificationRuleResponse patchVulnerabilityNotificationRule(String id, PatchNotificationRuleParameters body) throws ApiException {
        return this.patchVulnerabilityNotificationRuleWithHttpInfo(id, body).getData();
    }

    public CompletableFuture<NotificationRuleResponse> patchVulnerabilityNotificationRuleAsync(String id, PatchNotificationRuleParameters body) {
        return this.patchVulnerabilityNotificationRuleWithHttpInfoAsync(id, body).thenApply(response -> (NotificationRuleResponse)response.getData());
    }

    public ApiResponse<NotificationRuleResponse> patchVulnerabilityNotificationRuleWithHttpInfo(String id, PatchNotificationRuleParameters body) throws ApiException {
        PatchNotificationRuleParameters localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling patchVulnerabilityNotificationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling patchVulnerabilityNotificationRule");
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.patchVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<NotificationRuleResponse>> patchVulnerabilityNotificationRuleWithHttpInfoAsync(String id, PatchNotificationRuleParameters body) {
        Invocation.Builder builder;
        PatchNotificationRuleParameters localVarPostBody = body;
        if (id == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling patchVulnerabilityNotificationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling patchVulnerabilityNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/security/vulnerabilities/notification_rules/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.patchVulnerabilityNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationRuleResponse>> result = new CompletableFuture<ApiResponse<NotificationRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationRuleResponse>(){});
    }

    public JobCreateResponse runThreatHuntingJob(RunThreatHuntingJobRequest body) throws ApiException {
        return this.runThreatHuntingJobWithHttpInfo(body).getData();
    }

    public CompletableFuture<JobCreateResponse> runThreatHuntingJobAsync(RunThreatHuntingJobRequest body) {
        return this.runThreatHuntingJobWithHttpInfoAsync(body).thenApply(response -> (JobCreateResponse)response.getData());
    }

    public ApiResponse<JobCreateResponse> runThreatHuntingJobWithHttpInfo(RunThreatHuntingJobRequest body) throws ApiException {
        String operationId = "runThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RunThreatHuntingJobRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling runThreatHuntingJob");
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.runThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<JobCreateResponse>(){});
    }

    public CompletableFuture<ApiResponse<JobCreateResponse>> runThreatHuntingJobWithHttpInfoAsync(RunThreatHuntingJobRequest body) {
        Invocation.Builder builder;
        String operationId = "runThreatHuntingJob";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<JobCreateResponse>> result = new CompletableFuture<ApiResponse<JobCreateResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        RunThreatHuntingJobRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<JobCreateResponse>> result = new CompletableFuture<ApiResponse<JobCreateResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling runThreatHuntingJob"));
            return result;
        }
        String localVarPath = "/api/v2/siem-threat-hunting/jobs";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.runThreatHuntingJob", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<JobCreateResponse>> result = new CompletableFuture<ApiResponse<JobCreateResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<JobCreateResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringHistsignals() throws ApiException {
        return this.searchSecurityMonitoringHistsignalsWithHttpInfo(new SearchSecurityMonitoringHistsignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringHistsignalsAsync() {
        return this.searchSecurityMonitoringHistsignalsWithHttpInfoAsync(new SearchSecurityMonitoringHistsignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringHistsignals(SearchSecurityMonitoringHistsignalsOptionalParameters parameters) throws ApiException {
        return this.searchSecurityMonitoringHistsignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringHistsignalsAsync(SearchSecurityMonitoringHistsignalsOptionalParameters parameters) {
        return this.searchSecurityMonitoringHistsignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringHistsignalsWithHttpInfo(SearchSecurityMonitoringHistsignalsOptionalParameters parameters) throws ApiException {
        String operationId = "searchSecurityMonitoringHistsignals";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringHistsignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> searchSecurityMonitoringHistsignalsWithHttpInfoAsync(SearchSecurityMonitoringHistsignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "searchSecurityMonitoringHistsignals";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/siem-threat-hunting/histsignals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringHistsignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals() throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(new SearchSecurityMonitoringSignalsOptionalParameters()).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync() {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(new SearchSecurityMonitoringSignalsOptionalParameters()).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public SecurityMonitoringSignalsListResponse searchSecurityMonitoringSignals(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        return this.searchSecurityMonitoringSignalsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        return this.searchSecurityMonitoringSignalsWithHttpInfoAsync(parameters).thenApply(response -> (SecurityMonitoringSignalsListResponse)response.getData());
    }

    public PaginationIterable<SecurityMonitoringSignal> searchSecurityMonitoringSignalsWithPagination() {
        SearchSecurityMonitoringSignalsOptionalParameters parameters = new SearchSecurityMonitoringSignalsOptionalParameters();
        return this.searchSecurityMonitoringSignalsWithPagination(parameters);
    }

    public PaginationIterable<SecurityMonitoringSignal> searchSecurityMonitoringSignalsWithPagination(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        Integer limit;
        String resultsPath = "getData";
        String valueGetterPath = "getMeta.getPage.getAfter";
        String valueSetterPath = "body.getPage.setCursor";
        Boolean valueSetterParamOptional = true;
        if (parameters.body == null) {
            parameters.body(new SecurityMonitoringSignalListRequest());
        }
        if (parameters.body.getPage() == null) {
            parameters.body.setPage(new SecurityMonitoringSignalListRequestPage());
        }
        if (parameters.body.getPage().getLimit() == null) {
            limit = 10;
            parameters.body.getPage().setLimit(limit);
        } else {
            limit = parameters.body.getPage().getLimit();
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<SecurityMonitoringSignal> iterator = new PaginationIterable<SecurityMonitoringSignal>(this, "searchSecurityMonitoringSignals", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<SecurityMonitoringSignalsListResponse> searchSecurityMonitoringSignalsWithHttpInfo(SearchSecurityMonitoringSignalsOptionalParameters parameters) throws ApiException {
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> searchSecurityMonitoringSignalsWithHttpInfoAsync(SearchSecurityMonitoringSignalsOptionalParameters parameters) {
        Invocation.Builder builder;
        SecurityMonitoringSignalListRequest localVarPostBody = parameters.body;
        String localVarPath = "/api/v2/security_monitoring/signals/search";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.searchSecurityMonitoringSignals", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSignalsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSignalsListResponse>(){});
    }

    public SecurityMonitoringRuleTestResponse testExistingSecurityMonitoringRule(String ruleId, SecurityMonitoringRuleTestRequest body) throws ApiException {
        return this.testExistingSecurityMonitoringRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleTestResponse> testExistingSecurityMonitoringRuleAsync(String ruleId, SecurityMonitoringRuleTestRequest body) {
        return this.testExistingSecurityMonitoringRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SecurityMonitoringRuleTestResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleTestResponse> testExistingSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleTestRequest body) throws ApiException {
        SecurityMonitoringRuleTestRequest localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling testExistingSecurityMonitoringRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling testExistingSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/test".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.testExistingSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleTestResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> testExistingSecurityMonitoringRuleWithHttpInfoAsync(String ruleId, SecurityMonitoringRuleTestRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleTestRequest localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling testExistingSecurityMonitoringRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling testExistingSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}/test".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.testExistingSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleTestResponse>(){});
    }

    public SecurityMonitoringRuleTestResponse testSecurityMonitoringRule(SecurityMonitoringRuleTestRequest body) throws ApiException {
        return this.testSecurityMonitoringRuleWithHttpInfo(body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleTestResponse> testSecurityMonitoringRuleAsync(SecurityMonitoringRuleTestRequest body) {
        return this.testSecurityMonitoringRuleWithHttpInfoAsync(body).thenApply(response -> (SecurityMonitoringRuleTestResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleTestResponse> testSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleTestRequest body) throws ApiException {
        SecurityMonitoringRuleTestRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling testSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/test";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.testSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleTestResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> testSecurityMonitoringRuleWithHttpInfoAsync(SecurityMonitoringRuleTestRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleTestRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling testSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/test";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.testSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleTestResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleTestResponse>(){});
    }

    public UpdateCustomFrameworkResponse updateCustomFramework(String handle, String version, UpdateCustomFrameworkRequest body) throws ApiException {
        return this.updateCustomFrameworkWithHttpInfo(handle, version, body).getData();
    }

    public CompletableFuture<UpdateCustomFrameworkResponse> updateCustomFrameworkAsync(String handle, String version, UpdateCustomFrameworkRequest body) {
        return this.updateCustomFrameworkWithHttpInfoAsync(handle, version, body).thenApply(response -> (UpdateCustomFrameworkResponse)response.getData());
    }

    public ApiResponse<UpdateCustomFrameworkResponse> updateCustomFrameworkWithHttpInfo(String handle, String version, UpdateCustomFrameworkRequest body) throws ApiException {
        UpdateCustomFrameworkRequest localVarPostBody = body;
        if (handle == null) {
            throw new ApiException(400, "Missing the required parameter 'handle' when calling updateCustomFramework");
        }
        if (version == null) {
            throw new ApiException(400, "Missing the required parameter 'version' when calling updateCustomFramework");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateCustomFramework");
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateCustomFrameworkResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>> updateCustomFrameworkWithHttpInfoAsync(String handle, String version, UpdateCustomFrameworkRequest body) {
        Invocation.Builder builder;
        UpdateCustomFrameworkRequest localVarPostBody = body;
        if (handle == null) {
            CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'handle' when calling updateCustomFramework"));
            return result;
        }
        if (version == null) {
            CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'version' when calling updateCustomFramework"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateCustomFramework"));
            return result;
        }
        String localVarPath = "/api/v2/cloud_security_management/custom_frameworks/{handle}/{version}".replaceAll("\\{handle\\}", this.apiClient.escapeString(handle.toString())).replaceAll("\\{version\\}", this.apiClient.escapeString(version.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateCustomFramework", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>> result = new CompletableFuture<ApiResponse<UpdateCustomFrameworkResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateCustomFrameworkResponse>(){});
    }

    public UpdateResourceEvaluationFiltersResponse updateResourceEvaluationFilters(UpdateResourceEvaluationFiltersRequest body) throws ApiException {
        return this.updateResourceEvaluationFiltersWithHttpInfo(body).getData();
    }

    public CompletableFuture<UpdateResourceEvaluationFiltersResponse> updateResourceEvaluationFiltersAsync(UpdateResourceEvaluationFiltersRequest body) {
        return this.updateResourceEvaluationFiltersWithHttpInfoAsync(body).thenApply(response -> (UpdateResourceEvaluationFiltersResponse)response.getData());
    }

    public ApiResponse<UpdateResourceEvaluationFiltersResponse> updateResourceEvaluationFiltersWithHttpInfo(UpdateResourceEvaluationFiltersRequest body) throws ApiException {
        UpdateResourceEvaluationFiltersRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateResourceEvaluationFilters");
        }
        String localVarPath = "/api/v2/cloud_security_management/resource_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateResourceEvaluationFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateResourceEvaluationFiltersResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateResourceEvaluationFiltersResponse>> updateResourceEvaluationFiltersWithHttpInfoAsync(UpdateResourceEvaluationFiltersRequest body) {
        Invocation.Builder builder;
        UpdateResourceEvaluationFiltersRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<UpdateResourceEvaluationFiltersResponse>> result = new CompletableFuture<ApiResponse<UpdateResourceEvaluationFiltersResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateResourceEvaluationFilters"));
            return result;
        }
        String localVarPath = "/api/v2/cloud_security_management/resource_filters";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateResourceEvaluationFilters", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateResourceEvaluationFiltersResponse>> result = new CompletableFuture<ApiResponse<UpdateResourceEvaluationFiltersResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<UpdateResourceEvaluationFiltersResponse>(){});
    }

    public SecurityFilterResponse updateSecurityFilter(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        return this.updateSecurityFilterWithHttpInfo(securityFilterId, body).getData();
    }

    public CompletableFuture<SecurityFilterResponse> updateSecurityFilterAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        return this.updateSecurityFilterWithHttpInfoAsync(securityFilterId, body).thenApply(response -> (SecurityFilterResponse)response.getData());
    }

    public ApiResponse<SecurityFilterResponse> updateSecurityFilterWithHttpInfo(String securityFilterId, SecurityFilterUpdateRequest body) throws ApiException {
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityFilterResponse>> updateSecurityFilterWithHttpInfoAsync(String securityFilterId, SecurityFilterUpdateRequest body) {
        Invocation.Builder builder;
        SecurityFilterUpdateRequest localVarPostBody = body;
        if (securityFilterId == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'securityFilterId' when calling updateSecurityFilter"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityFilter"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/security_filters/{security_filter_id}".replaceAll("\\{security_filter_id\\}", this.apiClient.escapeString(securityFilterId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityFilter", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityFilterResponse>> result = new CompletableFuture<ApiResponse<SecurityFilterResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityFilterResponse>(){});
    }

    public SecurityMonitoringRuleResponse updateSecurityMonitoringRule(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        return this.updateSecurityMonitoringRuleWithHttpInfo(ruleId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        return this.updateSecurityMonitoringRuleWithHttpInfoAsync(ruleId, body).thenApply(response -> (SecurityMonitoringRuleResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringRuleResponse> updateSecurityMonitoringRuleWithHttpInfo(String ruleId, SecurityMonitoringRuleUpdatePayload body) throws ApiException {
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> updateSecurityMonitoringRuleWithHttpInfoAsync(String ruleId, SecurityMonitoringRuleUpdatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleUpdatePayload localVarPostBody = body;
        if (ruleId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateSecurityMonitoringRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/{rule_id}".replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringRuleResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringRuleResponse>(){});
    }

    public SecurityMonitoringSuppressionResponse updateSecurityMonitoringSuppression(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) throws ApiException {
        return this.updateSecurityMonitoringSuppressionWithHttpInfo(suppressionId, body).getData();
    }

    public CompletableFuture<SecurityMonitoringSuppressionResponse> updateSecurityMonitoringSuppressionAsync(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) {
        return this.updateSecurityMonitoringSuppressionWithHttpInfoAsync(suppressionId, body).thenApply(response -> (SecurityMonitoringSuppressionResponse)response.getData());
    }

    public ApiResponse<SecurityMonitoringSuppressionResponse> updateSecurityMonitoringSuppressionWithHttpInfo(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) throws ApiException {
        SecurityMonitoringSuppressionUpdateRequest localVarPostBody = body;
        if (suppressionId == null) {
            throw new ApiException(400, "Missing the required parameter 'suppressionId' when calling updateSecurityMonitoringSuppression");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> updateSecurityMonitoringSuppressionWithHttpInfoAsync(String suppressionId, SecurityMonitoringSuppressionUpdateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSuppressionUpdateRequest localVarPostBody = body;
        if (suppressionId == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'suppressionId' when calling updateSecurityMonitoringSuppression"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/{suppression_id}".replaceAll("\\{suppression_id\\}", this.apiClient.escapeString(suppressionId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.updateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>> result = new CompletableFuture<ApiResponse<SecurityMonitoringSuppressionResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<SecurityMonitoringSuppressionResponse>(){});
    }

    public void validateSecurityMonitoringRule(SecurityMonitoringRuleValidatePayload body) throws ApiException {
        this.validateSecurityMonitoringRuleWithHttpInfo(body);
    }

    public CompletableFuture<Void> validateSecurityMonitoringRuleAsync(SecurityMonitoringRuleValidatePayload body) {
        return this.validateSecurityMonitoringRuleWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> validateSecurityMonitoringRuleWithHttpInfo(SecurityMonitoringRuleValidatePayload body) throws ApiException {
        SecurityMonitoringRuleValidatePayload localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateSecurityMonitoringRule");
        }
        String localVarPath = "/api/v2/security_monitoring/rules/validation";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.validateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> validateSecurityMonitoringRuleWithHttpInfoAsync(SecurityMonitoringRuleValidatePayload body) {
        Invocation.Builder builder;
        SecurityMonitoringRuleValidatePayload localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateSecurityMonitoringRule"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/rules/validation";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.validateSecurityMonitoringRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void validateSecurityMonitoringSuppression(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        this.validateSecurityMonitoringSuppressionWithHttpInfo(body);
    }

    public CompletableFuture<Void> validateSecurityMonitoringSuppressionAsync(SecurityMonitoringSuppressionCreateRequest body) {
        return this.validateSecurityMonitoringSuppressionWithHttpInfoAsync(body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> validateSecurityMonitoringSuppressionWithHttpInfo(SecurityMonitoringSuppressionCreateRequest body) throws ApiException {
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling validateSecurityMonitoringSuppression");
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/validation";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.validateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> validateSecurityMonitoringSuppressionWithHttpInfoAsync(SecurityMonitoringSuppressionCreateRequest body) {
        Invocation.Builder builder;
        SecurityMonitoringSuppressionCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling validateSecurityMonitoringSuppression"));
            return result;
        }
        String localVarPath = "/api/v2/security_monitoring/configuration/suppressions/validation";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SecurityMonitoringApi.validateSecurityMonitoringSuppression", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public static class SearchSecurityMonitoringSignalsOptionalParameters {
        private SecurityMonitoringSignalListRequest body;

        public SearchSecurityMonitoringSignalsOptionalParameters body(SecurityMonitoringSignalListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class SearchSecurityMonitoringHistsignalsOptionalParameters {
        private SecurityMonitoringSignalListRequest body;

        public SearchSecurityMonitoringHistsignalsOptionalParameters body(SecurityMonitoringSignalListRequest body) {
            this.body = body;
            return this;
        }
    }

    public static class ListVulnerableAssetsOptionalParameters {
        private String pageToken;
        private Long pageNumber;
        private String filterName;
        private AssetType filterType;
        private String filterVersionFirst;
        private String filterVersionLast;
        private String filterRepositoryUrl;
        private Boolean filterRisksInProduction;
        private Boolean filterRisksUnderAttack;
        private Boolean filterRisksIsPubliclyAccessible;
        private Boolean filterRisksHasPrivilegedAccess;
        private Boolean filterRisksHasAccessToSensitiveData;
        private String filterEnvironments;
        private String filterTeams;
        private String filterArch;
        private String filterOperatingSystemName;
        private String filterOperatingSystemVersion;

        public ListVulnerableAssetsOptionalParameters pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterName(String filterName) {
            this.filterName = filterName;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterType(AssetType filterType) {
            this.filterType = filterType;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterVersionFirst(String filterVersionFirst) {
            this.filterVersionFirst = filterVersionFirst;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterVersionLast(String filterVersionLast) {
            this.filterVersionLast = filterVersionLast;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRepositoryUrl(String filterRepositoryUrl) {
            this.filterRepositoryUrl = filterRepositoryUrl;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRisksInProduction(Boolean filterRisksInProduction) {
            this.filterRisksInProduction = filterRisksInProduction;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRisksUnderAttack(Boolean filterRisksUnderAttack) {
            this.filterRisksUnderAttack = filterRisksUnderAttack;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRisksIsPubliclyAccessible(Boolean filterRisksIsPubliclyAccessible) {
            this.filterRisksIsPubliclyAccessible = filterRisksIsPubliclyAccessible;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRisksHasPrivilegedAccess(Boolean filterRisksHasPrivilegedAccess) {
            this.filterRisksHasPrivilegedAccess = filterRisksHasPrivilegedAccess;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterRisksHasAccessToSensitiveData(Boolean filterRisksHasAccessToSensitiveData) {
            this.filterRisksHasAccessToSensitiveData = filterRisksHasAccessToSensitiveData;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterEnvironments(String filterEnvironments) {
            this.filterEnvironments = filterEnvironments;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterTeams(String filterTeams) {
            this.filterTeams = filterTeams;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterArch(String filterArch) {
            this.filterArch = filterArch;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterOperatingSystemName(String filterOperatingSystemName) {
            this.filterOperatingSystemName = filterOperatingSystemName;
            return this;
        }

        public ListVulnerableAssetsOptionalParameters filterOperatingSystemVersion(String filterOperatingSystemVersion) {
            this.filterOperatingSystemVersion = filterOperatingSystemVersion;
            return this;
        }
    }

    public static class ListVulnerabilitiesOptionalParameters {
        private String pageToken;
        private Long pageNumber;
        private VulnerabilityType filterType;
        private Double filterCvssBaseScoreOp;
        private VulnerabilitySeverity filterCvssBaseSeverity;
        private String filterCvssBaseVector;
        private Double filterCvssDatadogScoreOp;
        private VulnerabilitySeverity filterCvssDatadogSeverity;
        private String filterCvssDatadogVector;
        private VulnerabilityStatus filterStatus;
        private VulnerabilityTool filterTool;
        private String filterLibraryName;
        private String filterLibraryVersion;
        private String filterAdvisoryId;
        private Boolean filterRisksExploitationProbability;
        private Boolean filterRisksPocExploitAvailable;
        private Boolean filterRisksExploitAvailable;
        private Double filterRisksEpssScoreOp;
        private VulnerabilitySeverity filterRisksEpssSeverity;
        private String filterLanguage;
        private VulnerabilityEcosystem filterEcosystem;
        private String filterCodeLocationLocation;
        private String filterCodeLocationFilePath;
        private String filterCodeLocationMethod;
        private Boolean filterFixAvailable;
        private String filterRepoDigests;
        private String filterOrigin;
        private String filterAssetName;
        private AssetType filterAssetType;
        private String filterAssetVersionFirst;
        private String filterAssetVersionLast;
        private String filterAssetRepositoryUrl;
        private Boolean filterAssetRisksInProduction;
        private Boolean filterAssetRisksUnderAttack;
        private Boolean filterAssetRisksIsPubliclyAccessible;
        private Boolean filterAssetRisksHasPrivilegedAccess;
        private Boolean filterAssetRisksHasAccessToSensitiveData;
        private String filterAssetEnvironments;
        private String filterAssetTeams;
        private String filterAssetArch;
        private String filterAssetOperatingSystemName;
        private String filterAssetOperatingSystemVersion;

        public ListVulnerabilitiesOptionalParameters pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterType(VulnerabilityType filterType) {
            this.filterType = filterType;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssBaseScoreOp(Double filterCvssBaseScoreOp) {
            this.filterCvssBaseScoreOp = filterCvssBaseScoreOp;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssBaseSeverity(VulnerabilitySeverity filterCvssBaseSeverity) {
            this.filterCvssBaseSeverity = filterCvssBaseSeverity;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssBaseVector(String filterCvssBaseVector) {
            this.filterCvssBaseVector = filterCvssBaseVector;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssDatadogScoreOp(Double filterCvssDatadogScoreOp) {
            this.filterCvssDatadogScoreOp = filterCvssDatadogScoreOp;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssDatadogSeverity(VulnerabilitySeverity filterCvssDatadogSeverity) {
            this.filterCvssDatadogSeverity = filterCvssDatadogSeverity;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCvssDatadogVector(String filterCvssDatadogVector) {
            this.filterCvssDatadogVector = filterCvssDatadogVector;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterStatus(VulnerabilityStatus filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterTool(VulnerabilityTool filterTool) {
            this.filterTool = filterTool;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterLibraryName(String filterLibraryName) {
            this.filterLibraryName = filterLibraryName;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterLibraryVersion(String filterLibraryVersion) {
            this.filterLibraryVersion = filterLibraryVersion;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAdvisoryId(String filterAdvisoryId) {
            this.filterAdvisoryId = filterAdvisoryId;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRisksExploitationProbability(Boolean filterRisksExploitationProbability) {
            this.filterRisksExploitationProbability = filterRisksExploitationProbability;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRisksPocExploitAvailable(Boolean filterRisksPocExploitAvailable) {
            this.filterRisksPocExploitAvailable = filterRisksPocExploitAvailable;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRisksExploitAvailable(Boolean filterRisksExploitAvailable) {
            this.filterRisksExploitAvailable = filterRisksExploitAvailable;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRisksEpssScoreOp(Double filterRisksEpssScoreOp) {
            this.filterRisksEpssScoreOp = filterRisksEpssScoreOp;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRisksEpssSeverity(VulnerabilitySeverity filterRisksEpssSeverity) {
            this.filterRisksEpssSeverity = filterRisksEpssSeverity;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterLanguage(String filterLanguage) {
            this.filterLanguage = filterLanguage;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterEcosystem(VulnerabilityEcosystem filterEcosystem) {
            this.filterEcosystem = filterEcosystem;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCodeLocationLocation(String filterCodeLocationLocation) {
            this.filterCodeLocationLocation = filterCodeLocationLocation;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCodeLocationFilePath(String filterCodeLocationFilePath) {
            this.filterCodeLocationFilePath = filterCodeLocationFilePath;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterCodeLocationMethod(String filterCodeLocationMethod) {
            this.filterCodeLocationMethod = filterCodeLocationMethod;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterFixAvailable(Boolean filterFixAvailable) {
            this.filterFixAvailable = filterFixAvailable;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterRepoDigests(String filterRepoDigests) {
            this.filterRepoDigests = filterRepoDigests;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterOrigin(String filterOrigin) {
            this.filterOrigin = filterOrigin;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetName(String filterAssetName) {
            this.filterAssetName = filterAssetName;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetType(AssetType filterAssetType) {
            this.filterAssetType = filterAssetType;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetVersionFirst(String filterAssetVersionFirst) {
            this.filterAssetVersionFirst = filterAssetVersionFirst;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetVersionLast(String filterAssetVersionLast) {
            this.filterAssetVersionLast = filterAssetVersionLast;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRepositoryUrl(String filterAssetRepositoryUrl) {
            this.filterAssetRepositoryUrl = filterAssetRepositoryUrl;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRisksInProduction(Boolean filterAssetRisksInProduction) {
            this.filterAssetRisksInProduction = filterAssetRisksInProduction;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRisksUnderAttack(Boolean filterAssetRisksUnderAttack) {
            this.filterAssetRisksUnderAttack = filterAssetRisksUnderAttack;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRisksIsPubliclyAccessible(Boolean filterAssetRisksIsPubliclyAccessible) {
            this.filterAssetRisksIsPubliclyAccessible = filterAssetRisksIsPubliclyAccessible;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRisksHasPrivilegedAccess(Boolean filterAssetRisksHasPrivilegedAccess) {
            this.filterAssetRisksHasPrivilegedAccess = filterAssetRisksHasPrivilegedAccess;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetRisksHasAccessToSensitiveData(Boolean filterAssetRisksHasAccessToSensitiveData) {
            this.filterAssetRisksHasAccessToSensitiveData = filterAssetRisksHasAccessToSensitiveData;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetEnvironments(String filterAssetEnvironments) {
            this.filterAssetEnvironments = filterAssetEnvironments;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetTeams(String filterAssetTeams) {
            this.filterAssetTeams = filterAssetTeams;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetArch(String filterAssetArch) {
            this.filterAssetArch = filterAssetArch;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetOperatingSystemName(String filterAssetOperatingSystemName) {
            this.filterAssetOperatingSystemName = filterAssetOperatingSystemName;
            return this;
        }

        public ListVulnerabilitiesOptionalParameters filterAssetOperatingSystemVersion(String filterAssetOperatingSystemVersion) {
            this.filterAssetOperatingSystemVersion = filterAssetOperatingSystemVersion;
            return this;
        }
    }

    public static class ListThreatHuntingJobsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private String sort;
        private String filterQuery;

        public ListThreatHuntingJobsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListThreatHuntingJobsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListThreatHuntingJobsOptionalParameters sort(String sort) {
            this.sort = sort;
            return this;
        }

        public ListThreatHuntingJobsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }
    }

    public static class ListSecurityMonitoringSuppressionsOptionalParameters {
        private String query;

        public ListSecurityMonitoringSuppressionsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }
    }

    public static class ListSecurityMonitoringSignalsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSecurityMonitoringSignalsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSecurityMonitoringSignalsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListSecurityMonitoringRulesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public ListSecurityMonitoringRulesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListSecurityMonitoringRulesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }

    public static class ListSecurityMonitoringHistsignalsOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public ListSecurityMonitoringHistsignalsOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public ListSecurityMonitoringHistsignalsOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public ListSecurityMonitoringHistsignalsOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public ListSecurityMonitoringHistsignalsOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListSecurityMonitoringHistsignalsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListSecurityMonitoringHistsignalsOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class ListScannedAssetsMetadataOptionalParameters {
        private String pageToken;
        private Long pageNumber;
        private CloudAssetType filterAssetType;
        private String filterAssetName;
        private String filterLastSuccessOrigin;
        private String filterLastSuccessEnv;

        public ListScannedAssetsMetadataOptionalParameters pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public ListScannedAssetsMetadataOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListScannedAssetsMetadataOptionalParameters filterAssetType(CloudAssetType filterAssetType) {
            this.filterAssetType = filterAssetType;
            return this;
        }

        public ListScannedAssetsMetadataOptionalParameters filterAssetName(String filterAssetName) {
            this.filterAssetName = filterAssetName;
            return this;
        }

        public ListScannedAssetsMetadataOptionalParameters filterLastSuccessOrigin(String filterLastSuccessOrigin) {
            this.filterLastSuccessOrigin = filterLastSuccessOrigin;
            return this;
        }

        public ListScannedAssetsMetadataOptionalParameters filterLastSuccessEnv(String filterLastSuccessEnv) {
            this.filterLastSuccessEnv = filterLastSuccessEnv;
            return this;
        }
    }

    public static class ListFindingsOptionalParameters {
        private Long pageLimit;
        private Long snapshotTimestamp;
        private String pageCursor;
        private String filterTags;
        private String filterEvaluationChangedAt;
        private Boolean filterMuted;
        private String filterRuleId;
        private String filterRuleName;
        private String filterResourceType;
        private String filterResourceId;
        private String filterDiscoveryTimestamp;
        private FindingEvaluation filterEvaluation;
        private FindingStatus filterStatus;
        private List<FindingVulnerabilityType> filterVulnerabilityType;
        private Boolean detailedFindings;

        public ListFindingsOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListFindingsOptionalParameters snapshotTimestamp(Long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }

        public ListFindingsOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public ListFindingsOptionalParameters filterTags(String filterTags) {
            this.filterTags = filterTags;
            return this;
        }

        public ListFindingsOptionalParameters filterEvaluationChangedAt(String filterEvaluationChangedAt) {
            this.filterEvaluationChangedAt = filterEvaluationChangedAt;
            return this;
        }

        public ListFindingsOptionalParameters filterMuted(Boolean filterMuted) {
            this.filterMuted = filterMuted;
            return this;
        }

        public ListFindingsOptionalParameters filterRuleId(String filterRuleId) {
            this.filterRuleId = filterRuleId;
            return this;
        }

        public ListFindingsOptionalParameters filterRuleName(String filterRuleName) {
            this.filterRuleName = filterRuleName;
            return this;
        }

        public ListFindingsOptionalParameters filterResourceType(String filterResourceType) {
            this.filterResourceType = filterResourceType;
            return this;
        }

        public ListFindingsOptionalParameters filterResourceId(String filterResourceId) {
            this.filterResourceId = filterResourceId;
            return this;
        }

        public ListFindingsOptionalParameters filterDiscoveryTimestamp(String filterDiscoveryTimestamp) {
            this.filterDiscoveryTimestamp = filterDiscoveryTimestamp;
            return this;
        }

        public ListFindingsOptionalParameters filterEvaluation(FindingEvaluation filterEvaluation) {
            this.filterEvaluation = filterEvaluation;
            return this;
        }

        public ListFindingsOptionalParameters filterStatus(FindingStatus filterStatus) {
            this.filterStatus = filterStatus;
            return this;
        }

        public ListFindingsOptionalParameters filterVulnerabilityType(List<FindingVulnerabilityType> filterVulnerabilityType) {
            this.filterVulnerabilityType = filterVulnerabilityType;
            return this;
        }

        public ListFindingsOptionalParameters detailedFindings(Boolean detailedFindings) {
            this.detailedFindings = detailedFindings;
            return this;
        }
    }

    public static class ListAssetsSBOMsOptionalParameters {
        private String pageToken;
        private Long pageNumber;
        private AssetType filterAssetType;
        private String filterAssetName;
        private String filterPackageName;
        private String filterPackageVersion;
        private String filterLicenseName;
        private SBOMComponentLicenseType filterLicenseType;

        public ListAssetsSBOMsOptionalParameters pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterAssetType(AssetType filterAssetType) {
            this.filterAssetType = filterAssetType;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterAssetName(String filterAssetName) {
            this.filterAssetName = filterAssetName;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterPackageName(String filterPackageName) {
            this.filterPackageName = filterPackageName;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterPackageVersion(String filterPackageVersion) {
            this.filterPackageVersion = filterPackageVersion;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterLicenseName(String filterLicenseName) {
            this.filterLicenseName = filterLicenseName;
            return this;
        }

        public ListAssetsSBOMsOptionalParameters filterLicenseType(SBOMComponentLicenseType filterLicenseType) {
            this.filterLicenseType = filterLicenseType;
            return this;
        }
    }

    public static class GetSecurityMonitoringHistsignalsByJobIdOptionalParameters {
        private String filterQuery;
        private OffsetDateTime filterFrom;
        private OffsetDateTime filterTo;
        private SecurityMonitoringSignalsSort sort;
        private String pageCursor;
        private Integer pageLimit;

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters filterFrom(OffsetDateTime filterFrom) {
            this.filterFrom = filterFrom;
            return this;
        }

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters filterTo(OffsetDateTime filterTo) {
            this.filterTo = filterTo;
            return this;
        }

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters sort(SecurityMonitoringSignalsSort sort) {
            this.sort = sort;
            return this;
        }

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters pageCursor(String pageCursor) {
            this.pageCursor = pageCursor;
            return this;
        }

        public GetSecurityMonitoringHistsignalsByJobIdOptionalParameters pageLimit(Integer pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }
    }

    public static class GetSBOMOptionalParameters {
        private String filterRepoDigest;
        private SBOMFormat extFormat;

        public GetSBOMOptionalParameters filterRepoDigest(String filterRepoDigest) {
            this.filterRepoDigest = filterRepoDigest;
            return this;
        }

        public GetSBOMOptionalParameters extFormat(SBOMFormat extFormat) {
            this.extFormat = extFormat;
            return this;
        }
    }

    public static class GetRuleVersionHistoryOptionalParameters {
        private Long pageSize;
        private Long pageNumber;

        public GetRuleVersionHistoryOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public GetRuleVersionHistoryOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }

    public static class GetResourceEvaluationFiltersOptionalParameters {
        private String cloudProvider;
        private String accountId;
        private Boolean skipCache;

        public GetResourceEvaluationFiltersOptionalParameters cloudProvider(String cloudProvider) {
            this.cloudProvider = cloudProvider;
            return this;
        }

        public GetResourceEvaluationFiltersOptionalParameters accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public GetResourceEvaluationFiltersOptionalParameters skipCache(Boolean skipCache) {
            this.skipCache = skipCache;
            return this;
        }
    }

    public static class GetFindingOptionalParameters {
        private Long snapshotTimestamp;

        public GetFindingOptionalParameters snapshotTimestamp(Long snapshotTimestamp) {
            this.snapshotTimestamp = snapshotTimestamp;
            return this;
        }
    }
}

