/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetScheduleRecurrenceRule;
import com.datadog.api.client.v2.model.FleetScheduleStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "query", "rule", "status", "version_to_latest"})
public class FleetSchedulePatchAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RULE = "rule";
    private FleetScheduleRecurrenceRule rule;
    public static final String JSON_PROPERTY_STATUS = "status";
    private FleetScheduleStatus status;
    public static final String JSON_PROPERTY_VERSION_TO_LATEST = "version_to_latest";
    private Long versionToLatest;
    private Map<String, Object> additionalProperties;

    public FleetSchedulePatchAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FleetSchedulePatchAttributes query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public FleetSchedulePatchAttributes rule(FleetScheduleRecurrenceRule rule) {
        this.rule = rule;
        this.unparsed |= rule.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetScheduleRecurrenceRule getRule() {
        return this.rule;
    }

    public void setRule(FleetScheduleRecurrenceRule rule) {
        this.rule = rule;
    }

    public FleetSchedulePatchAttributes status(FleetScheduleStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetScheduleStatus getStatus() {
        return this.status;
    }

    public void setStatus(FleetScheduleStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public FleetSchedulePatchAttributes versionToLatest(Long versionToLatest) {
        this.versionToLatest = versionToLatest;
        return this;
    }

    @Nullable
    @JsonProperty(value="version_to_latest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersionToLatest() {
        return this.versionToLatest;
    }

    public void setVersionToLatest(Long versionToLatest) {
        this.versionToLatest = versionToLatest;
    }

    @JsonAnySetter
    public FleetSchedulePatchAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetSchedulePatchAttributes fleetSchedulePatchAttributes = (FleetSchedulePatchAttributes)o;
        return Objects.equals(this.name, fleetSchedulePatchAttributes.name) && Objects.equals(this.query, fleetSchedulePatchAttributes.query) && Objects.equals(this.rule, fleetSchedulePatchAttributes.rule) && Objects.equals(this.status, fleetSchedulePatchAttributes.status) && Objects.equals(this.versionToLatest, fleetSchedulePatchAttributes.versionToLatest) && Objects.equals(this.additionalProperties, fleetSchedulePatchAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query, this.rule, this.status, this.versionToLatest, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetSchedulePatchAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    versionToLatest: ").append(this.toIndentedString(this.versionToLatest)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

