/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetScheduleRecurrenceRule;
import com.datadog.api.client.v2.model.FleetScheduleStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"name", "query", "rule", "status", "version_to_latest"})
public class FleetScheduleCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RULE = "rule";
    private FleetScheduleRecurrenceRule rule;
    public static final String JSON_PROPERTY_STATUS = "status";
    private FleetScheduleStatus status;
    public static final String JSON_PROPERTY_VERSION_TO_LATEST = "version_to_latest";
    private Long versionToLatest;
    private Map<String, Object> additionalProperties;

    public FleetScheduleCreateAttributes() {
    }

    @JsonCreator
    public FleetScheduleCreateAttributes(@JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="query") String query, @JsonProperty(required=true, value="rule") FleetScheduleRecurrenceRule rule) {
        this.name = name;
        this.query = query;
        this.rule = rule;
        this.unparsed |= rule.unparsed;
    }

    public FleetScheduleCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FleetScheduleCreateAttributes query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public FleetScheduleCreateAttributes rule(FleetScheduleRecurrenceRule rule) {
        this.rule = rule;
        this.unparsed |= rule.unparsed;
        return this;
    }

    @JsonProperty(value="rule")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public FleetScheduleRecurrenceRule getRule() {
        return this.rule;
    }

    public void setRule(FleetScheduleRecurrenceRule rule) {
        this.rule = rule;
    }

    public FleetScheduleCreateAttributes status(FleetScheduleStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetScheduleStatus getStatus() {
        return this.status;
    }

    public void setStatus(FleetScheduleStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public FleetScheduleCreateAttributes versionToLatest(Long versionToLatest) {
        this.versionToLatest = versionToLatest;
        return this;
    }

    @Nullable
    @JsonProperty(value="version_to_latest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersionToLatest() {
        return this.versionToLatest;
    }

    public void setVersionToLatest(Long versionToLatest) {
        this.versionToLatest = versionToLatest;
    }

    @JsonAnySetter
    public FleetScheduleCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetScheduleCreateAttributes fleetScheduleCreateAttributes = (FleetScheduleCreateAttributes)o;
        return Objects.equals(this.name, fleetScheduleCreateAttributes.name) && Objects.equals(this.query, fleetScheduleCreateAttributes.query) && Objects.equals(this.rule, fleetScheduleCreateAttributes.rule) && Objects.equals(this.status, fleetScheduleCreateAttributes.status) && Objects.equals(this.versionToLatest, fleetScheduleCreateAttributes.versionToLatest) && Objects.equals(this.additionalProperties, fleetScheduleCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.query, this.rule, this.status, this.versionToLatest, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetScheduleCreateAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    versionToLatest: ").append(this.toIndentedString(this.versionToLatest)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

