/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.MonitorNotificationRuleCondition;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"conditions", "fallback_recipients"})
public class MonitorNotificationRuleConditionalRecipients {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<MonitorNotificationRuleCondition> conditions = new ArrayList<MonitorNotificationRuleCondition>();
    public static final String JSON_PROPERTY_FALLBACK_RECIPIENTS = "fallback_recipients";
    private List<String> fallbackRecipients = null;
    private Map<String, Object> additionalProperties;

    public MonitorNotificationRuleConditionalRecipients() {
    }

    @JsonCreator
    public MonitorNotificationRuleConditionalRecipients(@JsonProperty(required=true, value="conditions") List<MonitorNotificationRuleCondition> conditions) {
        this.conditions = conditions;
    }

    public MonitorNotificationRuleConditionalRecipients conditions(List<MonitorNotificationRuleCondition> conditions) {
        this.conditions = conditions;
        for (MonitorNotificationRuleCondition item : conditions) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MonitorNotificationRuleConditionalRecipients addConditionsItem(MonitorNotificationRuleCondition conditionsItem) {
        this.conditions.add(conditionsItem);
        this.unparsed |= conditionsItem.unparsed;
        return this;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<MonitorNotificationRuleCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<MonitorNotificationRuleCondition> conditions) {
        this.conditions = conditions;
    }

    public MonitorNotificationRuleConditionalRecipients fallbackRecipients(List<String> fallbackRecipients) {
        this.fallbackRecipients = fallbackRecipients;
        return this;
    }

    public MonitorNotificationRuleConditionalRecipients addFallbackRecipientsItem(String fallbackRecipientsItem) {
        if (this.fallbackRecipients == null) {
            this.fallbackRecipients = new ArrayList<String>();
        }
        this.fallbackRecipients.add(fallbackRecipientsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="fallback_recipients")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFallbackRecipients() {
        return this.fallbackRecipients;
    }

    public void setFallbackRecipients(List<String> fallbackRecipients) {
        this.fallbackRecipients = fallbackRecipients;
    }

    @JsonAnySetter
    public MonitorNotificationRuleConditionalRecipients putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorNotificationRuleConditionalRecipients monitorNotificationRuleConditionalRecipients = (MonitorNotificationRuleConditionalRecipients)o;
        return Objects.equals(this.conditions, monitorNotificationRuleConditionalRecipients.conditions) && Objects.equals(this.fallbackRecipients, monitorNotificationRuleConditionalRecipients.fallbackRecipients) && Objects.equals(this.additionalProperties, monitorNotificationRuleConditionalRecipients.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.fallbackRecipients, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorNotificationRuleConditionalRecipients {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    fallbackRecipients: ").append(this.toIndentedString(this.fallbackRecipients)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

