/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsMobileStep;
import com.datadog.api.client.v1.model.SyntheticsMobileTestConfig;
import com.datadog.api.client.v1.model.SyntheticsMobileTestOptions;
import com.datadog.api.client.v1.model.SyntheticsMobileTestType;
import com.datadog.api.client.v1.model.SyntheticsTestPauseStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"config", "device_ids", "message", "monitor_id", "name", "options", "public_id", "status", "steps", "tags", "type"})
public class SyntheticsMobileTest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private SyntheticsMobileTestConfig config;
    public static final String JSON_PROPERTY_DEVICE_IDS = "device_ids";
    private List<String> deviceIds = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MONITOR_ID = "monitor_id";
    private Long monitorId;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private SyntheticsMobileTestOptions options;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsTestPauseStatus status;
    public static final String JSON_PROPERTY_STEPS = "steps";
    private List<SyntheticsMobileStep> steps = null;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsMobileTestType type = SyntheticsMobileTestType.MOBILE;
    private Map<String, Object> additionalProperties;

    public SyntheticsMobileTest() {
    }

    @JsonCreator
    public SyntheticsMobileTest(@JsonProperty(required=true, value="config") SyntheticsMobileTestConfig config, @JsonProperty(required=true, value="message") String message, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="options") SyntheticsMobileTestOptions options, @JsonProperty(required=true, value="type") SyntheticsMobileTestType type) {
        this.config = config;
        this.unparsed |= config.unparsed;
        this.message = message;
        this.name = name;
        this.options = options;
        this.unparsed |= options.unparsed;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SyntheticsMobileTest config(SyntheticsMobileTestConfig config) {
        this.config = config;
        this.unparsed |= config.unparsed;
        return this;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsMobileTestConfig getConfig() {
        return this.config;
    }

    public void setConfig(SyntheticsMobileTestConfig config) {
        this.config = config;
    }

    public SyntheticsMobileTest deviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
        return this;
    }

    public SyntheticsMobileTest addDeviceIdsItem(String deviceIdsItem) {
        if (this.deviceIds == null) {
            this.deviceIds = new ArrayList<String>();
        }
        this.deviceIds.add(deviceIdsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="device_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getDeviceIds() {
        return this.deviceIds;
    }

    public void setDeviceIds(List<String> deviceIds) {
        this.deviceIds = deviceIds;
    }

    public SyntheticsMobileTest message(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @JsonProperty(value="monitor_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getMonitorId() {
        return this.monitorId;
    }

    public SyntheticsMobileTest name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SyntheticsMobileTest options(SyntheticsMobileTestOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsMobileTestOptions getOptions() {
        return this.options;
    }

    public void setOptions(SyntheticsMobileTestOptions options) {
        this.options = options;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public SyntheticsMobileTest status(SyntheticsTestPauseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestPauseStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsTestPauseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SyntheticsMobileTest steps(List<SyntheticsMobileStep> steps) {
        this.steps = steps;
        for (SyntheticsMobileStep item : steps) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SyntheticsMobileTest addStepsItem(SyntheticsMobileStep stepsItem) {
        if (this.steps == null) {
            this.steps = new ArrayList<SyntheticsMobileStep>();
        }
        this.steps.add(stepsItem);
        this.unparsed |= stepsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="steps")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SyntheticsMobileStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<SyntheticsMobileStep> steps) {
        this.steps = steps;
    }

    public SyntheticsMobileTest tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SyntheticsMobileTest addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public SyntheticsMobileTest type(SyntheticsMobileTestType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsMobileTestType getType() {
        return this.type;
    }

    public void setType(SyntheticsMobileTestType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public SyntheticsMobileTest putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsMobileTest syntheticsMobileTest = (SyntheticsMobileTest)o;
        return Objects.equals(this.config, syntheticsMobileTest.config) && Objects.equals(this.deviceIds, syntheticsMobileTest.deviceIds) && Objects.equals(this.message, syntheticsMobileTest.message) && Objects.equals(this.monitorId, syntheticsMobileTest.monitorId) && Objects.equals(this.name, syntheticsMobileTest.name) && Objects.equals(this.options, syntheticsMobileTest.options) && Objects.equals(this.publicId, syntheticsMobileTest.publicId) && Objects.equals(this.status, syntheticsMobileTest.status) && Objects.equals(this.steps, syntheticsMobileTest.steps) && Objects.equals(this.tags, syntheticsMobileTest.tags) && Objects.equals(this.type, syntheticsMobileTest.type) && Objects.equals(this.additionalProperties, syntheticsMobileTest.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.deviceIds, this.message, this.monitorId, this.name, this.options, this.publicId, this.status, this.steps, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsMobileTest {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    monitorId: ").append(this.toIndentedString(this.monitorId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

