/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.GCPMonitoredResourceConfig;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"auth_provider_x509_cert_url", "auth_uri", "automute", "client_email", "client_id", "client_x509_cert_url", "cloud_run_revision_filters", "errors", "host_filters", "is_cspm_enabled", "is_resource_change_collection_enabled", "is_security_command_center_enabled", "monitored_resource_configs", "private_key", "private_key_id", "project_id", "resource_collection_enabled", "token_uri", "type"})
public class GCPAccount {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTH_PROVIDER_X509_CERT_URL = "auth_provider_x509_cert_url";
    private String authProviderX509CertUrl;
    public static final String JSON_PROPERTY_AUTH_URI = "auth_uri";
    private String authUri;
    public static final String JSON_PROPERTY_AUTOMUTE = "automute";
    private Boolean automute;
    public static final String JSON_PROPERTY_CLIENT_EMAIL = "client_email";
    private String clientEmail;
    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_X509_CERT_URL = "client_x509_cert_url";
    private String clientX509CertUrl;
    public static final String JSON_PROPERTY_CLOUD_RUN_REVISION_FILTERS = "cloud_run_revision_filters";
    private List<String> cloudRunRevisionFilters = null;
    public static final String JSON_PROPERTY_ERRORS = "errors";
    private List<String> errors = null;
    public static final String JSON_PROPERTY_HOST_FILTERS = "host_filters";
    private String hostFilters;
    public static final String JSON_PROPERTY_IS_CSPM_ENABLED = "is_cspm_enabled";
    private Boolean isCspmEnabled;
    public static final String JSON_PROPERTY_IS_RESOURCE_CHANGE_COLLECTION_ENABLED = "is_resource_change_collection_enabled";
    private Boolean isResourceChangeCollectionEnabled = false;
    public static final String JSON_PROPERTY_IS_SECURITY_COMMAND_CENTER_ENABLED = "is_security_command_center_enabled";
    private Boolean isSecurityCommandCenterEnabled = false;
    public static final String JSON_PROPERTY_MONITORED_RESOURCE_CONFIGS = "monitored_resource_configs";
    private List<GCPMonitoredResourceConfig> monitoredResourceConfigs = null;
    public static final String JSON_PROPERTY_PRIVATE_KEY = "private_key";
    private String privateKey;
    public static final String JSON_PROPERTY_PRIVATE_KEY_ID = "private_key_id";
    private String privateKeyId;
    public static final String JSON_PROPERTY_PROJECT_ID = "project_id";
    private String projectId;
    public static final String JSON_PROPERTY_RESOURCE_COLLECTION_ENABLED = "resource_collection_enabled";
    private Boolean resourceCollectionEnabled;
    public static final String JSON_PROPERTY_TOKEN_URI = "token_uri";
    private String tokenUri;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    private Map<String, Object> additionalProperties;

    public GCPAccount authProviderX509CertUrl(String authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth_provider_x509_cert_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthProviderX509CertUrl() {
        return this.authProviderX509CertUrl;
    }

    public void setAuthProviderX509CertUrl(String authProviderX509CertUrl) {
        this.authProviderX509CertUrl = authProviderX509CertUrl;
    }

    public GCPAccount authUri(String authUri) {
        this.authUri = authUri;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthUri() {
        return this.authUri;
    }

    public void setAuthUri(String authUri) {
        this.authUri = authUri;
    }

    public GCPAccount automute(Boolean automute) {
        this.automute = automute;
        return this;
    }

    @Nullable
    @JsonProperty(value="automute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAutomute() {
        return this.automute;
    }

    public void setAutomute(Boolean automute) {
        this.automute = automute;
    }

    public GCPAccount clientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientEmail() {
        return this.clientEmail;
    }

    public void setClientEmail(String clientEmail) {
        this.clientEmail = clientEmail;
    }

    public GCPAccount clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GCPAccount clientX509CertUrl(String clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_x509_cert_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientX509CertUrl() {
        return this.clientX509CertUrl;
    }

    public void setClientX509CertUrl(String clientX509CertUrl) {
        this.clientX509CertUrl = clientX509CertUrl;
    }

    public GCPAccount cloudRunRevisionFilters(List<String> cloudRunRevisionFilters) {
        this.cloudRunRevisionFilters = cloudRunRevisionFilters;
        return this;
    }

    public GCPAccount addCloudRunRevisionFiltersItem(String cloudRunRevisionFiltersItem) {
        if (this.cloudRunRevisionFilters == null) {
            this.cloudRunRevisionFilters = new ArrayList<String>();
        }
        this.cloudRunRevisionFilters.add(cloudRunRevisionFiltersItem);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="cloud_run_revision_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCloudRunRevisionFilters() {
        return this.cloudRunRevisionFilters;
    }

    @Deprecated
    public void setCloudRunRevisionFilters(List<String> cloudRunRevisionFilters) {
        this.cloudRunRevisionFilters = cloudRunRevisionFilters;
    }

    public GCPAccount errors(List<String> errors) {
        this.errors = errors;
        return this;
    }

    public GCPAccount addErrorsItem(String errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="errors")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public GCPAccount hostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="host_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHostFilters() {
        return this.hostFilters;
    }

    @Deprecated
    public void setHostFilters(String hostFilters) {
        this.hostFilters = hostFilters;
    }

    public GCPAccount isCspmEnabled(Boolean isCspmEnabled) {
        this.isCspmEnabled = isCspmEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_cspm_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsCspmEnabled() {
        return this.isCspmEnabled;
    }

    public void setIsCspmEnabled(Boolean isCspmEnabled) {
        this.isCspmEnabled = isCspmEnabled;
    }

    public GCPAccount isResourceChangeCollectionEnabled(Boolean isResourceChangeCollectionEnabled) {
        this.isResourceChangeCollectionEnabled = isResourceChangeCollectionEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_resource_change_collection_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsResourceChangeCollectionEnabled() {
        return this.isResourceChangeCollectionEnabled;
    }

    public void setIsResourceChangeCollectionEnabled(Boolean isResourceChangeCollectionEnabled) {
        this.isResourceChangeCollectionEnabled = isResourceChangeCollectionEnabled;
    }

    public GCPAccount isSecurityCommandCenterEnabled(Boolean isSecurityCommandCenterEnabled) {
        this.isSecurityCommandCenterEnabled = isSecurityCommandCenterEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_security_command_center_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsSecurityCommandCenterEnabled() {
        return this.isSecurityCommandCenterEnabled;
    }

    public void setIsSecurityCommandCenterEnabled(Boolean isSecurityCommandCenterEnabled) {
        this.isSecurityCommandCenterEnabled = isSecurityCommandCenterEnabled;
    }

    public GCPAccount monitoredResourceConfigs(List<GCPMonitoredResourceConfig> monitoredResourceConfigs) {
        this.monitoredResourceConfigs = monitoredResourceConfigs;
        for (GCPMonitoredResourceConfig item : monitoredResourceConfigs) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public GCPAccount addMonitoredResourceConfigsItem(GCPMonitoredResourceConfig monitoredResourceConfigsItem) {
        if (this.monitoredResourceConfigs == null) {
            this.monitoredResourceConfigs = new ArrayList<GCPMonitoredResourceConfig>();
        }
        this.monitoredResourceConfigs.add(monitoredResourceConfigsItem);
        this.unparsed |= monitoredResourceConfigsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="monitored_resource_configs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GCPMonitoredResourceConfig> getMonitoredResourceConfigs() {
        return this.monitoredResourceConfigs;
    }

    public void setMonitoredResourceConfigs(List<GCPMonitoredResourceConfig> monitoredResourceConfigs) {
        this.monitoredResourceConfigs = monitoredResourceConfigs;
    }

    public GCPAccount privateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="private_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public GCPAccount privateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
        return this;
    }

    @Nullable
    @JsonProperty(value="private_key_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public void setPrivateKeyId(String privateKeyId) {
        this.privateKeyId = privateKeyId;
    }

    public GCPAccount projectId(String projectId) {
        this.projectId = projectId;
        return this;
    }

    @Nullable
    @JsonProperty(value="project_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public GCPAccount resourceCollectionEnabled(Boolean resourceCollectionEnabled) {
        this.resourceCollectionEnabled = resourceCollectionEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="resource_collection_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getResourceCollectionEnabled() {
        return this.resourceCollectionEnabled;
    }

    public void setResourceCollectionEnabled(Boolean resourceCollectionEnabled) {
        this.resourceCollectionEnabled = resourceCollectionEnabled;
    }

    public GCPAccount tokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
        return this;
    }

    @Nullable
    @JsonProperty(value="token_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenUri() {
        return this.tokenUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public GCPAccount type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonAnySetter
    public GCPAccount putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCPAccount gcpAccount = (GCPAccount)o;
        return Objects.equals(this.authProviderX509CertUrl, gcpAccount.authProviderX509CertUrl) && Objects.equals(this.authUri, gcpAccount.authUri) && Objects.equals(this.automute, gcpAccount.automute) && Objects.equals(this.clientEmail, gcpAccount.clientEmail) && Objects.equals(this.clientId, gcpAccount.clientId) && Objects.equals(this.clientX509CertUrl, gcpAccount.clientX509CertUrl) && Objects.equals(this.cloudRunRevisionFilters, gcpAccount.cloudRunRevisionFilters) && Objects.equals(this.errors, gcpAccount.errors) && Objects.equals(this.hostFilters, gcpAccount.hostFilters) && Objects.equals(this.isCspmEnabled, gcpAccount.isCspmEnabled) && Objects.equals(this.isResourceChangeCollectionEnabled, gcpAccount.isResourceChangeCollectionEnabled) && Objects.equals(this.isSecurityCommandCenterEnabled, gcpAccount.isSecurityCommandCenterEnabled) && Objects.equals(this.monitoredResourceConfigs, gcpAccount.monitoredResourceConfigs) && Objects.equals(this.privateKey, gcpAccount.privateKey) && Objects.equals(this.privateKeyId, gcpAccount.privateKeyId) && Objects.equals(this.projectId, gcpAccount.projectId) && Objects.equals(this.resourceCollectionEnabled, gcpAccount.resourceCollectionEnabled) && Objects.equals(this.tokenUri, gcpAccount.tokenUri) && Objects.equals(this.type, gcpAccount.type) && Objects.equals(this.additionalProperties, gcpAccount.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.authProviderX509CertUrl, this.authUri, this.automute, this.clientEmail, this.clientId, this.clientX509CertUrl, this.cloudRunRevisionFilters, this.errors, this.hostFilters, this.isCspmEnabled, this.isResourceChangeCollectionEnabled, this.isSecurityCommandCenterEnabled, this.monitoredResourceConfigs, this.privateKey, this.privateKeyId, this.projectId, this.resourceCollectionEnabled, this.tokenUri, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GCPAccount {\n");
        sb.append("    authProviderX509CertUrl: ").append(this.toIndentedString(this.authProviderX509CertUrl)).append("\n");
        sb.append("    authUri: ").append(this.toIndentedString(this.authUri)).append("\n");
        sb.append("    automute: ").append(this.toIndentedString(this.automute)).append("\n");
        sb.append("    clientEmail: ").append(this.toIndentedString(this.clientEmail)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientX509CertUrl: ").append(this.toIndentedString(this.clientX509CertUrl)).append("\n");
        sb.append("    cloudRunRevisionFilters: ").append(this.toIndentedString(this.cloudRunRevisionFilters)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("    hostFilters: ").append(this.toIndentedString(this.hostFilters)).append("\n");
        sb.append("    isCspmEnabled: ").append(this.toIndentedString(this.isCspmEnabled)).append("\n");
        sb.append("    isResourceChangeCollectionEnabled: ").append(this.toIndentedString(this.isResourceChangeCollectionEnabled)).append("\n");
        sb.append("    isSecurityCommandCenterEnabled: ").append(this.toIndentedString(this.isSecurityCommandCenterEnabled)).append("\n");
        sb.append("    monitoredResourceConfigs: ").append(this.toIndentedString(this.monitoredResourceConfigs)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("    privateKeyId: ").append(this.toIndentedString(this.privateKeyId)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    resourceCollectionEnabled: ").append(this.toIndentedString(this.resourceCollectionEnabled)).append("\n");
        sb.append("    tokenUri: ").append(this.toIndentedString(this.tokenUri)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

