/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.org.apache.http.client.protocol;

import com.datadoghq.org.apache.http.HttpEntity;
import com.datadoghq.org.apache.http.HttpEntityEnclosingRequest;
import com.datadoghq.org.apache.http.HttpException;
import com.datadoghq.org.apache.http.HttpRequest;
import com.datadoghq.org.apache.http.HttpRequestInterceptor;
import com.datadoghq.org.apache.http.HttpVersion;
import com.datadoghq.org.apache.http.ProtocolVersion;
import com.datadoghq.org.apache.http.annotation.Contract;
import com.datadoghq.org.apache.http.annotation.ThreadingBehavior;
import com.datadoghq.org.apache.http.client.config.RequestConfig;
import com.datadoghq.org.apache.http.client.protocol.HttpClientContext;
import com.datadoghq.org.apache.http.protocol.HttpContext;
import com.datadoghq.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

