/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.oauth2.clientauthentication;

import com.datadoghq.com.github.scribejava.core.base64.Base64;
import com.datadoghq.com.github.scribejava.core.model.OAuthRequest;
import com.datadoghq.com.github.scribejava.core.oauth2.clientauthentication.ClientAuthentication;
import java.nio.charset.Charset;

public class HttpBasicAuthenticationScheme
implements ClientAuthentication {
    protected HttpBasicAuthenticationScheme() {
    }

    public static HttpBasicAuthenticationScheme instance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public void addClientAuthentication(OAuthRequest request, String apiKey, String apiSecret) {
        if (apiKey != null && apiSecret != null) {
            request.addHeader("Authorization", "Basic " + Base64.encode(String.format("%s:%s", apiKey, apiSecret).getBytes(Charset.forName("UTF-8"))));
        }
    }

    private static class InstanceHolder {
        private static final HttpBasicAuthenticationScheme INSTANCE = new HttpBasicAuthenticationScheme();

        private InstanceHolder() {
        }
    }
}

