/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.model;

import com.datadoghq.com.github.scribejava.core.utils.OAuthEncoder;

public class Parameter
implements Comparable<Parameter> {
    private final String key;
    private final String value;

    public Parameter(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String asUrlEncodedPair() {
        return OAuthEncoder.encode(this.key).concat("=").concat(OAuthEncoder.encode(this.value));
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Parameter)) {
            return false;
        }
        Parameter otherParam = (Parameter)other;
        return otherParam.getKey().equals(this.key) && otherParam.getValue().equals(this.value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.key.hashCode() + this.value.hashCode();
    }

    @Override
    public int compareTo(Parameter parameter) {
        int keyDiff = this.key.compareTo(parameter.getKey());
        return keyDiff == 0 ? this.value.compareTo(parameter.getValue()) : keyDiff;
    }
}

