/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.com.github.scribejava.core.base64;

import com.datadoghq.com.github.scribejava.core.base64.CommonsCodecBase64;
import com.datadoghq.com.github.scribejava.core.base64.Java8Base64;
import com.datadoghq.com.github.scribejava.core.base64.Jaxb230Base64;
import com.datadoghq.com.github.scribejava.core.base64.JaxbBase64;

public abstract class Base64 {
    private static volatile Base64 instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Base64 getInstance() {
        Base64 localInstance = instance;
        if (localInstance != null) return localInstance;
        Class<Base64> clazz = Base64.class;
        synchronized (Base64.class) {
            localInstance = instance;
            if (localInstance != null) return localInstance;
            instance = localInstance = Base64.createInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localInstance;
        }
    }

    private static Base64 createInstance() {
        if (Java8Base64.isAvailable()) {
            return new Java8Base64();
        }
        if (Jaxb230Base64.isAvailable()) {
            return new Jaxb230Base64();
        }
        if (JaxbBase64.isAvailable()) {
            return new JaxbBase64();
        }
        if (CommonsCodecBase64.isAvailable()) {
            return new CommonsCodecBase64();
        }
        throw new IllegalStateException("No Base64 implementation was provided. Java 8 Base64, Apache Commons Codec or JAXB is needed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Base64 base64) {
        Class<Base64> clazz = Base64.class;
        synchronized (Base64.class) {
            instance = base64;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String encode(byte[] bytes) {
        return Base64.getInstance().internalEncode(bytes);
    }

    public static String encodeUrlWithoutPadding(byte[] bytes) {
        return Base64.getInstance().internalEncodeUrlWithoutPadding(bytes);
    }

    protected abstract String internalEncode(byte[] var1);

    protected abstract String internalEncodeUrlWithoutPadding(byte[] var1);
}

