/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.RumMetricCompute;
import com.datadog.api.client.v2.model.RumMetricEventType;
import com.datadog.api.client.v2.model.RumMetricFilter;
import com.datadog.api.client.v2.model.RumMetricGroupBy;
import com.datadog.api.client.v2.model.RumMetricUniqueness;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"compute", "event_type", "filter", "group_by", "uniqueness"})
public class RumMetricCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_COMPUTE = "compute";
    private RumMetricCompute compute;
    public static final String JSON_PROPERTY_EVENT_TYPE = "event_type";
    private RumMetricEventType eventType;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private RumMetricFilter filter;
    public static final String JSON_PROPERTY_GROUP_BY = "group_by";
    private List<RumMetricGroupBy> groupBy = null;
    public static final String JSON_PROPERTY_UNIQUENESS = "uniqueness";
    private RumMetricUniqueness uniqueness;
    private Map<String, Object> additionalProperties;

    public RumMetricCreateAttributes() {
    }

    @JsonCreator
    public RumMetricCreateAttributes(@JsonProperty(required=true, value="compute") RumMetricCompute compute, @JsonProperty(required=true, value="event_type") RumMetricEventType eventType) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        this.eventType = eventType;
        this.unparsed |= !eventType.isValid();
    }

    public RumMetricCreateAttributes compute(RumMetricCompute compute) {
        this.compute = compute;
        this.unparsed |= compute.unparsed;
        return this;
    }

    @JsonProperty(value="compute")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RumMetricCompute getCompute() {
        return this.compute;
    }

    public void setCompute(RumMetricCompute compute) {
        this.compute = compute;
    }

    public RumMetricCreateAttributes eventType(RumMetricEventType eventType) {
        this.eventType = eventType;
        this.unparsed |= !eventType.isValid();
        return this;
    }

    @JsonProperty(value="event_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RumMetricEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(RumMetricEventType eventType) {
        if (!eventType.isValid()) {
            this.unparsed = true;
        }
        this.eventType = eventType;
    }

    public RumMetricCreateAttributes filter(RumMetricFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RumMetricFilter getFilter() {
        return this.filter;
    }

    public void setFilter(RumMetricFilter filter) {
        this.filter = filter;
    }

    public RumMetricCreateAttributes groupBy(List<RumMetricGroupBy> groupBy) {
        this.groupBy = groupBy;
        for (RumMetricGroupBy item : groupBy) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public RumMetricCreateAttributes addGroupByItem(RumMetricGroupBy groupByItem) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<RumMetricGroupBy>();
        }
        this.groupBy.add(groupByItem);
        this.unparsed |= groupByItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<RumMetricGroupBy> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<RumMetricGroupBy> groupBy) {
        this.groupBy = groupBy;
    }

    public RumMetricCreateAttributes uniqueness(RumMetricUniqueness uniqueness) {
        this.uniqueness = uniqueness;
        this.unparsed |= uniqueness.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="uniqueness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RumMetricUniqueness getUniqueness() {
        return this.uniqueness;
    }

    public void setUniqueness(RumMetricUniqueness uniqueness) {
        this.uniqueness = uniqueness;
    }

    @JsonAnySetter
    public RumMetricCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RumMetricCreateAttributes rumMetricCreateAttributes = (RumMetricCreateAttributes)o;
        return Objects.equals(this.compute, rumMetricCreateAttributes.compute) && Objects.equals(this.eventType, rumMetricCreateAttributes.eventType) && Objects.equals(this.filter, rumMetricCreateAttributes.filter) && Objects.equals(this.groupBy, rumMetricCreateAttributes.groupBy) && Objects.equals(this.uniqueness, rumMetricCreateAttributes.uniqueness) && Objects.equals(this.additionalProperties, rumMetricCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.compute, this.eventType, this.filter, this.groupBy, this.uniqueness, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RumMetricCreateAttributes {\n");
        sb.append("    compute: ").append(this.toIndentedString(this.compute)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    uniqueness: ").append(this.toIndentedString(this.uniqueness)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

