/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ChargebackBreakdown;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_name", "account_public_id", "charges", "date", "org_name", "projected_total_cost", "public_id", "region"})
public class ProjectedCostAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_NAME = "account_name";
    private String accountName;
    public static final String JSON_PROPERTY_ACCOUNT_PUBLIC_ID = "account_public_id";
    private String accountPublicId;
    public static final String JSON_PROPERTY_CHARGES = "charges";
    private List<ChargebackBreakdown> charges = null;
    public static final String JSON_PROPERTY_DATE = "date";
    private OffsetDateTime date;
    public static final String JSON_PROPERTY_ORG_NAME = "org_name";
    private String orgName;
    public static final String JSON_PROPERTY_PROJECTED_TOTAL_COST = "projected_total_cost";
    private Double projectedTotalCost;
    public static final String JSON_PROPERTY_PUBLIC_ID = "public_id";
    private String publicId;
    public static final String JSON_PROPERTY_REGION = "region";
    private String region;
    private Map<String, Object> additionalProperties;

    public ProjectedCostAttributes accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public ProjectedCostAttributes accountPublicId(String accountPublicId) {
        this.accountPublicId = accountPublicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountPublicId() {
        return this.accountPublicId;
    }

    public void setAccountPublicId(String accountPublicId) {
        this.accountPublicId = accountPublicId;
    }

    public ProjectedCostAttributes charges(List<ChargebackBreakdown> charges) {
        this.charges = charges;
        for (ChargebackBreakdown item : charges) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ProjectedCostAttributes addChargesItem(ChargebackBreakdown chargesItem) {
        if (this.charges == null) {
            this.charges = new ArrayList<ChargebackBreakdown>();
        }
        this.charges.add(chargesItem);
        this.unparsed |= chargesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="charges")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ChargebackBreakdown> getCharges() {
        return this.charges;
    }

    public void setCharges(List<ChargebackBreakdown> charges) {
        this.charges = charges;
    }

    public ProjectedCostAttributes date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Nullable
    @JsonProperty(value="date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public ProjectedCostAttributes orgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    @Nullable
    @JsonProperty(value="org_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public ProjectedCostAttributes projectedTotalCost(Double projectedTotalCost) {
        this.projectedTotalCost = projectedTotalCost;
        return this;
    }

    @Nullable
    @JsonProperty(value="projected_total_cost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getProjectedTotalCost() {
        return this.projectedTotalCost;
    }

    public void setProjectedTotalCost(Double projectedTotalCost) {
        this.projectedTotalCost = projectedTotalCost;
    }

    public ProjectedCostAttributes publicId(String publicId) {
        this.publicId = publicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPublicId() {
        return this.publicId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public ProjectedCostAttributes region(String region) {
        this.region = region;
        return this;
    }

    @Nullable
    @JsonProperty(value="region")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    @JsonAnySetter
    public ProjectedCostAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectedCostAttributes projectedCostAttributes = (ProjectedCostAttributes)o;
        return Objects.equals(this.accountName, projectedCostAttributes.accountName) && Objects.equals(this.accountPublicId, projectedCostAttributes.accountPublicId) && Objects.equals(this.charges, projectedCostAttributes.charges) && Objects.equals(this.date, projectedCostAttributes.date) && Objects.equals(this.orgName, projectedCostAttributes.orgName) && Objects.equals(this.projectedTotalCost, projectedCostAttributes.projectedTotalCost) && Objects.equals(this.publicId, projectedCostAttributes.publicId) && Objects.equals(this.region, projectedCostAttributes.region) && Objects.equals(this.additionalProperties, projectedCostAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.accountPublicId, this.charges, this.date, this.orgName, this.projectedTotalCost, this.publicId, this.region, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectedCostAttributes {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountPublicId: ").append(this.toIndentedString(this.accountPublicId)).append("\n");
        sb.append("    charges: ").append(this.toIndentedString(this.charges)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    orgName: ").append(this.toIndentedString(this.orgName)).append("\n");
        sb.append("    projectedTotalCost: ").append(this.toIndentedString(this.projectedTotalCost)).append("\n");
        sb.append("    publicId: ").append(this.toIndentedString(this.publicId)).append("\n");
        sb.append("    region: ").append(this.toIndentedString(this.region)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

