/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Log;
import com.datadog.api.client.v2.model.LogsListResponseLinks;
import com.datadog.api.client.v2.model.LogsResponseMetadata;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"data", "links", "meta"})
public class LogsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DATA = "data";
    private List<Log> data = null;
    public static final String JSON_PROPERTY_LINKS = "links";
    private LogsListResponseLinks links;
    public static final String JSON_PROPERTY_META = "meta";
    private LogsResponseMetadata meta;
    private Map<String, Object> additionalProperties;

    public LogsListResponse data(List<Log> data) {
        this.data = data;
        for (Log item : data) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsListResponse addDataItem(Log dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Log>();
        }
        this.data.add(dataItem);
        this.unparsed |= dataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Log> getData() {
        return this.data;
    }

    public void setData(List<Log> data) {
        this.data = data;
    }

    public LogsListResponse links(LogsListResponseLinks links) {
        this.links = links;
        this.unparsed |= links.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsListResponseLinks getLinks() {
        return this.links;
    }

    public void setLinks(LogsListResponseLinks links) {
        this.links = links;
    }

    public LogsListResponse meta(LogsResponseMetadata meta) {
        this.meta = meta;
        this.unparsed |= meta.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="meta")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogsResponseMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(LogsResponseMetadata meta) {
        this.meta = meta;
    }

    @JsonAnySetter
    public LogsListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsListResponse logsListResponse = (LogsListResponse)o;
        return Objects.equals(this.data, logsListResponse.data) && Objects.equals(this.links, logsListResponse.links) && Objects.equals(this.meta, logsListResponse.meta) && Objects.equals(this.additionalProperties, logsListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.links, this.meta, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsListResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

