/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IssueCaseAttributes;
import com.datadog.api.client.v2.model.IssueCaseRelationships;
import com.datadog.api.client.v2.model.IssueCaseResourceType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "relationships", "type"})
public class IssueCase {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private IssueCaseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_RELATIONSHIPS = "relationships";
    private IssueCaseRelationships relationships;
    public static final String JSON_PROPERTY_TYPE = "type";
    private IssueCaseResourceType type;
    private Map<String, Object> additionalProperties;

    public IssueCase() {
    }

    @JsonCreator
    public IssueCase(@JsonProperty(required=true, value="attributes") IssueCaseAttributes attributes, @JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") IssueCaseResourceType type) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public IssueCase attributes(IssueCaseAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IssueCaseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(IssueCaseAttributes attributes) {
        this.attributes = attributes;
    }

    public IssueCase id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IssueCase relationships(IssueCaseRelationships relationships) {
        this.relationships = relationships;
        this.unparsed |= relationships.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="relationships")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IssueCaseRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(IssueCaseRelationships relationships) {
        this.relationships = relationships;
    }

    public IssueCase type(IssueCaseResourceType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public IssueCaseResourceType getType() {
        return this.type;
    }

    public void setType(IssueCaseResourceType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public IssueCase putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueCase issueCase = (IssueCase)o;
        return Objects.equals(this.attributes, issueCase.attributes) && Objects.equals(this.id, issueCase.id) && Objects.equals(this.relationships, issueCase.relationships) && Objects.equals(this.type, issueCase.type) && Objects.equals(this.additionalProperties, issueCase.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.relationships, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueCase {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

