/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CustomCostsFileUsageChargePeriod;
import com.datadog.api.client.v2.model.CustomCostsUser;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"billed_cost", "billing_currency", "charge_period", "name", "provider_names", "status", "uploaded_at", "uploaded_by"})
public class CustomCostsFileMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BILLED_COST = "billed_cost";
    private Double billedCost;
    public static final String JSON_PROPERTY_BILLING_CURRENCY = "billing_currency";
    private String billingCurrency;
    public static final String JSON_PROPERTY_CHARGE_PERIOD = "charge_period";
    private CustomCostsFileUsageChargePeriod chargePeriod;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PROVIDER_NAMES = "provider_names";
    private List<String> providerNames = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_UPLOADED_AT = "uploaded_at";
    private Double uploadedAt;
    public static final String JSON_PROPERTY_UPLOADED_BY = "uploaded_by";
    private CustomCostsUser uploadedBy;
    private Map<String, Object> additionalProperties;

    public CustomCostsFileMetadata billedCost(Double billedCost) {
        this.billedCost = billedCost;
        return this;
    }

    @Nullable
    @JsonProperty(value="billed_cost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getBilledCost() {
        return this.billedCost;
    }

    public void setBilledCost(Double billedCost) {
        this.billedCost = billedCost;
    }

    public CustomCostsFileMetadata billingCurrency(String billingCurrency) {
        this.billingCurrency = billingCurrency;
        return this;
    }

    @Nullable
    @JsonProperty(value="billing_currency")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBillingCurrency() {
        return this.billingCurrency;
    }

    public void setBillingCurrency(String billingCurrency) {
        this.billingCurrency = billingCurrency;
    }

    public CustomCostsFileMetadata chargePeriod(CustomCostsFileUsageChargePeriod chargePeriod) {
        this.chargePeriod = chargePeriod;
        this.unparsed |= chargePeriod.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="charge_period")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomCostsFileUsageChargePeriod getChargePeriod() {
        return this.chargePeriod;
    }

    public void setChargePeriod(CustomCostsFileUsageChargePeriod chargePeriod) {
        this.chargePeriod = chargePeriod;
    }

    public CustomCostsFileMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomCostsFileMetadata providerNames(List<String> providerNames) {
        this.providerNames = providerNames;
        return this;
    }

    public CustomCostsFileMetadata addProviderNamesItem(String providerNamesItem) {
        if (this.providerNames == null) {
            this.providerNames = new ArrayList<String>();
        }
        this.providerNames.add(providerNamesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="provider_names")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getProviderNames() {
        return this.providerNames;
    }

    public void setProviderNames(List<String> providerNames) {
        this.providerNames = providerNames;
    }

    public CustomCostsFileMetadata status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public CustomCostsFileMetadata uploadedAt(Double uploadedAt) {
        this.uploadedAt = uploadedAt;
        return this;
    }

    @Nullable
    @JsonProperty(value="uploaded_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getUploadedAt() {
        return this.uploadedAt;
    }

    public void setUploadedAt(Double uploadedAt) {
        this.uploadedAt = uploadedAt;
    }

    public CustomCostsFileMetadata uploadedBy(CustomCostsUser uploadedBy) {
        this.uploadedBy = uploadedBy;
        this.unparsed |= uploadedBy.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="uploaded_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CustomCostsUser getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(CustomCostsUser uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    @JsonAnySetter
    public CustomCostsFileMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomCostsFileMetadata customCostsFileMetadata = (CustomCostsFileMetadata)o;
        return Objects.equals(this.billedCost, customCostsFileMetadata.billedCost) && Objects.equals(this.billingCurrency, customCostsFileMetadata.billingCurrency) && Objects.equals(this.chargePeriod, customCostsFileMetadata.chargePeriod) && Objects.equals(this.name, customCostsFileMetadata.name) && Objects.equals(this.providerNames, customCostsFileMetadata.providerNames) && Objects.equals(this.status, customCostsFileMetadata.status) && Objects.equals(this.uploadedAt, customCostsFileMetadata.uploadedAt) && Objects.equals(this.uploadedBy, customCostsFileMetadata.uploadedBy) && Objects.equals(this.additionalProperties, customCostsFileMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.billedCost, this.billingCurrency, this.chargePeriod, this.name, this.providerNames, this.status, this.uploadedAt, this.uploadedBy, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomCostsFileMetadata {\n");
        sb.append("    billedCost: ").append(this.toIndentedString(this.billedCost)).append("\n");
        sb.append("    billingCurrency: ").append(this.toIndentedString(this.billingCurrency)).append("\n");
        sb.append("    chargePeriod: ").append(this.toIndentedString(this.chargePeriod)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    providerNames: ").append(this.toIndentedString(this.providerNames)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    uploadedAt: ").append(this.toIndentedString(this.uploadedAt)).append("\n");
        sb.append("    uploadedBy: ").append(this.toIndentedString(this.uploadedBy)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

