/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.AbstractOpenApiSchema;
import com.datadog.api.client.JSON;
import com.datadog.api.client.UnparsedObject;
import com.datadog.api.client.v2.model.Container;
import com.datadog.api.client.v2.model.ContainerGroup;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.core.JsonGenerator;
import com.datadoghq.com.fasterxml.jackson.core.JsonParser;
import com.datadoghq.com.fasterxml.jackson.core.JsonProcessingException;
import com.datadoghq.com.fasterxml.jackson.core.JsonToken;
import com.datadoghq.com.fasterxml.jackson.core.type.TypeReference;
import com.datadoghq.com.fasterxml.jackson.databind.DeserializationContext;
import com.datadoghq.com.fasterxml.jackson.databind.JsonMappingException;
import com.datadoghq.com.fasterxml.jackson.databind.JsonNode;
import com.datadoghq.com.fasterxml.jackson.databind.MapperFeature;
import com.datadoghq.com.fasterxml.jackson.databind.ObjectMapper;
import com.datadoghq.com.fasterxml.jackson.databind.SerializerProvider;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.datadoghq.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.datadoghq.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.datadoghq.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=ContainerItemDeserializer.class)
@JsonSerialize(using=ContainerItemSerializer.class)
public class ContainerItem
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(ContainerItem.class.getName());
    @JsonIgnore
    public boolean unparsed = false;
    public static final Map<String, GenericType> schemas = new HashMap<String, GenericType>();

    public ContainerItem() {
        super("oneOf", Boolean.FALSE);
    }

    public ContainerItem(Container o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public ContainerItem(ContainerGroup o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, GenericType> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(Container.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(ContainerGroup.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnparsedObject.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be Container, ContainerGroup");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Container getContainer() throws ClassCastException {
        return (Container)super.getActualInstance();
    }

    public ContainerGroup getContainerGroup() throws ClassCastException {
        return (ContainerGroup)super.getActualInstance();
    }

    static {
        schemas.put("Container", new GenericType<Container>(){});
        schemas.put("ContainerGroup", new GenericType<ContainerGroup>(){});
        JSON.registerDescendants(ContainerItem.class, Collections.unmodifiableMap(schemas));
    }

    public static class ContainerItemDeserializer
    extends StdDeserializer<ContainerItem> {
        public ContainerItemDeserializer() {
            this(ContainerItem.class);
        }

        public ContainerItemDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public ContainerItem deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            Object tmp = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((Container.class.equals(Integer.class) || Container.class.equals(Long.class) || Container.class.equals(Float.class) || Container.class.equals(Double.class) || Container.class.equals(Boolean.class) || Container.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (Container.class.equals(Integer.class) || Container.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!Container.class.equals(Float.class) && !Container.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= Container.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= Container.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(Container.class);
                    if (!((Container)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'Container'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'Container'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((ContainerGroup.class.equals(Integer.class) || ContainerGroup.class.equals(Long.class) || ContainerGroup.class.equals(Float.class) || ContainerGroup.class.equals(Double.class) || ContainerGroup.class.equals(Boolean.class) || ContainerGroup.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (ContainerGroup.class.equals(Integer.class) || ContainerGroup.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= !(!ContainerGroup.class.equals(Float.class) && !ContainerGroup.class.equals(Double.class) || token != JsonToken.VALUE_NUMBER_FLOAT && token != JsonToken.VALUE_NUMBER_INT);
                    attemptParsing |= ContainerGroup.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= ContainerGroup.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    tmp = tree.traverse(jp.getCodec()).readValueAs(ContainerGroup.class);
                    if (!((ContainerGroup)tmp).unparsed) {
                        deserialized = tmp;
                        ++match;
                    }
                    log.log(Level.FINER, "Input data matches schema 'ContainerGroup'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'ContainerGroup'", e);
            }
            ContainerItem ret = new ContainerItem();
            if (match == 1) {
                ret.setActualInstance(deserialized);
            } else {
                Map<String, Object> res = new ObjectMapper().readValue(tree.traverse(jp.getCodec()).readValueAsTree().toString(), new TypeReference<Map<String, Object>>(){});
                ret.setActualInstance(new UnparsedObject(res));
            }
            return ret;
        }

        @Override
        public ContainerItem getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException(ctxt.getParser(), "ContainerItem cannot be null");
        }
    }

    public static class ContainerItemSerializer
    extends StdSerializer<ContainerItem> {
        public ContainerItemSerializer(Class<ContainerItem> t) {
            super(t);
        }

        public ContainerItemSerializer() {
            this((Class<ContainerItem>)null);
        }

        @Override
        public void serialize(ContainerItem value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

