/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.Component;
import com.datadog.api.client.v2.model.ComponentGridPropertiesIsVisible;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"backgroundColor", "children", "isVisible"})
public class ComponentGridProperties {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BACKGROUND_COLOR = "backgroundColor";
    private String backgroundColor = "default";
    public static final String JSON_PROPERTY_CHILDREN = "children";
    private List<Component> children = null;
    public static final String JSON_PROPERTY_IS_VISIBLE = "isVisible";
    private ComponentGridPropertiesIsVisible isVisible;
    private Map<String, Object> additionalProperties;

    public ComponentGridProperties backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Nullable
    @JsonProperty(value="backgroundColor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ComponentGridProperties children(List<Component> children) {
        this.children = children;
        for (Component item : children) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ComponentGridProperties addChildrenItem(Component childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<Component>();
        }
        this.children.add(childrenItem);
        this.unparsed |= childrenItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="children")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Component> getChildren() {
        return this.children;
    }

    public void setChildren(List<Component> children) {
        this.children = children;
    }

    public ComponentGridProperties isVisible(ComponentGridPropertiesIsVisible isVisible) {
        this.isVisible = isVisible;
        this.unparsed |= isVisible.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="isVisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ComponentGridPropertiesIsVisible getIsVisible() {
        return this.isVisible;
    }

    public void setIsVisible(ComponentGridPropertiesIsVisible isVisible) {
        this.isVisible = isVisible;
    }

    @JsonAnySetter
    public ComponentGridProperties putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentGridProperties componentGridProperties = (ComponentGridProperties)o;
        return Objects.equals(this.backgroundColor, componentGridProperties.backgroundColor) && Objects.equals(this.children, componentGridProperties.children) && Objects.equals(this.isVisible, componentGridProperties.isVisible) && Objects.equals(this.additionalProperties, componentGridProperties.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.children, this.isVisible, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ComponentGridProperties {\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    isVisible: ").append(this.toIndentedString(this.isVisible)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

