/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CloudflareGlobalAPITokenType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"auth_email", "global_api_key", "type"})
public class CloudflareGlobalAPITokenUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTH_EMAIL = "auth_email";
    private String authEmail;
    public static final String JSON_PROPERTY_GLOBAL_API_KEY = "global_api_key";
    private String globalApiKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    private CloudflareGlobalAPITokenType type;
    private Map<String, Object> additionalProperties;

    public CloudflareGlobalAPITokenUpdate() {
    }

    @JsonCreator
    public CloudflareGlobalAPITokenUpdate(@JsonProperty(required=true, value="type") CloudflareGlobalAPITokenType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public CloudflareGlobalAPITokenUpdate authEmail(String authEmail) {
        this.authEmail = authEmail;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth_email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthEmail() {
        return this.authEmail;
    }

    public void setAuthEmail(String authEmail) {
        this.authEmail = authEmail;
    }

    public CloudflareGlobalAPITokenUpdate globalApiKey(String globalApiKey) {
        this.globalApiKey = globalApiKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="global_api_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGlobalApiKey() {
        return this.globalApiKey;
    }

    public void setGlobalApiKey(String globalApiKey) {
        this.globalApiKey = globalApiKey;
    }

    public CloudflareGlobalAPITokenUpdate type(CloudflareGlobalAPITokenType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CloudflareGlobalAPITokenType getType() {
        return this.type;
    }

    public void setType(CloudflareGlobalAPITokenType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CloudflareGlobalAPITokenUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudflareGlobalAPITokenUpdate cloudflareGlobalApiTokenUpdate = (CloudflareGlobalAPITokenUpdate)o;
        return Objects.equals(this.authEmail, cloudflareGlobalApiTokenUpdate.authEmail) && Objects.equals(this.globalApiKey, cloudflareGlobalApiTokenUpdate.globalApiKey) && Objects.equals(this.type, cloudflareGlobalApiTokenUpdate.type) && Objects.equals(this.additionalProperties, cloudflareGlobalApiTokenUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.authEmail, this.globalApiKey, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudflareGlobalAPITokenUpdate {\n");
        sb.append("    authEmail: ").append(this.toIndentedString(this.authEmail)).append("\n");
        sb.append("    globalApiKey: ").append(this.toIndentedString(this.globalApiKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

