/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSAssumeRoleType;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "generate_new_external_id", "role", "type"})
public class AWSAssumeRoleUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_GENERATE_NEW_EXTERNAL_ID = "generate_new_external_id";
    private Boolean generateNewExternalId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AWSAssumeRoleType type;
    private Map<String, Object> additionalProperties;

    public AWSAssumeRoleUpdate() {
    }

    @JsonCreator
    public AWSAssumeRoleUpdate(@JsonProperty(required=true, value="type") AWSAssumeRoleType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AWSAssumeRoleUpdate accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSAssumeRoleUpdate generateNewExternalId(Boolean generateNewExternalId) {
        this.generateNewExternalId = generateNewExternalId;
        return this;
    }

    @Nullable
    @JsonProperty(value="generate_new_external_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGenerateNewExternalId() {
        return this.generateNewExternalId;
    }

    public void setGenerateNewExternalId(Boolean generateNewExternalId) {
        this.generateNewExternalId = generateNewExternalId;
    }

    public AWSAssumeRoleUpdate role(String role) {
        this.role = role;
        return this;
    }

    @Nullable
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public AWSAssumeRoleUpdate type(AWSAssumeRoleType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AWSAssumeRoleType getType() {
        return this.type;
    }

    public void setType(AWSAssumeRoleType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AWSAssumeRoleUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAssumeRoleUpdate awsAssumeRoleUpdate = (AWSAssumeRoleUpdate)o;
        return Objects.equals(this.accountId, awsAssumeRoleUpdate.accountId) && Objects.equals(this.generateNewExternalId, awsAssumeRoleUpdate.generateNewExternalId) && Objects.equals(this.role, awsAssumeRoleUpdate.role) && Objects.equals(this.type, awsAssumeRoleUpdate.type) && Objects.equals(this.additionalProperties, awsAssumeRoleUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.generateNewExternalId, this.role, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAssumeRoleUpdate {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    generateNewExternalId: ").append(this.toIndentedString(this.generateNewExternalId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

