/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RecommendationDocument;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class SpaApi {
    private ApiClient apiClient;

    public SpaApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public SpaApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public RecommendationDocument getSPARecommendations(String shard, String service) throws ApiException {
        return this.getSPARecommendationsWithHttpInfo(shard, service).getData();
    }

    public CompletableFuture<RecommendationDocument> getSPARecommendationsAsync(String shard, String service) {
        return this.getSPARecommendationsWithHttpInfoAsync(shard, service).thenApply(response -> (RecommendationDocument)response.getData());
    }

    public ApiResponse<RecommendationDocument> getSPARecommendationsWithHttpInfo(String shard, String service) throws ApiException {
        String operationId = "getSPARecommendations";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (shard == null) {
            throw new ApiException(400, "Missing the required parameter 'shard' when calling getSPARecommendations");
        }
        if (service == null) {
            throw new ApiException(400, "Missing the required parameter 'service' when calling getSPARecommendations");
        }
        String localVarPath = "/api/v2/spa/recommendations/{service}/{shard}".replaceAll("\\{shard\\}", this.apiClient.escapeString(shard.toString())).replaceAll("\\{service\\}", this.apiClient.escapeString(service.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.SpaApi.getSPARecommendations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RecommendationDocument>(){});
    }

    public CompletableFuture<ApiResponse<RecommendationDocument>> getSPARecommendationsWithHttpInfoAsync(String shard, String service) {
        Invocation.Builder builder;
        String operationId = "getSPARecommendations";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<RecommendationDocument>> result = new CompletableFuture<ApiResponse<RecommendationDocument>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (shard == null) {
            CompletableFuture<ApiResponse<RecommendationDocument>> result = new CompletableFuture<ApiResponse<RecommendationDocument>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'shard' when calling getSPARecommendations"));
            return result;
        }
        if (service == null) {
            CompletableFuture<ApiResponse<RecommendationDocument>> result = new CompletableFuture<ApiResponse<RecommendationDocument>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'service' when calling getSPARecommendations"));
            return result;
        }
        String localVarPath = "/api/v2/spa/recommendations/{service}/{shard}".replaceAll("\\{shard\\}", this.apiClient.escapeString(shard.toString())).replaceAll("\\{service\\}", this.apiClient.escapeString(service.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.SpaApi.getSPARecommendations", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RecommendationDocument>> result = new CompletableFuture<ApiResponse<RecommendationDocument>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RecommendationDocument>(){});
    }
}

