/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.RestrictionPolicyResponse;
import com.datadog.api.client.v2.model.RestrictionPolicyUpdateRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class RestrictionPoliciesApi {
    private ApiClient apiClient;

    public RestrictionPoliciesApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public RestrictionPoliciesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteRestrictionPolicy(String resourceId) throws ApiException {
        this.deleteRestrictionPolicyWithHttpInfo(resourceId);
    }

    public CompletableFuture<Void> deleteRestrictionPolicyAsync(String resourceId) {
        return this.deleteRestrictionPolicyWithHttpInfoAsync(resourceId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteRestrictionPolicyWithHttpInfo(String resourceId) throws ApiException {
        Object localVarPostBody = null;
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteRestrictionPolicy");
        }
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.deleteRestrictionPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteRestrictionPolicyWithHttpInfoAsync(String resourceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (resourceId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling deleteRestrictionPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.deleteRestrictionPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public RestrictionPolicyResponse getRestrictionPolicy(String resourceId) throws ApiException {
        return this.getRestrictionPolicyWithHttpInfo(resourceId).getData();
    }

    public CompletableFuture<RestrictionPolicyResponse> getRestrictionPolicyAsync(String resourceId) {
        return this.getRestrictionPolicyWithHttpInfoAsync(resourceId).thenApply(response -> (RestrictionPolicyResponse)response.getData());
    }

    public ApiResponse<RestrictionPolicyResponse> getRestrictionPolicyWithHttpInfo(String resourceId) throws ApiException {
        Object localVarPostBody = null;
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling getRestrictionPolicy");
        }
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.getRestrictionPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionPolicyResponse>> getRestrictionPolicyWithHttpInfoAsync(String resourceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (resourceId == null) {
            CompletableFuture<ApiResponse<RestrictionPolicyResponse>> result = new CompletableFuture<ApiResponse<RestrictionPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling getRestrictionPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.getRestrictionPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionPolicyResponse>> result = new CompletableFuture<ApiResponse<RestrictionPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionPolicyResponse>(){});
    }

    public RestrictionPolicyResponse updateRestrictionPolicy(String resourceId, RestrictionPolicyUpdateRequest body) throws ApiException {
        return this.updateRestrictionPolicyWithHttpInfo(resourceId, body, new UpdateRestrictionPolicyOptionalParameters()).getData();
    }

    public CompletableFuture<RestrictionPolicyResponse> updateRestrictionPolicyAsync(String resourceId, RestrictionPolicyUpdateRequest body) {
        return this.updateRestrictionPolicyWithHttpInfoAsync(resourceId, body, new UpdateRestrictionPolicyOptionalParameters()).thenApply(response -> (RestrictionPolicyResponse)response.getData());
    }

    public RestrictionPolicyResponse updateRestrictionPolicy(String resourceId, RestrictionPolicyUpdateRequest body, UpdateRestrictionPolicyOptionalParameters parameters) throws ApiException {
        return this.updateRestrictionPolicyWithHttpInfo(resourceId, body, parameters).getData();
    }

    public CompletableFuture<RestrictionPolicyResponse> updateRestrictionPolicyAsync(String resourceId, RestrictionPolicyUpdateRequest body, UpdateRestrictionPolicyOptionalParameters parameters) {
        return this.updateRestrictionPolicyWithHttpInfoAsync(resourceId, body, parameters).thenApply(response -> (RestrictionPolicyResponse)response.getData());
    }

    public ApiResponse<RestrictionPolicyResponse> updateRestrictionPolicyWithHttpInfo(String resourceId, RestrictionPolicyUpdateRequest body, UpdateRestrictionPolicyOptionalParameters parameters) throws ApiException {
        RestrictionPolicyUpdateRequest localVarPostBody = body;
        if (resourceId == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceId' when calling updateRestrictionPolicy");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateRestrictionPolicy");
        }
        Boolean allowSelfLockout = parameters.allowSelfLockout;
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "allow_self_lockout", allowSelfLockout));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.updateRestrictionPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionPolicyResponse>(){});
    }

    public CompletableFuture<ApiResponse<RestrictionPolicyResponse>> updateRestrictionPolicyWithHttpInfoAsync(String resourceId, RestrictionPolicyUpdateRequest body, UpdateRestrictionPolicyOptionalParameters parameters) {
        Invocation.Builder builder;
        RestrictionPolicyUpdateRequest localVarPostBody = body;
        if (resourceId == null) {
            CompletableFuture<ApiResponse<RestrictionPolicyResponse>> result = new CompletableFuture<ApiResponse<RestrictionPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'resourceId' when calling updateRestrictionPolicy"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<RestrictionPolicyResponse>> result = new CompletableFuture<ApiResponse<RestrictionPolicyResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateRestrictionPolicy"));
            return result;
        }
        Boolean allowSelfLockout = parameters.allowSelfLockout;
        String localVarPath = "/api/v2/restriction_policy/{resource_id}".replaceAll("\\{resource_id\\}", this.apiClient.escapeString(resourceId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "allow_self_lockout", allowSelfLockout));
        try {
            builder = this.apiClient.createBuilder("v2.RestrictionPoliciesApi.updateRestrictionPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<RestrictionPolicyResponse>> result = new CompletableFuture<ApiResponse<RestrictionPolicyResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<RestrictionPolicyResponse>(){});
    }

    public static class UpdateRestrictionPolicyOptionalParameters {
        private Boolean allowSelfLockout;

        public UpdateRestrictionPolicyOptionalParameters allowSelfLockout(Boolean allowSelfLockout) {
            this.allowSelfLockout = allowSelfLockout;
            return this;
        }
    }
}

