/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.ListPowerpacksResponse;
import com.datadog.api.client.v2.model.Powerpack;
import com.datadog.api.client.v2.model.PowerpackData;
import com.datadog.api.client.v2.model.PowerpackResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class PowerpackApi {
    private ApiClient apiClient;

    public PowerpackApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public PowerpackApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PowerpackResponse createPowerpack(Powerpack body) throws ApiException {
        return this.createPowerpackWithHttpInfo(body).getData();
    }

    public CompletableFuture<PowerpackResponse> createPowerpackAsync(Powerpack body) {
        return this.createPowerpackWithHttpInfoAsync(body).thenApply(response -> (PowerpackResponse)response.getData());
    }

    public ApiResponse<PowerpackResponse> createPowerpackWithHttpInfo(Powerpack body) throws ApiException {
        Powerpack localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createPowerpack");
        }
        String localVarPath = "/api/v2/powerpacks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.PowerpackApi.createPowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public CompletableFuture<ApiResponse<PowerpackResponse>> createPowerpackWithHttpInfoAsync(Powerpack body) {
        Invocation.Builder builder;
        Powerpack localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createPowerpack"));
            return result;
        }
        String localVarPath = "/api/v2/powerpacks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.PowerpackApi.createPowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public void deletePowerpack(String powerpackId) throws ApiException {
        this.deletePowerpackWithHttpInfo(powerpackId);
    }

    public CompletableFuture<Void> deletePowerpackAsync(String powerpackId) {
        return this.deletePowerpackWithHttpInfoAsync(powerpackId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deletePowerpackWithHttpInfo(String powerpackId) throws ApiException {
        Object localVarPostBody = null;
        if (powerpackId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerpackId' when calling deletePowerpack");
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.PowerpackApi.deletePowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deletePowerpackWithHttpInfoAsync(String powerpackId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (powerpackId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'powerpackId' when calling deletePowerpack"));
            return result;
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.PowerpackApi.deletePowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public PowerpackResponse getPowerpack(String powerpackId) throws ApiException {
        return this.getPowerpackWithHttpInfo(powerpackId).getData();
    }

    public CompletableFuture<PowerpackResponse> getPowerpackAsync(String powerpackId) {
        return this.getPowerpackWithHttpInfoAsync(powerpackId).thenApply(response -> (PowerpackResponse)response.getData());
    }

    public ApiResponse<PowerpackResponse> getPowerpackWithHttpInfo(String powerpackId) throws ApiException {
        Object localVarPostBody = null;
        if (powerpackId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerpackId' when calling getPowerpack");
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.PowerpackApi.getPowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public CompletableFuture<ApiResponse<PowerpackResponse>> getPowerpackWithHttpInfoAsync(String powerpackId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (powerpackId == null) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'powerpackId' when calling getPowerpack"));
            return result;
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.PowerpackApi.getPowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public ListPowerpacksResponse listPowerpacks() throws ApiException {
        return this.listPowerpacksWithHttpInfo(new ListPowerpacksOptionalParameters()).getData();
    }

    public CompletableFuture<ListPowerpacksResponse> listPowerpacksAsync() {
        return this.listPowerpacksWithHttpInfoAsync(new ListPowerpacksOptionalParameters()).thenApply(response -> (ListPowerpacksResponse)response.getData());
    }

    public ListPowerpacksResponse listPowerpacks(ListPowerpacksOptionalParameters parameters) throws ApiException {
        return this.listPowerpacksWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListPowerpacksResponse> listPowerpacksAsync(ListPowerpacksOptionalParameters parameters) {
        return this.listPowerpacksWithHttpInfoAsync(parameters).thenApply(response -> (ListPowerpacksResponse)response.getData());
    }

    public PaginationIterable<PowerpackData> listPowerpacksWithPagination() {
        ListPowerpacksOptionalParameters parameters = new ListPowerpacksOptionalParameters();
        return this.listPowerpacksWithPagination(parameters);
    }

    public PaginationIterable<PowerpackData> listPowerpacksWithPagination(ListPowerpacksOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageOffset";
        Boolean valueSetterParamOptional = true;
        if (parameters.pageLimit == null) {
            limit = 25L;
            parameters.pageLimit(limit);
        } else {
            limit = parameters.pageLimit;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<PowerpackData> iterator = new PaginationIterable<PowerpackData>(this, "listPowerpacks", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, true, limit, args);
        return iterator;
    }

    public ApiResponse<ListPowerpacksResponse> listPowerpacksWithHttpInfo(ListPowerpacksOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/powerpacks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.PowerpackApi.listPowerpacks", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListPowerpacksResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListPowerpacksResponse>> listPowerpacksWithHttpInfoAsync(ListPowerpacksOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/powerpacks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.PowerpackApi.listPowerpacks", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListPowerpacksResponse>> result = new CompletableFuture<ApiResponse<ListPowerpacksResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListPowerpacksResponse>(){});
    }

    public PowerpackResponse updatePowerpack(String powerpackId, Powerpack body) throws ApiException {
        return this.updatePowerpackWithHttpInfo(powerpackId, body).getData();
    }

    public CompletableFuture<PowerpackResponse> updatePowerpackAsync(String powerpackId, Powerpack body) {
        return this.updatePowerpackWithHttpInfoAsync(powerpackId, body).thenApply(response -> (PowerpackResponse)response.getData());
    }

    public ApiResponse<PowerpackResponse> updatePowerpackWithHttpInfo(String powerpackId, Powerpack body) throws ApiException {
        Powerpack localVarPostBody = body;
        if (powerpackId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerpackId' when calling updatePowerpack");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePowerpack");
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.PowerpackApi.updatePowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public CompletableFuture<ApiResponse<PowerpackResponse>> updatePowerpackWithHttpInfoAsync(String powerpackId, Powerpack body) {
        Invocation.Builder builder;
        Powerpack localVarPostBody = body;
        if (powerpackId == null) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'powerpackId' when calling updatePowerpack"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePowerpack"));
            return result;
        }
        String localVarPath = "/api/v2/powerpacks/{powerpack_id}".replaceAll("\\{powerpack_id\\}", this.apiClient.escapeString(powerpackId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.PowerpackApi.updatePowerpack", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<PowerpackResponse>> result = new CompletableFuture<ApiResponse<PowerpackResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<PowerpackResponse>(){});
    }

    public static class ListPowerpacksOptionalParameters {
        private Long pageLimit;
        private Long pageOffset;

        public ListPowerpacksOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListPowerpacksOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }
}

