/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.OpsgenieServiceCreateRequest;
import com.datadog.api.client.v2.model.OpsgenieServiceResponse;
import com.datadog.api.client.v2.model.OpsgenieServiceUpdateRequest;
import com.datadog.api.client.v2.model.OpsgenieServicesResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OpsgenieIntegrationApi {
    private ApiClient apiClient;

    public OpsgenieIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OpsgenieIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OpsgenieServiceResponse createOpsgenieService(OpsgenieServiceCreateRequest body) throws ApiException {
        return this.createOpsgenieServiceWithHttpInfo(body).getData();
    }

    public CompletableFuture<OpsgenieServiceResponse> createOpsgenieServiceAsync(OpsgenieServiceCreateRequest body) {
        return this.createOpsgenieServiceWithHttpInfoAsync(body).thenApply(response -> (OpsgenieServiceResponse)response.getData());
    }

    public ApiResponse<OpsgenieServiceResponse> createOpsgenieServiceWithHttpInfo(OpsgenieServiceCreateRequest body) throws ApiException {
        OpsgenieServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOpsgenieService");
        }
        String localVarPath = "/api/v2/integration/opsgenie/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.createOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<OpsgenieServiceResponse>> createOpsgenieServiceWithHttpInfoAsync(OpsgenieServiceCreateRequest body) {
        Invocation.Builder builder;
        OpsgenieServiceCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOpsgenieService"));
            return result;
        }
        String localVarPath = "/api/v2/integration/opsgenie/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.createOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }

    public void deleteOpsgenieService(String integrationServiceId) throws ApiException {
        this.deleteOpsgenieServiceWithHttpInfo(integrationServiceId);
    }

    public CompletableFuture<Void> deleteOpsgenieServiceAsync(String integrationServiceId) {
        return this.deleteOpsgenieServiceWithHttpInfoAsync(integrationServiceId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOpsgenieServiceWithHttpInfo(String integrationServiceId) throws ApiException {
        Object localVarPostBody = null;
        if (integrationServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling deleteOpsgenieService");
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.deleteOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOpsgenieServiceWithHttpInfoAsync(String integrationServiceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (integrationServiceId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling deleteOpsgenieService"));
            return result;
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.deleteOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public OpsgenieServiceResponse getOpsgenieService(String integrationServiceId) throws ApiException {
        return this.getOpsgenieServiceWithHttpInfo(integrationServiceId).getData();
    }

    public CompletableFuture<OpsgenieServiceResponse> getOpsgenieServiceAsync(String integrationServiceId) {
        return this.getOpsgenieServiceWithHttpInfoAsync(integrationServiceId).thenApply(response -> (OpsgenieServiceResponse)response.getData());
    }

    public ApiResponse<OpsgenieServiceResponse> getOpsgenieServiceWithHttpInfo(String integrationServiceId) throws ApiException {
        Object localVarPostBody = null;
        if (integrationServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling getOpsgenieService");
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.getOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<OpsgenieServiceResponse>> getOpsgenieServiceWithHttpInfoAsync(String integrationServiceId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (integrationServiceId == null) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling getOpsgenieService"));
            return result;
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.getOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }

    public OpsgenieServicesResponse listOpsgenieServices() throws ApiException {
        return this.listOpsgenieServicesWithHttpInfo().getData();
    }

    public CompletableFuture<OpsgenieServicesResponse> listOpsgenieServicesAsync() {
        return this.listOpsgenieServicesWithHttpInfoAsync().thenApply(response -> (OpsgenieServicesResponse)response.getData());
    }

    public ApiResponse<OpsgenieServicesResponse> listOpsgenieServicesWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/opsgenie/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.listOpsgenieServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServicesResponse>(){});
    }

    public CompletableFuture<ApiResponse<OpsgenieServicesResponse>> listOpsgenieServicesWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/opsgenie/services";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.listOpsgenieServices", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OpsgenieServicesResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServicesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServicesResponse>(){});
    }

    public OpsgenieServiceResponse updateOpsgenieService(String integrationServiceId, OpsgenieServiceUpdateRequest body) throws ApiException {
        return this.updateOpsgenieServiceWithHttpInfo(integrationServiceId, body).getData();
    }

    public CompletableFuture<OpsgenieServiceResponse> updateOpsgenieServiceAsync(String integrationServiceId, OpsgenieServiceUpdateRequest body) {
        return this.updateOpsgenieServiceWithHttpInfoAsync(integrationServiceId, body).thenApply(response -> (OpsgenieServiceResponse)response.getData());
    }

    public ApiResponse<OpsgenieServiceResponse> updateOpsgenieServiceWithHttpInfo(String integrationServiceId, OpsgenieServiceUpdateRequest body) throws ApiException {
        OpsgenieServiceUpdateRequest localVarPostBody = body;
        if (integrationServiceId == null) {
            throw new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling updateOpsgenieService");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOpsgenieService");
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.updateOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }

    public CompletableFuture<ApiResponse<OpsgenieServiceResponse>> updateOpsgenieServiceWithHttpInfoAsync(String integrationServiceId, OpsgenieServiceUpdateRequest body) {
        Invocation.Builder builder;
        OpsgenieServiceUpdateRequest localVarPostBody = body;
        if (integrationServiceId == null) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'integrationServiceId' when calling updateOpsgenieService"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOpsgenieService"));
            return result;
        }
        String localVarPath = "/api/v2/integration/opsgenie/services/{integration_service_id}".replaceAll("\\{integration_service_id\\}", this.apiClient.escapeString(integrationServiceId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OpsgenieIntegrationApi.updateOpsgenieService", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OpsgenieServiceResponse>> result = new CompletableFuture<ApiResponse<OpsgenieServiceResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OpsgenieServiceResponse>(){});
    }
}

