/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.PaginationIterable;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.Case;
import com.datadog.api.client.v2.model.CaseAssignRequest;
import com.datadog.api.client.v2.model.CaseCreateRequest;
import com.datadog.api.client.v2.model.CaseEmptyRequest;
import com.datadog.api.client.v2.model.CaseResponse;
import com.datadog.api.client.v2.model.CaseSortableField;
import com.datadog.api.client.v2.model.CaseUpdateAttributesRequest;
import com.datadog.api.client.v2.model.CaseUpdatePriorityRequest;
import com.datadog.api.client.v2.model.CaseUpdateStatusRequest;
import com.datadog.api.client.v2.model.CasesResponse;
import com.datadog.api.client.v2.model.ProjectCreateRequest;
import com.datadog.api.client.v2.model.ProjectResponse;
import com.datadog.api.client.v2.model.ProjectsResponse;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;

public class CaseManagementApi {
    private ApiClient apiClient;

    public CaseManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public CaseManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CaseResponse archiveCase(String caseId, CaseEmptyRequest body) throws ApiException {
        return this.archiveCaseWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> archiveCaseAsync(String caseId, CaseEmptyRequest body) {
        return this.archiveCaseWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> archiveCaseWithHttpInfo(String caseId, CaseEmptyRequest body) throws ApiException {
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling archiveCase");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling archiveCase");
        }
        String localVarPath = "/api/v2/cases/{case_id}/archive".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.archiveCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> archiveCaseWithHttpInfoAsync(String caseId, CaseEmptyRequest body) {
        Invocation.Builder builder;
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling archiveCase"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling archiveCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/archive".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.archiveCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse assignCase(String caseId, CaseAssignRequest body) throws ApiException {
        return this.assignCaseWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> assignCaseAsync(String caseId, CaseAssignRequest body) {
        return this.assignCaseWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> assignCaseWithHttpInfo(String caseId, CaseAssignRequest body) throws ApiException {
        CaseAssignRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling assignCase");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling assignCase");
        }
        String localVarPath = "/api/v2/cases/{case_id}/assign".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.assignCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> assignCaseWithHttpInfoAsync(String caseId, CaseAssignRequest body) {
        Invocation.Builder builder;
        CaseAssignRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling assignCase"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling assignCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/assign".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.assignCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse createCase(CaseCreateRequest body) throws ApiException {
        return this.createCaseWithHttpInfo(body).getData();
    }

    public CompletableFuture<CaseResponse> createCaseAsync(CaseCreateRequest body) {
        return this.createCaseWithHttpInfoAsync(body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> createCaseWithHttpInfo(CaseCreateRequest body) throws ApiException {
        CaseCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createCase");
        }
        String localVarPath = "/api/v2/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.createCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> createCaseWithHttpInfoAsync(CaseCreateRequest body) {
        Invocation.Builder builder;
        CaseCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.createCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public ProjectResponse createProject(ProjectCreateRequest body) throws ApiException {
        return this.createProjectWithHttpInfo(body).getData();
    }

    public CompletableFuture<ProjectResponse> createProjectAsync(ProjectCreateRequest body) {
        return this.createProjectWithHttpInfoAsync(body).thenApply(response -> (ProjectResponse)response.getData());
    }

    public ApiResponse<ProjectResponse> createProjectWithHttpInfo(ProjectCreateRequest body) throws ApiException {
        ProjectCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createProject");
        }
        String localVarPath = "/api/v2/cases/projects";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.createProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectResponse>(){});
    }

    public CompletableFuture<ApiResponse<ProjectResponse>> createProjectWithHttpInfoAsync(ProjectCreateRequest body) {
        Invocation.Builder builder;
        ProjectCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<ProjectResponse>> result = new CompletableFuture<ApiResponse<ProjectResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createProject"));
            return result;
        }
        String localVarPath = "/api/v2/cases/projects";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.createProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ProjectResponse>> result = new CompletableFuture<ApiResponse<ProjectResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectResponse>(){});
    }

    public void deleteProject(String projectId) throws ApiException {
        this.deleteProjectWithHttpInfo(projectId);
    }

    public CompletableFuture<Void> deleteProjectAsync(String projectId) {
        return this.deleteProjectWithHttpInfoAsync(projectId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteProjectWithHttpInfo(String projectId) throws ApiException {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling deleteProject");
        }
        String localVarPath = "/api/v2/cases/projects/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.deleteProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteProjectWithHttpInfoAsync(String projectId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (projectId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'projectId' when calling deleteProject"));
            return result;
        }
        String localVarPath = "/api/v2/cases/projects/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.deleteProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CaseResponse getCase(String caseId) throws ApiException {
        return this.getCaseWithHttpInfo(caseId).getData();
    }

    public CompletableFuture<CaseResponse> getCaseAsync(String caseId) {
        return this.getCaseWithHttpInfoAsync(caseId).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> getCaseWithHttpInfo(String caseId) throws ApiException {
        Object localVarPostBody = null;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling getCase");
        }
        String localVarPath = "/api/v2/cases/{case_id}".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.getCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> getCaseWithHttpInfoAsync(String caseId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling getCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.getCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public ProjectResponse getProject(String projectId) throws ApiException {
        return this.getProjectWithHttpInfo(projectId).getData();
    }

    public CompletableFuture<ProjectResponse> getProjectAsync(String projectId) {
        return this.getProjectWithHttpInfoAsync(projectId).thenApply(response -> (ProjectResponse)response.getData());
    }

    public ApiResponse<ProjectResponse> getProjectWithHttpInfo(String projectId) throws ApiException {
        Object localVarPostBody = null;
        if (projectId == null) {
            throw new ApiException(400, "Missing the required parameter 'projectId' when calling getProject");
        }
        String localVarPath = "/api/v2/cases/projects/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.getProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectResponse>(){});
    }

    public CompletableFuture<ApiResponse<ProjectResponse>> getProjectWithHttpInfoAsync(String projectId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (projectId == null) {
            CompletableFuture<ApiResponse<ProjectResponse>> result = new CompletableFuture<ApiResponse<ProjectResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'projectId' when calling getProject"));
            return result;
        }
        String localVarPath = "/api/v2/cases/projects/{project_id}".replaceAll("\\{project_id\\}", this.apiClient.escapeString(projectId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.getProject", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ProjectResponse>> result = new CompletableFuture<ApiResponse<ProjectResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectResponse>(){});
    }

    public ProjectsResponse getProjects() throws ApiException {
        return this.getProjectsWithHttpInfo().getData();
    }

    public CompletableFuture<ProjectsResponse> getProjectsAsync() {
        return this.getProjectsWithHttpInfoAsync().thenApply(response -> (ProjectsResponse)response.getData());
    }

    public ApiResponse<ProjectsResponse> getProjectsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/projects";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.getProjects", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ProjectsResponse>> getProjectsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/cases/projects";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.getProjects", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ProjectsResponse>> result = new CompletableFuture<ApiResponse<ProjectsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ProjectsResponse>(){});
    }

    public CasesResponse searchCases() throws ApiException {
        return this.searchCasesWithHttpInfo(new SearchCasesOptionalParameters()).getData();
    }

    public CompletableFuture<CasesResponse> searchCasesAsync() {
        return this.searchCasesWithHttpInfoAsync(new SearchCasesOptionalParameters()).thenApply(response -> (CasesResponse)response.getData());
    }

    public CasesResponse searchCases(SearchCasesOptionalParameters parameters) throws ApiException {
        return this.searchCasesWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CasesResponse> searchCasesAsync(SearchCasesOptionalParameters parameters) {
        return this.searchCasesWithHttpInfoAsync(parameters).thenApply(response -> (CasesResponse)response.getData());
    }

    public PaginationIterable<Case> searchCasesWithPagination() {
        SearchCasesOptionalParameters parameters = new SearchCasesOptionalParameters();
        return this.searchCasesWithPagination(parameters);
    }

    public PaginationIterable<Case> searchCasesWithPagination(SearchCasesOptionalParameters parameters) {
        Long limit;
        String resultsPath = "getData";
        String valueGetterPath = "";
        String valueSetterPath = "pageNumber";
        Boolean valueSetterParamOptional = true;
        parameters.pageNumber(0L);
        if (parameters.pageSize == null) {
            limit = 10L;
            parameters.pageSize(limit);
        } else {
            limit = parameters.pageSize;
        }
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("optionalParams", parameters);
        PaginationIterable<Case> iterator = new PaginationIterable<Case>(this, "searchCases", resultsPath, valueGetterPath, valueSetterPath, valueSetterParamOptional, false, limit, args);
        return iterator;
    }

    public ApiResponse<CasesResponse> searchCasesWithHttpInfo(SearchCasesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        CaseSortableField sortField = parameters.sortField;
        String filter = parameters.filter;
        Boolean sortAsc = parameters.sortAsc;
        String localVarPath = "/api/v2/cases";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort[field]", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort[asc]", sortAsc));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.searchCases", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CasesResponse>(){});
    }

    public CompletableFuture<ApiResponse<CasesResponse>> searchCasesWithHttpInfoAsync(SearchCasesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        CaseSortableField sortField = parameters.sortField;
        String filter = parameters.filter;
        Boolean sortAsc = parameters.sortAsc;
        String localVarPath = "/api/v2/cases";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort[field]", sortField));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort[asc]", sortAsc));
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.searchCases", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CasesResponse>> result = new CompletableFuture<ApiResponse<CasesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CasesResponse>(){});
    }

    public CaseResponse unarchiveCase(String caseId, CaseEmptyRequest body) throws ApiException {
        return this.unarchiveCaseWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> unarchiveCaseAsync(String caseId, CaseEmptyRequest body) {
        return this.unarchiveCaseWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> unarchiveCaseWithHttpInfo(String caseId, CaseEmptyRequest body) throws ApiException {
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling unarchiveCase");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling unarchiveCase");
        }
        String localVarPath = "/api/v2/cases/{case_id}/unarchive".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.unarchiveCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> unarchiveCaseWithHttpInfoAsync(String caseId, CaseEmptyRequest body) {
        Invocation.Builder builder;
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling unarchiveCase"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling unarchiveCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/unarchive".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.unarchiveCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse unassignCase(String caseId, CaseEmptyRequest body) throws ApiException {
        return this.unassignCaseWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> unassignCaseAsync(String caseId, CaseEmptyRequest body) {
        return this.unassignCaseWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> unassignCaseWithHttpInfo(String caseId, CaseEmptyRequest body) throws ApiException {
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling unassignCase");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling unassignCase");
        }
        String localVarPath = "/api/v2/cases/{case_id}/unassign".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.unassignCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> unassignCaseWithHttpInfoAsync(String caseId, CaseEmptyRequest body) {
        Invocation.Builder builder;
        CaseEmptyRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling unassignCase"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling unassignCase"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/unassign".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.unassignCase", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse updateAttributes(String caseId, CaseUpdateAttributesRequest body) throws ApiException {
        return this.updateAttributesWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> updateAttributesAsync(String caseId, CaseUpdateAttributesRequest body) {
        return this.updateAttributesWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> updateAttributesWithHttpInfo(String caseId, CaseUpdateAttributesRequest body) throws ApiException {
        CaseUpdateAttributesRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling updateAttributes");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAttributes");
        }
        String localVarPath = "/api/v2/cases/{case_id}/attributes".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.updateAttributes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> updateAttributesWithHttpInfoAsync(String caseId, CaseUpdateAttributesRequest body) {
        Invocation.Builder builder;
        CaseUpdateAttributesRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling updateAttributes"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAttributes"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/attributes".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.updateAttributes", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse updatePriority(String caseId, CaseUpdatePriorityRequest body) throws ApiException {
        return this.updatePriorityWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> updatePriorityAsync(String caseId, CaseUpdatePriorityRequest body) {
        return this.updatePriorityWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> updatePriorityWithHttpInfo(String caseId, CaseUpdatePriorityRequest body) throws ApiException {
        CaseUpdatePriorityRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling updatePriority");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updatePriority");
        }
        String localVarPath = "/api/v2/cases/{case_id}/priority".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.updatePriority", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> updatePriorityWithHttpInfoAsync(String caseId, CaseUpdatePriorityRequest body) {
        Invocation.Builder builder;
        CaseUpdatePriorityRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling updatePriority"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updatePriority"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/priority".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.updatePriority", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CaseResponse updateStatus(String caseId, CaseUpdateStatusRequest body) throws ApiException {
        return this.updateStatusWithHttpInfo(caseId, body).getData();
    }

    public CompletableFuture<CaseResponse> updateStatusAsync(String caseId, CaseUpdateStatusRequest body) {
        return this.updateStatusWithHttpInfoAsync(caseId, body).thenApply(response -> (CaseResponse)response.getData());
    }

    public ApiResponse<CaseResponse> updateStatusWithHttpInfo(String caseId, CaseUpdateStatusRequest body) throws ApiException {
        CaseUpdateStatusRequest localVarPostBody = body;
        if (caseId == null) {
            throw new ApiException(400, "Missing the required parameter 'caseId' when calling updateStatus");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateStatus");
        }
        String localVarPath = "/api/v2/cases/{case_id}/status".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.CaseManagementApi.updateStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public CompletableFuture<ApiResponse<CaseResponse>> updateStatusWithHttpInfoAsync(String caseId, CaseUpdateStatusRequest body) {
        Invocation.Builder builder;
        CaseUpdateStatusRequest localVarPostBody = body;
        if (caseId == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'caseId' when calling updateStatus"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateStatus"));
            return result;
        }
        String localVarPath = "/api/v2/cases/{case_id}/status".replaceAll("\\{case_id\\}", this.apiClient.escapeString(caseId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.CaseManagementApi.updateStatus", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CaseResponse>> result = new CompletableFuture<ApiResponse<CaseResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<CaseResponse>(){});
    }

    public static class SearchCasesOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private CaseSortableField sortField;
        private String filter;
        private Boolean sortAsc;

        public SearchCasesOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public SearchCasesOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public SearchCasesOptionalParameters sortField(CaseSortableField sortField) {
            this.sortField = sortField;
            return this;
        }

        public SearchCasesOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }

        public SearchCasesOptionalParameters sortAsc(Boolean sortAsc) {
            this.sortAsc = sortAsc;
            return this;
        }
    }
}

