/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AwsOnDemandCreateRequest;
import com.datadog.api.client.v2.model.AwsOnDemandListResponse;
import com.datadog.api.client.v2.model.AwsOnDemandResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsCreateRequest;
import com.datadog.api.client.v2.model.AwsScanOptionsListResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsResponse;
import com.datadog.api.client.v2.model.AwsScanOptionsUpdateRequest;
import com.datadoghq.jakarta.ws.rs.client.Invocation;
import com.datadoghq.jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class AgentlessScanningApi {
    private ApiClient apiClient;

    public AgentlessScanningApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AgentlessScanningApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AwsOnDemandResponse createAwsOnDemandTask(AwsOnDemandCreateRequest body) throws ApiException {
        return this.createAwsOnDemandTaskWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsOnDemandResponse> createAwsOnDemandTaskAsync(AwsOnDemandCreateRequest body) {
        return this.createAwsOnDemandTaskWithHttpInfoAsync(body).thenApply(response -> (AwsOnDemandResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandResponse> createAwsOnDemandTaskWithHttpInfo(AwsOnDemandCreateRequest body) throws ApiException {
        AwsOnDemandCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAwsOnDemandTask");
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandResponse>> createAwsOnDemandTaskWithHttpInfoAsync(AwsOnDemandCreateRequest body) {
        Invocation.Builder builder;
        AwsOnDemandCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAwsOnDemandTask"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public AwsScanOptionsResponse createAwsScanOptions(AwsScanOptionsCreateRequest body) throws ApiException {
        return this.createAwsScanOptionsWithHttpInfo(body).getData();
    }

    public CompletableFuture<AwsScanOptionsResponse> createAwsScanOptionsAsync(AwsScanOptionsCreateRequest body) {
        return this.createAwsScanOptionsWithHttpInfoAsync(body).thenApply(response -> (AwsScanOptionsResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsResponse> createAwsScanOptionsWithHttpInfo(AwsScanOptionsCreateRequest body) throws ApiException {
        AwsScanOptionsCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsResponse>> createAwsScanOptionsWithHttpInfoAsync(AwsScanOptionsCreateRequest body) {
        Invocation.Builder builder;
        AwsScanOptionsCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.createAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public void deleteAwsScanOptions(String accountId) throws ApiException {
        this.deleteAwsScanOptionsWithHttpInfo(accountId);
    }

    public CompletableFuture<Void> deleteAwsScanOptionsAsync(String accountId) {
        return this.deleteAwsScanOptionsWithHttpInfoAsync(accountId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAwsScanOptionsWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAwsScanOptionsWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling deleteAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.deleteAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AwsOnDemandResponse getAwsOnDemandTask(String taskId) throws ApiException {
        return this.getAwsOnDemandTaskWithHttpInfo(taskId).getData();
    }

    public CompletableFuture<AwsOnDemandResponse> getAwsOnDemandTaskAsync(String taskId) {
        return this.getAwsOnDemandTaskWithHttpInfoAsync(taskId).thenApply(response -> (AwsOnDemandResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandResponse> getAwsOnDemandTaskWithHttpInfo(String taskId) throws ApiException {
        Object localVarPostBody = null;
        if (taskId == null) {
            throw new ApiException(400, "Missing the required parameter 'taskId' when calling getAwsOnDemandTask");
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws/{task_id}".replaceAll("\\{task_id\\}", this.apiClient.escapeString(taskId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandResponse>> getAwsOnDemandTaskWithHttpInfoAsync(String taskId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (taskId == null) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'taskId' when calling getAwsOnDemandTask"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws/{task_id}".replaceAll("\\{task_id\\}", this.apiClient.escapeString(taskId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsOnDemandTask", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandResponse>(){});
    }

    public AwsScanOptionsResponse getAwsScanOptions(String accountId) throws ApiException {
        return this.getAwsScanOptionsWithHttpInfo(accountId).getData();
    }

    public CompletableFuture<AwsScanOptionsResponse> getAwsScanOptionsAsync(String accountId) {
        return this.getAwsScanOptionsWithHttpInfoAsync(accountId).thenApply(response -> (AwsScanOptionsResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsResponse> getAwsScanOptionsWithHttpInfo(String accountId) throws ApiException {
        Object localVarPostBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsResponse>> getAwsScanOptionsWithHttpInfoAsync(String accountId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (accountId == null) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling getAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.getAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsResponse>(){});
    }

    public AwsOnDemandListResponse listAwsOnDemandTasks() throws ApiException {
        return this.listAwsOnDemandTasksWithHttpInfo().getData();
    }

    public CompletableFuture<AwsOnDemandListResponse> listAwsOnDemandTasksAsync() {
        return this.listAwsOnDemandTasksWithHttpInfoAsync().thenApply(response -> (AwsOnDemandListResponse)response.getData());
    }

    public ApiResponse<AwsOnDemandListResponse> listAwsOnDemandTasksWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsOnDemandTasks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandListResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsOnDemandListResponse>> listAwsOnDemandTasksWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/ondemand/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsOnDemandTasks", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsOnDemandListResponse>> result = new CompletableFuture<ApiResponse<AwsOnDemandListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsOnDemandListResponse>(){});
    }

    public AwsScanOptionsListResponse listAwsScanOptions() throws ApiException {
        return this.listAwsScanOptionsWithHttpInfo().getData();
    }

    public CompletableFuture<AwsScanOptionsListResponse> listAwsScanOptionsAsync() {
        return this.listAwsScanOptionsWithHttpInfoAsync().thenApply(response -> (AwsScanOptionsListResponse)response.getData());
    }

    public ApiResponse<AwsScanOptionsListResponse> listAwsScanOptionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<AwsScanOptionsListResponse>> listAwsScanOptionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.listAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AwsScanOptionsListResponse>> result = new CompletableFuture<ApiResponse<AwsScanOptionsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AwsScanOptionsListResponse>(){});
    }

    public void updateAwsScanOptions(String accountId, AwsScanOptionsUpdateRequest body) throws ApiException {
        this.updateAwsScanOptionsWithHttpInfo(accountId, body);
    }

    public CompletableFuture<Void> updateAwsScanOptionsAsync(String accountId, AwsScanOptionsUpdateRequest body) {
        return this.updateAwsScanOptionsWithHttpInfoAsync(accountId, body).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> updateAwsScanOptionsWithHttpInfo(String accountId, AwsScanOptionsUpdateRequest body) throws ApiException {
        AwsScanOptionsUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updateAwsScanOptions");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAwsScanOptions");
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> updateAwsScanOptionsWithHttpInfoAsync(String accountId, AwsScanOptionsUpdateRequest body) {
        Invocation.Builder builder;
        AwsScanOptionsUpdateRequest localVarPostBody = body;
        if (accountId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'accountId' when calling updateAwsScanOptions"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAwsScanOptions"));
            return result;
        }
        String localVarPath = "/api/v2/agentless_scanning/accounts/aws/{account_id}".replaceAll("\\{account_id\\}", this.apiClient.escapeString(accountId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AgentlessScanningApi.updateAwsScanOptions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, null);
    }
}

