/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.WidgetFieldSort;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonCreator;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"limit", "query_string", "sort"})
public class SLOListWidgetQuery {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Long limit = 100L;
    public static final String JSON_PROPERTY_QUERY_STRING = "query_string";
    private String queryString;
    public static final String JSON_PROPERTY_SORT = "sort";
    private List<WidgetFieldSort> sort = null;
    private Map<String, Object> additionalProperties;

    public SLOListWidgetQuery() {
    }

    @JsonCreator
    public SLOListWidgetQuery(@JsonProperty(required=true, value="query_string") String queryString) {
        this.queryString = queryString;
    }

    public SLOListWidgetQuery limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getLimit() {
        return this.limit;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public SLOListWidgetQuery queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    @JsonProperty(value="query_string")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public SLOListWidgetQuery sort(List<WidgetFieldSort> sort) {
        this.sort = sort;
        for (WidgetFieldSort item : sort) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SLOListWidgetQuery addSortItem(WidgetFieldSort sortItem) {
        if (this.sort == null) {
            this.sort = new ArrayList<WidgetFieldSort>();
        }
        this.sort.add(sortItem);
        this.unparsed |= sortItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="sort")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<WidgetFieldSort> getSort() {
        return this.sort;
    }

    public void setSort(List<WidgetFieldSort> sort) {
        this.sort = sort;
    }

    @JsonAnySetter
    public SLOListWidgetQuery putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SLOListWidgetQuery sloListWidgetQuery = (SLOListWidgetQuery)o;
        return Objects.equals(this.limit, sloListWidgetQuery.limit) && Objects.equals(this.queryString, sloListWidgetQuery.queryString) && Objects.equals(this.sort, sloListWidgetQuery.sort) && Objects.equals(this.additionalProperties, sloListWidgetQuery.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.queryString, this.sort, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SLOListWidgetQuery {\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    queryString: ").append(this.toIndentedString(this.queryString)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

