/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.AWSLogsLambda;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonIgnore;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonInclude;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonProperty;
import com.datadoghq.com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.datadoghq.jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"account_id", "lambdas", "services"})
public class AWSLogsListResponse {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACCOUNT_ID = "account_id";
    private String accountId;
    public static final String JSON_PROPERTY_LAMBDAS = "lambdas";
    private List<AWSLogsLambda> lambdas = null;
    public static final String JSON_PROPERTY_SERVICES = "services";
    private List<String> services = null;
    private Map<String, Object> additionalProperties;

    public AWSLogsListResponse accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AWSLogsListResponse lambdas(List<AWSLogsLambda> lambdas) {
        this.lambdas = lambdas;
        for (AWSLogsLambda item : lambdas) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public AWSLogsListResponse addLambdasItem(AWSLogsLambda lambdasItem) {
        if (this.lambdas == null) {
            this.lambdas = new ArrayList<AWSLogsLambda>();
        }
        this.lambdas.add(lambdasItem);
        this.unparsed |= lambdasItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="lambdas")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AWSLogsLambda> getLambdas() {
        return this.lambdas;
    }

    public void setLambdas(List<AWSLogsLambda> lambdas) {
        this.lambdas = lambdas;
    }

    public AWSLogsListResponse services(List<String> services) {
        this.services = services;
        return this;
    }

    public AWSLogsListResponse addServicesItem(String servicesItem) {
        if (this.services == null) {
            this.services = new ArrayList<String>();
        }
        this.services.add(servicesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="services")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getServices() {
        return this.services;
    }

    public void setServices(List<String> services) {
        this.services = services;
    }

    @JsonAnySetter
    public AWSLogsListResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSLogsListResponse awsLogsListResponse = (AWSLogsListResponse)o;
        return Objects.equals(this.accountId, awsLogsListResponse.accountId) && Objects.equals(this.lambdas, awsLogsListResponse.lambdas) && Objects.equals(this.services, awsLogsListResponse.services) && Objects.equals(this.additionalProperties, awsLogsListResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.lambdas, this.services, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSLogsListResponse {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    lambdas: ").append(this.toIndentedString(this.lambdas)).append("\n");
        sb.append("    services: ").append(this.toIndentedString(this.services)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

