/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ConfigCatSDKKeyType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"api_password", "api_username", "sdk_key", "type"})
public class ConfigCatSDKKeyUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_API_PASSWORD = "api_password";
    private String apiPassword;
    public static final String JSON_PROPERTY_API_USERNAME = "api_username";
    private String apiUsername;
    public static final String JSON_PROPERTY_SDK_KEY = "sdk_key";
    private String sdkKey;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ConfigCatSDKKeyType type;
    private Map<String, Object> additionalProperties;

    public ConfigCatSDKKeyUpdate() {
    }

    @JsonCreator
    public ConfigCatSDKKeyUpdate(@JsonProperty(required=true, value="type") ConfigCatSDKKeyType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ConfigCatSDKKeyUpdate apiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
        return this;
    }

    @Nullable
    @JsonProperty(value="api_password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiPassword() {
        return this.apiPassword;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
    }

    public ConfigCatSDKKeyUpdate apiUsername(String apiUsername) {
        this.apiUsername = apiUsername;
        return this;
    }

    @Nullable
    @JsonProperty(value="api_username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getApiUsername() {
        return this.apiUsername;
    }

    public void setApiUsername(String apiUsername) {
        this.apiUsername = apiUsername;
    }

    public ConfigCatSDKKeyUpdate sdkKey(String sdkKey) {
        this.sdkKey = sdkKey;
        return this;
    }

    @Nullable
    @JsonProperty(value="sdk_key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSdkKey() {
        return this.sdkKey;
    }

    public void setSdkKey(String sdkKey) {
        this.sdkKey = sdkKey;
    }

    public ConfigCatSDKKeyUpdate type(ConfigCatSDKKeyType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ConfigCatSDKKeyType getType() {
        return this.type;
    }

    public void setType(ConfigCatSDKKeyType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ConfigCatSDKKeyUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigCatSDKKeyUpdate configCatSdkKeyUpdate = (ConfigCatSDKKeyUpdate)o;
        return Objects.equals(this.apiPassword, configCatSdkKeyUpdate.apiPassword) && Objects.equals(this.apiUsername, configCatSdkKeyUpdate.apiUsername) && Objects.equals(this.sdkKey, configCatSdkKeyUpdate.sdkKey) && Objects.equals(this.type, configCatSdkKeyUpdate.type) && Objects.equals(this.additionalProperties, configCatSdkKeyUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiPassword, this.apiUsername, this.sdkKey, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConfigCatSDKKeyUpdate {\n");
        sb.append("    apiPassword: ").append(this.toIndentedString(this.apiPassword)).append("\n");
        sb.append("    apiUsername: ").append(this.toIndentedString(this.apiUsername)).append("\n");
        sb.append("    sdkKey: ").append(this.toIndentedString(this.sdkKey)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

