/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"name", "scopes"})
public class ApplicationKeyCreateAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private JsonNullable<List<String>> scopes = JsonNullable.undefined();
    private Map<String, Object> additionalProperties;

    public ApplicationKeyCreateAttributes() {
    }

    @JsonCreator
    public ApplicationKeyCreateAttributes(@JsonProperty(required=true, value="name") String name) {
        this.name = name;
    }

    public ApplicationKeyCreateAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApplicationKeyCreateAttributes scopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
        return this;
    }

    public ApplicationKeyCreateAttributes addScopesItem(String scopesItem) {
        if (this.scopes == null || !this.scopes.isPresent()) {
            this.scopes = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.scopes.get()).add(scopesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getScopes() {
        return (List)this.scopes.orElse(null);
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getScopes_JsonNullable() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    public void setScopes_JsonNullable(JsonNullable<List<String>> scopes) {
        this.scopes = scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = JsonNullable.of(scopes);
    }

    @JsonAnySetter
    public ApplicationKeyCreateAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationKeyCreateAttributes applicationKeyCreateAttributes = (ApplicationKeyCreateAttributes)o;
        return Objects.equals(this.name, applicationKeyCreateAttributes.name) && Objects.equals(this.scopes, applicationKeyCreateAttributes.scopes) && Objects.equals(this.additionalProperties, applicationKeyCreateAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.scopes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationKeyCreateAttributes {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

