/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AWSAccountResponseAttributes;
import com.datadog.api.client.v2.model.AWSAccountType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"attributes", "id", "type"})
public class AWSAccountResponseData {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ATTRIBUTES = "attributes";
    private AWSAccountResponseAttributes attributes;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AWSAccountType type = AWSAccountType.ACCOUNT;
    private Map<String, Object> additionalProperties;

    public AWSAccountResponseData() {
    }

    @JsonCreator
    public AWSAccountResponseData(@JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="type") AWSAccountType type) {
        this.id = id;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AWSAccountResponseData attributes(AWSAccountResponseAttributes attributes) {
        this.attributes = attributes;
        this.unparsed |= attributes.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AWSAccountResponseAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AWSAccountResponseAttributes attributes) {
        this.attributes = attributes;
    }

    public AWSAccountResponseData id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AWSAccountResponseData type(AWSAccountType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AWSAccountType getType() {
        return this.type;
    }

    public void setType(AWSAccountType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AWSAccountResponseData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSAccountResponseData awsAccountResponseData = (AWSAccountResponseData)o;
        return Objects.equals(this.attributes, awsAccountResponseData.attributes) && Objects.equals(this.id, awsAccountResponseData.id) && Objects.equals(this.type, awsAccountResponseData.type) && Objects.equals(this.additionalProperties, awsAccountResponseData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.id, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AWSAccountResponseData {\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

