/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBatchStatus;
import com.datadog.api.client.v1.model.SyntheticsTestDetailsType;
import com.datadog.api.client.v1.model.SyntheticsTestExecutionRule;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"device", "duration", "execution_rule", "location", "result_id", "retries", "status", "test_name", "test_public_id", "test_type"})
public class SyntheticsBatchResult {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DEVICE = "device";
    private String device;
    public static final String JSON_PROPERTY_DURATION = "duration";
    private Double duration;
    public static final String JSON_PROPERTY_EXECUTION_RULE = "execution_rule";
    private SyntheticsTestExecutionRule executionRule;
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location;
    public static final String JSON_PROPERTY_RESULT_ID = "result_id";
    private String resultId;
    public static final String JSON_PROPERTY_RETRIES = "retries";
    private Double retries;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SyntheticsBatchStatus status;
    public static final String JSON_PROPERTY_TEST_NAME = "test_name";
    private String testName;
    public static final String JSON_PROPERTY_TEST_PUBLIC_ID = "test_public_id";
    private String testPublicId;
    public static final String JSON_PROPERTY_TEST_TYPE = "test_type";
    private SyntheticsTestDetailsType testType;
    private Map<String, Object> additionalProperties;

    public SyntheticsBatchResult device(String device) {
        this.device = device;
        return this;
    }

    @Nullable
    @JsonProperty(value="device")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDevice() {
        return this.device;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public SyntheticsBatchResult duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @JsonProperty(value="duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public SyntheticsBatchResult executionRule(SyntheticsTestExecutionRule executionRule) {
        this.executionRule = executionRule;
        this.unparsed |= !executionRule.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="execution_rule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestExecutionRule getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(SyntheticsTestExecutionRule executionRule) {
        if (!executionRule.isValid()) {
            this.unparsed = true;
        }
        this.executionRule = executionRule;
    }

    public SyntheticsBatchResult location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public SyntheticsBatchResult resultId(String resultId) {
        this.resultId = resultId;
        return this;
    }

    @Nullable
    @JsonProperty(value="result_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getResultId() {
        return this.resultId;
    }

    public void setResultId(String resultId) {
        this.resultId = resultId;
    }

    public SyntheticsBatchResult retries(Double retries) {
        this.retries = retries;
        return this;
    }

    @Nullable
    @JsonProperty(value="retries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Double getRetries() {
        return this.retries;
    }

    public void setRetries(Double retries) {
        this.retries = retries;
    }

    public SyntheticsBatchResult status(SyntheticsBatchStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsBatchStatus getStatus() {
        return this.status;
    }

    public void setStatus(SyntheticsBatchStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public SyntheticsBatchResult testName(String testName) {
        this.testName = testName;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public SyntheticsBatchResult testPublicId(String testPublicId) {
        this.testPublicId = testPublicId;
        return this;
    }

    @Nullable
    @JsonProperty(value="test_public_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTestPublicId() {
        return this.testPublicId;
    }

    public void setTestPublicId(String testPublicId) {
        this.testPublicId = testPublicId;
    }

    public SyntheticsBatchResult testType(SyntheticsTestDetailsType testType) {
        this.testType = testType;
        this.unparsed |= !testType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="test_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SyntheticsTestDetailsType getTestType() {
        return this.testType;
    }

    public void setTestType(SyntheticsTestDetailsType testType) {
        if (!testType.isValid()) {
            this.unparsed = true;
        }
        this.testType = testType;
    }

    @JsonAnySetter
    public SyntheticsBatchResult putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBatchResult syntheticsBatchResult = (SyntheticsBatchResult)o;
        return Objects.equals(this.device, syntheticsBatchResult.device) && Objects.equals(this.duration, syntheticsBatchResult.duration) && Objects.equals(this.executionRule, syntheticsBatchResult.executionRule) && Objects.equals(this.location, syntheticsBatchResult.location) && Objects.equals(this.resultId, syntheticsBatchResult.resultId) && Objects.equals(this.retries, syntheticsBatchResult.retries) && Objects.equals(this.status, syntheticsBatchResult.status) && Objects.equals(this.testName, syntheticsBatchResult.testName) && Objects.equals(this.testPublicId, syntheticsBatchResult.testPublicId) && Objects.equals(this.testType, syntheticsBatchResult.testType) && Objects.equals(this.additionalProperties, syntheticsBatchResult.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.device, this.duration, this.executionRule, this.location, this.resultId, this.retries, this.status, this.testName, this.testPublicId, this.testType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBatchResult {\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    executionRule: ").append(this.toIndentedString(this.executionRule)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    resultId: ").append(this.toIndentedString(this.resultId)).append("\n");
        sb.append("    retries: ").append(this.toIndentedString(this.retries)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    testName: ").append(this.toIndentedString(this.testName)).append("\n");
        sb.append("    testPublicId: ").append(this.toIndentedString(this.testPublicId)).append("\n");
        sb.append("    testType: ").append(this.toIndentedString(this.testType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

