/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AWSAccountCreateRequest;
import com.datadog.api.client.v2.model.AWSAccountResponse;
import com.datadog.api.client.v2.model.AWSAccountUpdateRequest;
import com.datadog.api.client.v2.model.AWSAccountsResponse;
import com.datadog.api.client.v2.model.AWSIntegrationIamPermissionsResponse;
import com.datadog.api.client.v2.model.AWSNamespacesResponse;
import com.datadog.api.client.v2.model.AWSNewExternalIDResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class AwsIntegrationApi {
    private ApiClient apiClient;

    public AwsIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AwsIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AWSAccountResponse createAWSAccount(AWSAccountCreateRequest body) throws ApiException {
        return this.createAWSAccountWithHttpInfo(body).getData();
    }

    public CompletableFuture<AWSAccountResponse> createAWSAccountAsync(AWSAccountCreateRequest body) {
        return this.createAWSAccountWithHttpInfoAsync(body).thenApply(response -> (AWSAccountResponse)response.getData());
    }

    public ApiResponse<AWSAccountResponse> createAWSAccountWithHttpInfo(AWSAccountCreateRequest body) throws ApiException {
        String operationId = "createAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        AWSAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAWSAccount");
        }
        String localVarPath = "/api/v2/integration/aws/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.createAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSAccountResponse>> createAWSAccountWithHttpInfoAsync(AWSAccountCreateRequest body) {
        Invocation.Builder builder;
        String operationId = "createAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        AWSAccountCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAWSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/aws/accounts";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.createAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public AWSNewExternalIDResponse createNewAWSExternalID() throws ApiException {
        return this.createNewAWSExternalIDWithHttpInfo().getData();
    }

    public CompletableFuture<AWSNewExternalIDResponse> createNewAWSExternalIDAsync() {
        return this.createNewAWSExternalIDWithHttpInfoAsync().thenApply(response -> (AWSNewExternalIDResponse)response.getData());
    }

    public ApiResponse<AWSNewExternalIDResponse> createNewAWSExternalIDWithHttpInfo() throws ApiException {
        String operationId = "createNewAWSExternalID";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/generate_new_external_id";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.createNewAWSExternalID", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSNewExternalIDResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSNewExternalIDResponse>> createNewAWSExternalIDWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "createNewAWSExternalID";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSNewExternalIDResponse>> result = new CompletableFuture<ApiResponse<AWSNewExternalIDResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/generate_new_external_id";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.createNewAWSExternalID", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSNewExternalIDResponse>> result = new CompletableFuture<ApiResponse<AWSNewExternalIDResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSNewExternalIDResponse>(){});
    }

    public void deleteAWSAccount(String awsAccountConfigId) throws ApiException {
        this.deleteAWSAccountWithHttpInfo(awsAccountConfigId);
    }

    public CompletableFuture<Void> deleteAWSAccountAsync(String awsAccountConfigId) {
        return this.deleteAWSAccountWithHttpInfoAsync(awsAccountConfigId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAWSAccountWithHttpInfo(String awsAccountConfigId) throws ApiException {
        String operationId = "deleteAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (awsAccountConfigId == null) {
            throw new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling deleteAWSAccount");
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.deleteAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAWSAccountWithHttpInfoAsync(String awsAccountConfigId) {
        Invocation.Builder builder;
        String operationId = "deleteAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (awsAccountConfigId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling deleteAWSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.deleteAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AWSAccountResponse getAWSAccount(String awsAccountConfigId) throws ApiException {
        return this.getAWSAccountWithHttpInfo(awsAccountConfigId).getData();
    }

    public CompletableFuture<AWSAccountResponse> getAWSAccountAsync(String awsAccountConfigId) {
        return this.getAWSAccountWithHttpInfoAsync(awsAccountConfigId).thenApply(response -> (AWSAccountResponse)response.getData());
    }

    public ApiResponse<AWSAccountResponse> getAWSAccountWithHttpInfo(String awsAccountConfigId) throws ApiException {
        String operationId = "getAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (awsAccountConfigId == null) {
            throw new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling getAWSAccount");
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.getAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSAccountResponse>> getAWSAccountWithHttpInfoAsync(String awsAccountConfigId) {
        Invocation.Builder builder;
        String operationId = "getAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (awsAccountConfigId == null) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling getAWSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.getAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public AWSIntegrationIamPermissionsResponse getAWSIntegrationIAMPermissions() throws ApiException {
        return this.getAWSIntegrationIAMPermissionsWithHttpInfo().getData();
    }

    public CompletableFuture<AWSIntegrationIamPermissionsResponse> getAWSIntegrationIAMPermissionsAsync() {
        return this.getAWSIntegrationIAMPermissionsWithHttpInfoAsync().thenApply(response -> (AWSIntegrationIamPermissionsResponse)response.getData());
    }

    public ApiResponse<AWSIntegrationIamPermissionsResponse> getAWSIntegrationIAMPermissionsWithHttpInfo() throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/iam_permissions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.getAWSIntegrationIAMPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSIntegrationIamPermissionsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSIntegrationIamPermissionsResponse>> getAWSIntegrationIAMPermissionsWithHttpInfoAsync() {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/iam_permissions";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.getAWSIntegrationIAMPermissions", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSIntegrationIamPermissionsResponse>> result = new CompletableFuture<ApiResponse<AWSIntegrationIamPermissionsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSIntegrationIamPermissionsResponse>(){});
    }

    public AWSAccountsResponse listAWSAccounts() throws ApiException {
        return this.listAWSAccountsWithHttpInfo(new ListAWSAccountsOptionalParameters()).getData();
    }

    public CompletableFuture<AWSAccountsResponse> listAWSAccountsAsync() {
        return this.listAWSAccountsWithHttpInfoAsync(new ListAWSAccountsOptionalParameters()).thenApply(response -> (AWSAccountsResponse)response.getData());
    }

    public AWSAccountsResponse listAWSAccounts(ListAWSAccountsOptionalParameters parameters) throws ApiException {
        return this.listAWSAccountsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<AWSAccountsResponse> listAWSAccountsAsync(ListAWSAccountsOptionalParameters parameters) {
        return this.listAWSAccountsWithHttpInfoAsync(parameters).thenApply(response -> (AWSAccountsResponse)response.getData());
    }

    public ApiResponse<AWSAccountsResponse> listAWSAccountsWithHttpInfo(ListAWSAccountsOptionalParameters parameters) throws ApiException {
        String operationId = "listAWSAccounts";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String awsAccountId = parameters.awsAccountId;
        String localVarPath = "/api/v2/integration/aws/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aws_account_id", awsAccountId));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.listAWSAccounts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSAccountsResponse>> listAWSAccountsWithHttpInfoAsync(ListAWSAccountsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listAWSAccounts";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSAccountsResponse>> result = new CompletableFuture<ApiResponse<AWSAccountsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String awsAccountId = parameters.awsAccountId;
        String localVarPath = "/api/v2/integration/aws/accounts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "aws_account_id", awsAccountId));
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.listAWSAccounts", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSAccountsResponse>> result = new CompletableFuture<ApiResponse<AWSAccountsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountsResponse>(){});
    }

    public AWSNamespacesResponse listAWSNamespaces() throws ApiException {
        return this.listAWSNamespacesWithHttpInfo().getData();
    }

    public CompletableFuture<AWSNamespacesResponse> listAWSNamespacesAsync() {
        return this.listAWSNamespacesWithHttpInfoAsync().thenApply(response -> (AWSNamespacesResponse)response.getData());
    }

    public ApiResponse<AWSNamespacesResponse> listAWSNamespacesWithHttpInfo() throws ApiException {
        String operationId = "listAWSNamespaces";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/available_namespaces";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.listAWSNamespaces", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSNamespacesResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSNamespacesResponse>> listAWSNamespacesWithHttpInfoAsync() {
        Invocation.Builder builder;
        String operationId = "listAWSNamespaces";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSNamespacesResponse>> result = new CompletableFuture<ApiResponse<AWSNamespacesResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/integration/aws/available_namespaces";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.listAWSNamespaces", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSNamespacesResponse>> result = new CompletableFuture<ApiResponse<AWSNamespacesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSNamespacesResponse>(){});
    }

    public AWSAccountResponse updateAWSAccount(String awsAccountConfigId, AWSAccountUpdateRequest body) throws ApiException {
        return this.updateAWSAccountWithHttpInfo(awsAccountConfigId, body).getData();
    }

    public CompletableFuture<AWSAccountResponse> updateAWSAccountAsync(String awsAccountConfigId, AWSAccountUpdateRequest body) {
        return this.updateAWSAccountWithHttpInfoAsync(awsAccountConfigId, body).thenApply(response -> (AWSAccountResponse)response.getData());
    }

    public ApiResponse<AWSAccountResponse> updateAWSAccountWithHttpInfo(String awsAccountConfigId, AWSAccountUpdateRequest body) throws ApiException {
        String operationId = "updateAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        AWSAccountUpdateRequest localVarPostBody = body;
        if (awsAccountConfigId == null) {
            throw new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling updateAWSAccount");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAWSAccount");
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.updateAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public CompletableFuture<ApiResponse<AWSAccountResponse>> updateAWSAccountWithHttpInfoAsync(String awsAccountConfigId, AWSAccountUpdateRequest body) {
        Invocation.Builder builder;
        String operationId = "updateAWSAccount";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        AWSAccountUpdateRequest localVarPostBody = body;
        if (awsAccountConfigId == null) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'awsAccountConfigId' when calling updateAWSAccount"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAWSAccount"));
            return result;
        }
        String localVarPath = "/api/v2/integration/aws/accounts/{aws_account_config_id}".replaceAll("\\{aws_account_config_id\\}", this.apiClient.escapeString(awsAccountConfigId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AwsIntegrationApi.updateAWSAccount", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AWSAccountResponse>> result = new CompletableFuture<ApiResponse<AWSAccountResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AWSAccountResponse>(){});
    }

    public static class ListAWSAccountsOptionalParameters {
        private String awsAccountId;

        public ListAWSAccountsOptionalParameters awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }
    }
}

