/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ServiceCheckStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"check", "host_name", "message", "status", "tags", "timestamp"})
public class ServiceCheck {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CHECK = "check";
    private String check;
    public static final String JSON_PROPERTY_HOST_NAME = "host_name";
    private String hostName;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ServiceCheckStatus status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = new ArrayList<String>();
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Long timestamp;
    private Map<String, Object> additionalProperties;

    public ServiceCheck() {
    }

    @JsonCreator
    public ServiceCheck(@JsonProperty(required=true, value="check") String check, @JsonProperty(required=true, value="host_name") String hostName, @JsonProperty(required=true, value="status") ServiceCheckStatus status, @JsonProperty(required=true, value="tags") List<String> tags) {
        this.check = check;
        this.hostName = hostName;
        this.status = status;
        this.unparsed |= !status.isValid();
        this.tags = tags;
    }

    public ServiceCheck check(String check) {
        this.check = check;
        return this;
    }

    @JsonProperty(value="check")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public ServiceCheck hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @JsonProperty(value="host_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public ServiceCheck message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ServiceCheck status(ServiceCheckStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceCheckStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServiceCheckStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public ServiceCheck tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public ServiceCheck addTagsItem(String tagsItem) {
        this.tags.add(tagsItem);
        return this;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ServiceCheck timestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @JsonAnySetter
    public ServiceCheck putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceCheck serviceCheck = (ServiceCheck)o;
        return Objects.equals(this.check, serviceCheck.check) && Objects.equals(this.hostName, serviceCheck.hostName) && Objects.equals(this.message, serviceCheck.message) && Objects.equals(this.status, serviceCheck.status) && Objects.equals(this.tags, serviceCheck.tags) && Objects.equals(this.timestamp, serviceCheck.timestamp) && Objects.equals(this.additionalProperties, serviceCheck.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.check, this.hostName, this.message, this.status, this.tags, this.timestamp, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceCheck {\n");
        sb.append("    check: ").append(this.toIndentedString(this.check)).append("\n");
        sb.append("    hostName: ").append(this.toIndentedString(this.hostName)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

