/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.ContentEncoding;
import com.datadog.api.client.v1.model.HTTPLogItem;
import com.datadog.api.client.v1.model.LogsListRequest;
import com.datadog.api.client.v1.model.LogsListResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class LogsApi {
    private ApiClient apiClient;

    public LogsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public LogsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogsListResponse listLogs(LogsListRequest body) throws ApiException {
        return this.listLogsWithHttpInfo(body).getData();
    }

    public CompletableFuture<LogsListResponse> listLogsAsync(LogsListRequest body) {
        return this.listLogsWithHttpInfoAsync(body).thenApply(response -> (LogsListResponse)response.getData());
    }

    public ApiResponse<LogsListResponse> listLogsWithHttpInfo(LogsListRequest body) throws ApiException {
        LogsListRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling listLogs");
        }
        String localVarPath = "/api/v1/logs-queries/list";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsApi.listLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    public CompletableFuture<ApiResponse<LogsListResponse>> listLogsWithHttpInfoAsync(LogsListRequest body) {
        Invocation.Builder builder;
        LogsListRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<LogsListResponse>> result = new CompletableFuture<ApiResponse<LogsListResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling listLogs"));
            return result;
        }
        String localVarPath = "/api/v1/logs-queries/list";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.LogsApi.listLogs", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<LogsListResponse>> result = new CompletableFuture<ApiResponse<LogsListResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<LogsListResponse>(){});
    }

    @Deprecated
    public Object submitLog(List<HTTPLogItem> body) throws ApiException {
        return this.submitLogWithHttpInfo(body, new SubmitLogOptionalParameters()).getData();
    }

    @Deprecated
    public CompletableFuture<Object> submitLogAsync(List<HTTPLogItem> body) {
        return this.submitLogWithHttpInfoAsync(body, new SubmitLogOptionalParameters()).thenApply(response -> response.getData());
    }

    @Deprecated
    public Object submitLog(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        return this.submitLogWithHttpInfo(body, parameters).getData();
    }

    @Deprecated
    public CompletableFuture<Object> submitLogAsync(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) {
        return this.submitLogWithHttpInfoAsync(body, parameters).thenApply(response -> response.getData());
    }

    @Deprecated
    public ApiResponse<Object> submitLogWithHttpInfo(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) throws ApiException {
        List<HTTPLogItem> localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling submitLog");
        }
        ContentEncoding contentEncoding = parameters.contentEncoding;
        String ddtags = parameters.ddtags;
        String localVarPath = "/v1/input";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddtags", ddtags));
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v1.LogsApi.submitLog", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json", "application/json;simple", "application/logplex-1", "text/plain"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    @Deprecated
    public CompletableFuture<ApiResponse<Object>> submitLogWithHttpInfoAsync(List<HTTPLogItem> body, SubmitLogOptionalParameters parameters) {
        Invocation.Builder builder;
        List<HTTPLogItem> localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling submitLog"));
            return result;
        }
        ContentEncoding contentEncoding = parameters.contentEncoding;
        String ddtags = parameters.ddtags;
        String localVarPath = "/v1/input";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "ddtags", ddtags));
        if (contentEncoding != null) {
            localVarHeaderParams.put("Content-Encoding", this.apiClient.parameterToString(contentEncoding));
        }
        try {
            builder = this.apiClient.createBuilder("v1.LogsApi.submitLog", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Object>> result = new CompletableFuture<ApiResponse<Object>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json", "application/json;simple", "application/logplex-1", "text/plain"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Object>(){});
    }

    public static class SubmitLogOptionalParameters {
        private ContentEncoding contentEncoding;
        private String ddtags;

        public SubmitLogOptionalParameters contentEncoding(ContentEncoding contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public SubmitLogOptionalParameters ddtags(String ddtags) {
            this.ddtags = ddtags;
            return this;
        }
    }
}

