/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Creator;
import com.datadog.api.client.v1.model.MonitorOverallStates;
import com.datadog.api.client.v1.model.MonitorSearchResultNotification;
import com.datadog.api.client.v1.model.MonitorType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"classification", "creator", "id", "last_triggered_ts", "metrics", "name", "notifications", "org_id", "quality_issues", "query", "scopes", "status", "tags", "type"})
public class MonitorSearchResult {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CLASSIFICATION = "classification";
    private String classification;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_LAST_TRIGGERED_TS = "last_triggered_ts";
    private JsonNullable<Long> lastTriggeredTs = JsonNullable.undefined();
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private List<String> metrics = null;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private List<MonitorSearchResultNotification> notifications = null;
    public static final String JSON_PROPERTY_ORG_ID = "org_id";
    private Long orgId;
    public static final String JSON_PROPERTY_QUALITY_ISSUES = "quality_issues";
    private List<String> qualityIssues = null;
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private MonitorOverallStates status;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MonitorType type;
    private Map<String, Object> additionalProperties;

    @Nullable
    @JsonProperty(value="classification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClassification() {
        return this.classification;
    }

    @Nullable
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    @Nullable
    @JsonIgnore
    public Long getLastTriggeredTs() {
        if (this.lastTriggeredTs == null) {
            this.lastTriggeredTs = JsonNullable.undefined();
        }
        return (Long)this.lastTriggeredTs.orElse(null);
    }

    @JsonProperty(value="last_triggered_ts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getLastTriggeredTs_JsonNullable() {
        return this.lastTriggeredTs;
    }

    @JsonProperty(value="last_triggered_ts")
    private void setLastTriggeredTs_JsonNullable(JsonNullable<Long> lastTriggeredTs) {
        this.lastTriggeredTs = lastTriggeredTs;
    }

    @Nullable
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getMetrics() {
        return this.metrics;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @Nullable
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorSearchResultNotification> getNotifications() {
        return this.notifications;
    }

    @Nullable
    @JsonProperty(value="org_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getOrgId() {
        return this.orgId;
    }

    @Nullable
    @JsonProperty(value="quality_issues")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getQualityIssues() {
        return this.qualityIssues;
    }

    public MonitorSearchResult query(String query) {
        this.query = query;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public MonitorSearchResult scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public MonitorSearchResult addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOverallStates getStatus() {
        return this.status;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public MonitorSearchResult type(MonitorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorType getType() {
        return this.type;
    }

    public void setType(MonitorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public MonitorSearchResult putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorSearchResult monitorSearchResult = (MonitorSearchResult)o;
        return Objects.equals(this.classification, monitorSearchResult.classification) && Objects.equals(this.creator, monitorSearchResult.creator) && Objects.equals(this.id, monitorSearchResult.id) && Objects.equals(this.lastTriggeredTs, monitorSearchResult.lastTriggeredTs) && Objects.equals(this.metrics, monitorSearchResult.metrics) && Objects.equals(this.name, monitorSearchResult.name) && Objects.equals(this.notifications, monitorSearchResult.notifications) && Objects.equals(this.orgId, monitorSearchResult.orgId) && Objects.equals(this.qualityIssues, monitorSearchResult.qualityIssues) && Objects.equals(this.query, monitorSearchResult.query) && Objects.equals(this.scopes, monitorSearchResult.scopes) && Objects.equals(this.status, monitorSearchResult.status) && Objects.equals(this.tags, monitorSearchResult.tags) && Objects.equals(this.type, monitorSearchResult.type) && Objects.equals(this.additionalProperties, monitorSearchResult.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.classification, this.creator, this.id, this.lastTriggeredTs, this.metrics, this.name, this.notifications, this.orgId, this.qualityIssues, this.query, this.scopes, this.status, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorSearchResult {\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastTriggeredTs: ").append(this.toIndentedString(this.lastTriggeredTs)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    qualityIssues: ").append(this.toIndentedString(this.qualityIssues)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

