/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.Creator;
import com.datadog.api.client.v1.model.MatchingDowntime;
import com.datadog.api.client.v1.model.MonitorDraftStatus;
import com.datadog.api.client.v1.model.MonitorOptions;
import com.datadog.api.client.v1.model.MonitorOverallStates;
import com.datadog.api.client.v1.model.MonitorState;
import com.datadog.api.client.v1.model.MonitorType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"created", "creator", "deleted", "draft_status", "id", "matching_downtimes", "message", "modified", "multi", "name", "options", "overall_state", "priority", "query", "restricted_roles", "state", "tags", "type"})
public class Monitor {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private Creator creator;
    public static final String JSON_PROPERTY_DELETED = "deleted";
    private JsonNullable<OffsetDateTime> deleted = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DRAFT_STATUS = "draft_status";
    private MonitorDraftStatus draftStatus = MonitorDraftStatus.PUBLISHED;
    public static final String JSON_PROPERTY_ID = "id";
    private Long id;
    public static final String JSON_PROPERTY_MATCHING_DOWNTIMES = "matching_downtimes";
    private List<MatchingDowntime> matchingDowntimes = null;
    public static final String JSON_PROPERTY_MESSAGE = "message";
    private String message;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    public static final String JSON_PROPERTY_MULTI = "multi";
    private Boolean multi;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OPTIONS = "options";
    private MonitorOptions options;
    public static final String JSON_PROPERTY_OVERALL_STATE = "overall_state";
    private MonitorOverallStates overallState;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private JsonNullable<Long> priority = JsonNullable.undefined();
    public static final String JSON_PROPERTY_QUERY = "query";
    private String query;
    public static final String JSON_PROPERTY_RESTRICTED_ROLES = "restricted_roles";
    private JsonNullable<List<String>> restrictedRoles = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private MonitorState state;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private MonitorType type;
    private Map<String, Object> additionalProperties;

    public Monitor() {
    }

    @JsonCreator
    public Monitor(@JsonProperty(required=true, value="query") String query, @JsonProperty(required=true, value="type") MonitorType type) {
        this.query = query;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    @Nullable
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Creator getCreator() {
        return this.creator;
    }

    @Nullable
    @JsonIgnore
    public OffsetDateTime getDeleted() {
        if (this.deleted == null) {
            this.deleted = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.deleted.orElse(null);
    }

    @JsonProperty(value="deleted")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getDeleted_JsonNullable() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    private void setDeleted_JsonNullable(JsonNullable<OffsetDateTime> deleted) {
        this.deleted = deleted;
    }

    public Monitor draftStatus(MonitorDraftStatus draftStatus) {
        this.draftStatus = draftStatus;
        this.unparsed |= !draftStatus.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="draft_status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorDraftStatus getDraftStatus() {
        return this.draftStatus;
    }

    public void setDraftStatus(MonitorDraftStatus draftStatus) {
        if (!draftStatus.isValid()) {
            this.unparsed = true;
        }
        this.draftStatus = draftStatus;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getId() {
        return this.id;
    }

    public Monitor matchingDowntimes(List<MatchingDowntime> matchingDowntimes) {
        this.matchingDowntimes = matchingDowntimes;
        for (MatchingDowntime item : matchingDowntimes) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public Monitor addMatchingDowntimesItem(MatchingDowntime matchingDowntimesItem) {
        if (this.matchingDowntimes == null) {
            this.matchingDowntimes = new ArrayList<MatchingDowntime>();
        }
        this.matchingDowntimes.add(matchingDowntimesItem);
        this.unparsed |= matchingDowntimesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="matching_downtimes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MatchingDowntime> getMatchingDowntimes() {
        return this.matchingDowntimes;
    }

    public void setMatchingDowntimes(List<MatchingDowntime> matchingDowntimes) {
        this.matchingDowntimes = matchingDowntimes;
    }

    public Monitor message(String message) {
        this.message = message;
        return this;
    }

    @Nullable
    @JsonProperty(value="message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Nullable
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @Nullable
    @JsonProperty(value="multi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMulti() {
        return this.multi;
    }

    public Monitor name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Monitor options(MonitorOptions options) {
        this.options = options;
        this.unparsed |= options.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptions getOptions() {
        return this.options;
    }

    public void setOptions(MonitorOptions options) {
        this.options = options;
    }

    @Nullable
    @JsonProperty(value="overall_state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOverallStates getOverallState() {
        return this.overallState;
    }

    public Monitor priority(Long priority) {
        this.priority = JsonNullable.of((Object)priority);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getPriority() {
        return (Long)this.priority.orElse(null);
    }

    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getPriority_JsonNullable() {
        return this.priority;
    }

    @JsonProperty(value="priority")
    public void setPriority_JsonNullable(JsonNullable<Long> priority) {
        this.priority = priority;
    }

    public void setPriority(Long priority) {
        this.priority = JsonNullable.of((Object)priority);
    }

    public Monitor query(String query) {
        this.query = query;
        return this;
    }

    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Monitor restrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = JsonNullable.of(restrictedRoles);
        return this;
    }

    public Monitor addRestrictedRolesItem(String restrictedRolesItem) {
        if (this.restrictedRoles == null || !this.restrictedRoles.isPresent()) {
            this.restrictedRoles = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.restrictedRoles.get()).add(restrictedRolesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<String> getRestrictedRoles() {
        return (List)this.restrictedRoles.orElse(null);
    }

    @JsonProperty(value="restricted_roles")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getRestrictedRoles_JsonNullable() {
        return this.restrictedRoles;
    }

    @JsonProperty(value="restricted_roles")
    public void setRestrictedRoles_JsonNullable(JsonNullable<List<String>> restrictedRoles) {
        this.restrictedRoles = restrictedRoles;
    }

    public void setRestrictedRoles(List<String> restrictedRoles) {
        this.restrictedRoles = JsonNullable.of(restrictedRoles);
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorState getState() {
        return this.state;
    }

    public Monitor tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Monitor addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Monitor type(MonitorType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public MonitorType getType() {
        return this.type;
    }

    public void setType(MonitorType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public Monitor putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Monitor monitor = (Monitor)o;
        return Objects.equals(this.created, monitor.created) && Objects.equals(this.creator, monitor.creator) && Objects.equals(this.deleted, monitor.deleted) && Objects.equals(this.draftStatus, monitor.draftStatus) && Objects.equals(this.id, monitor.id) && Objects.equals(this.matchingDowntimes, monitor.matchingDowntimes) && Objects.equals(this.message, monitor.message) && Objects.equals(this.modified, monitor.modified) && Objects.equals(this.multi, monitor.multi) && Objects.equals(this.name, monitor.name) && Objects.equals(this.options, monitor.options) && Objects.equals(this.overallState, monitor.overallState) && Objects.equals(this.priority, monitor.priority) && Objects.equals(this.query, monitor.query) && Objects.equals(this.restrictedRoles, monitor.restrictedRoles) && Objects.equals(this.state, monitor.state) && Objects.equals(this.tags, monitor.tags) && Objects.equals(this.type, monitor.type) && Objects.equals(this.additionalProperties, monitor.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.creator, this.deleted, this.draftStatus, this.id, this.matchingDowntimes, this.message, this.modified, this.multi, this.name, this.options, this.overallState, this.priority, this.query, this.restrictedRoles, this.state, this.tags, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Monitor {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    deleted: ").append(this.toIndentedString(this.deleted)).append("\n");
        sb.append("    draftStatus: ").append(this.toIndentedString(this.draftStatus)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    matchingDowntimes: ").append(this.toIndentedString(this.matchingDowntimes)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    multi: ").append(this.toIndentedString(this.multi)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    overallState: ").append(this.toIndentedString(this.overallState)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    restrictedRoles: ").append(this.toIndentedString(this.restrictedRoles)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

