/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=SyntheticsTestExecutionRuleSerializer.class)
public class SyntheticsTestExecutionRule {
    public static final SyntheticsTestExecutionRule BLOCKING = new SyntheticsTestExecutionRule("blocking");
    public static final SyntheticsTestExecutionRule NON_BLOCKING = new SyntheticsTestExecutionRule("non_blocking");
    public static final SyntheticsTestExecutionRule SKIPPED = new SyntheticsTestExecutionRule("skipped");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("blocking", "non_blocking", "skipped"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    SyntheticsTestExecutionRule(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((SyntheticsTestExecutionRule)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static SyntheticsTestExecutionRule fromValue(String value) {
        return new SyntheticsTestExecutionRule(value);
    }

    public static class SyntheticsTestExecutionRuleSerializer
    extends StdSerializer<SyntheticsTestExecutionRule> {
        public SyntheticsTestExecutionRuleSerializer(Class<SyntheticsTestExecutionRule> t) {
            super(t);
        }

        public SyntheticsTestExecutionRuleSerializer() {
            this(null);
        }

        public void serialize(SyntheticsTestExecutionRule value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

