/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.SyntheticsBasicAuthNTLMType;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"domain", "password", "type", "username", "workstation"})
public class SyntheticsBasicAuthNTLM {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_TYPE = "type";
    private SyntheticsBasicAuthNTLMType type = SyntheticsBasicAuthNTLMType.NTLM;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_WORKSTATION = "workstation";
    private String workstation;

    public SyntheticsBasicAuthNTLM() {
    }

    @JsonCreator
    public SyntheticsBasicAuthNTLM(@JsonProperty(required=true, value="type") SyntheticsBasicAuthNTLMType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public SyntheticsBasicAuthNTLM domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nullable
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public SyntheticsBasicAuthNTLM password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SyntheticsBasicAuthNTLM type(SyntheticsBasicAuthNTLMType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SyntheticsBasicAuthNTLMType getType() {
        return this.type;
    }

    public void setType(SyntheticsBasicAuthNTLMType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public SyntheticsBasicAuthNTLM username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public SyntheticsBasicAuthNTLM workstation(String workstation) {
        this.workstation = workstation;
        return this;
    }

    @Nullable
    @JsonProperty(value="workstation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SyntheticsBasicAuthNTLM syntheticsBasicAuthNtlm = (SyntheticsBasicAuthNTLM)o;
        return Objects.equals(this.domain, syntheticsBasicAuthNtlm.domain) && Objects.equals(this.password, syntheticsBasicAuthNtlm.password) && Objects.equals(this.type, syntheticsBasicAuthNtlm.type) && Objects.equals(this.username, syntheticsBasicAuthNtlm.username) && Objects.equals(this.workstation, syntheticsBasicAuthNtlm.workstation);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.password, this.type, this.username, this.workstation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SyntheticsBasicAuthNTLM {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    workstation: ").append(this.toIndentedString(this.workstation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

